/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import java.util.Locale;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;

final class ReadCursor {
    private final long beginning;
    private long offset;
    private final long limit;

    ReadCursor(long beginning, long limit) {
        this.limit = limit;
        this.beginning = beginning;
        this.offset = beginning;
    }

    public boolean hasRemaining() {
        return this.limit - this.offset > 0L;
    }

    public void advance(long incr) {
        Preconditions.checkArgument(incr >= 0L);
        this.offset += incr;
    }

    public long read() {
        return this.offset - this.beginning;
    }

    public String toString() {
        return String.format(Locale.US, "ReadCursor{begin=%d, offset=%d, limit=%d}", this.beginning, this.offset, this.limit);
    }
}

