/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.ApiFuture;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallContext;
import com.google.api.gax.httpjson.HttpJsonClientCall;
import com.google.api.gax.httpjson.HttpJsonClientCalls;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.TypeRegistry;

class HttpJsonDirectCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final ApiMethodDescriptor<RequestT, ResponseT> descriptor;
    private final TypeRegistry typeRegistry;

    HttpJsonDirectCallable(ApiMethodDescriptor<RequestT, ResponseT> descriptor) {
        this(descriptor, null);
    }

    HttpJsonDirectCallable(ApiMethodDescriptor<RequestT, ResponseT> descriptor, TypeRegistry typeRegistry) {
        this.descriptor = descriptor;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        Preconditions.checkNotNull(request);
        HttpJsonCallContext context = HttpJsonCallContext.createDefault().nullToSelf(inputContext);
        context = context.withCallOptions(context.getCallOptions().toBuilder().setTypeRegistry(this.typeRegistry).build());
        HttpJsonClientCall<RequestT, ResponseT> clientCall = HttpJsonClientCalls.newCall(this.descriptor, context);
        return HttpJsonClientCalls.futureUnaryCall(clientCall, request, context);
    }

    public String toString() {
        return String.format("direct(%s)", this.descriptor);
    }
}

