/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.BaseFileWriterFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataWriter;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class GenericFileWriterFactory
extends BaseFileWriterFactory<Record> {
    GenericFileWriterFactory(Table table, FileFormat dataFileFormat, Schema dataSchema, SortOrder dataSortOrder, FileFormat deleteFileFormat, int[] equalityFieldIds, Schema equalityDeleteRowSchema, SortOrder equalityDeleteSortOrder, Schema positionDeleteRowSchema) {
        super(table, dataFileFormat, dataSchema, dataSortOrder, deleteFileFormat, equalityFieldIds, equalityDeleteRowSchema, equalityDeleteSortOrder, positionDeleteRowSchema);
    }

    static Builder builderFor(Table table) {
        return new Builder(table);
    }

    @Override
    protected void configureDataWrite(Avro.DataWriteBuilder builder) {
        builder.createWriterFunc(DataWriter::create);
    }

    @Override
    protected void configureEqualityDelete(Avro.DeleteWriteBuilder builder) {
        builder.createWriterFunc(DataWriter::create);
    }

    @Override
    protected void configurePositionDelete(Avro.DeleteWriteBuilder builder) {
        builder.createWriterFunc(DataWriter::create);
    }

    @Override
    protected void configureDataWrite(Parquet.DataWriteBuilder builder) {
        builder.createWriterFunc(GenericParquetWriter::create);
    }

    @Override
    protected void configureEqualityDelete(Parquet.DeleteWriteBuilder builder) {
        builder.createWriterFunc(GenericParquetWriter::create);
    }

    @Override
    protected void configurePositionDelete(Parquet.DeleteWriteBuilder builder) {
        builder.createWriterFunc(GenericParquetWriter::create);
    }

    @Override
    protected void configureDataWrite(ORC.DataWriteBuilder builder) {
        builder.createWriterFunc(GenericOrcWriter::buildWriter);
    }

    @Override
    protected void configureEqualityDelete(ORC.DeleteWriteBuilder builder) {
        builder.createWriterFunc(GenericOrcWriter::buildWriter);
    }

    @Override
    protected void configurePositionDelete(ORC.DeleteWriteBuilder builder) {
        builder.createWriterFunc(GenericOrcWriter::buildWriter);
    }

    static class Builder {
        private final Table table;
        private FileFormat dataFileFormat;
        private Schema dataSchema;
        private SortOrder dataSortOrder;
        private FileFormat deleteFileFormat;
        private int[] equalityFieldIds;
        private Schema equalityDeleteRowSchema;
        private SortOrder equalityDeleteSortOrder;
        private Schema positionDeleteRowSchema;

        Builder(Table table) {
            this.table = table;
            this.dataSchema = table.schema();
            Map properties = table.properties();
            String dataFileFormatName = properties.getOrDefault("write.format.default", "parquet");
            this.dataFileFormat = FileFormat.fromString((String)dataFileFormatName);
            String deleteFileFormatName = properties.getOrDefault("write.delete.format.default", dataFileFormatName);
            this.deleteFileFormat = FileFormat.fromString((String)deleteFileFormatName);
        }

        Builder dataFileFormat(FileFormat newDataFileFormat) {
            this.dataFileFormat = newDataFileFormat;
            return this;
        }

        Builder dataSchema(Schema newDataSchema) {
            this.dataSchema = newDataSchema;
            return this;
        }

        Builder dataSortOrder(SortOrder newDataSortOrder) {
            this.dataSortOrder = newDataSortOrder;
            return this;
        }

        Builder deleteFileFormat(FileFormat newDeleteFileFormat) {
            this.deleteFileFormat = newDeleteFileFormat;
            return this;
        }

        Builder equalityFieldIds(int[] newEqualityFieldIds) {
            this.equalityFieldIds = newEqualityFieldIds;
            return this;
        }

        Builder equalityDeleteRowSchema(Schema newEqualityDeleteRowSchema) {
            this.equalityDeleteRowSchema = newEqualityDeleteRowSchema;
            return this;
        }

        Builder equalityDeleteSortOrder(SortOrder newEqualityDeleteSortOrder) {
            this.equalityDeleteSortOrder = newEqualityDeleteSortOrder;
            return this;
        }

        Builder positionDeleteRowSchema(Schema newPositionDeleteRowSchema) {
            this.positionDeleteRowSchema = newPositionDeleteRowSchema;
            return this;
        }

        GenericFileWriterFactory build() {
            boolean noEqualityDeleteConf = this.equalityFieldIds == null && this.equalityDeleteRowSchema == null;
            boolean fullEqualityDeleteConf = this.equalityFieldIds != null && this.equalityDeleteRowSchema != null;
            Preconditions.checkArgument((noEqualityDeleteConf || fullEqualityDeleteConf ? 1 : 0) != 0, (Object)"Equality field IDs and equality delete row schema must be set together");
            return new GenericFileWriterFactory(this.table, this.dataFileFormat, this.dataSchema, this.dataSortOrder, this.deleteFileFormat, this.equalityFieldIds, this.equalityDeleteRowSchema, this.equalityDeleteSortOrder, this.positionDeleteRowSchema);
        }
    }
}

