/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import java.net.InetSocketAddress;
import java.util.Collections;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelOption;
import org.apache.iceberg.azure.shaded.io.netty.util.NetUtil;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.udp.UdpClient;
import reactor.netty.udp.UdpClientConfig;

final class UdpClientConnect
extends UdpClient {
    static final UdpClientConnect INSTANCE;
    final UdpClientConfig config;
    static final int DEFAULT_PORT;

    UdpClientConnect() {
        this.config = new UdpClientConfig(ConnectionProvider.newConnection(), Collections.singletonMap(ChannelOption.AUTO_READ, false), () -> new InetSocketAddress(NetUtil.LOCALHOST, DEFAULT_PORT));
    }

    UdpClientConnect(UdpClientConfig config) {
        this.config = config;
    }

    @Override
    public UdpClientConfig configuration() {
        return this.config;
    }

    @Override
    protected UdpClient duplicate() {
        return new UdpClientConnect(new UdpClientConfig(this.config));
    }

    static {
        int port;
        INSTANCE = new UdpClientConnect();
        String portStr = null;
        try {
            portStr = System.getenv("PORT");
            port = portStr != null ? Integer.parseInt(portStr) : 12012;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid environment variable [PORT=" + portStr + "].", e);
        }
        DEFAULT_PORT = port;
    }
}

