/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class Path
implements JsonSerializable<Path> {
    private String name;
    private Boolean isDirectory;
    private String lastModified;
    private Long contentLength;
    private String owner;
    private String group;
    private String permissions;
    private String encryptionScope;
    private String creationTime;
    private String expiryTime;
    private String encryptionContext;
    private String eTag;

    public String getName() {
        return this.name;
    }

    public Path setName(String name) {
        this.name = name;
        return this;
    }

    public Boolean isDirectory() {
        return this.isDirectory;
    }

    public Path setIsDirectory(Boolean isDirectory) {
        this.isDirectory = isDirectory;
        return this;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public Path setLastModified(String lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public Path setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public Path setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public Path setGroup(String group) {
        this.group = group;
        return this;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public Path setPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public Path setEncryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope;
        return this;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public Path setCreationTime(String creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public String getExpiryTime() {
        return this.expiryTime;
    }

    public Path setExpiryTime(String expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String getEncryptionContext() {
        return this.encryptionContext;
    }

    public Path setEncryptionContext(String encryptionContext) {
        this.encryptionContext = encryptionContext;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public Path setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        if (this.isDirectory != null) {
            jsonWriter.writeStringField("isDirectory", String.valueOf(this.isDirectory));
        }
        jsonWriter.writeStringField("lastModified", this.lastModified);
        if (this.contentLength != null) {
            jsonWriter.writeStringField("contentLength", String.valueOf(this.contentLength));
        }
        jsonWriter.writeStringField("owner", this.owner);
        jsonWriter.writeStringField("group", this.group);
        jsonWriter.writeStringField("permissions", this.permissions);
        jsonWriter.writeStringField("EncryptionScope", this.encryptionScope);
        jsonWriter.writeStringField("creationTime", this.creationTime);
        jsonWriter.writeStringField("expiryTime", this.expiryTime);
        jsonWriter.writeStringField("EncryptionContext", this.encryptionContext);
        jsonWriter.writeStringField("etag", this.eTag);
        return jsonWriter.writeEndObject();
    }

    public static Path fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Path deserializedPath = new Path();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                JsonToken token;
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedPath.name = reader.getString();
                    continue;
                }
                if ("isDirectory".equals(fieldName)) {
                    token = reader.currentToken();
                    if (token == JsonToken.STRING) {
                        deserializedPath.isDirectory = Boolean.parseBoolean(reader.getString());
                        continue;
                    }
                    if (token == JsonToken.BOOLEAN) {
                        deserializedPath.isDirectory = reader.getBoolean();
                        continue;
                    }
                    if (token == JsonToken.NULL) {
                        deserializedPath.isDirectory = null;
                        continue;
                    }
                    throw new IllegalStateException("Invalid token, expected one of STRING, BOOLEAN, or NULL. Was " + (Object)((Object)token));
                }
                if ("lastModified".equals(fieldName)) {
                    deserializedPath.lastModified = reader.getString();
                    continue;
                }
                if ("contentLength".equals(fieldName)) {
                    token = reader.currentToken();
                    if (token == JsonToken.STRING) {
                        deserializedPath.contentLength = Long.parseLong(reader.getString());
                        continue;
                    }
                    if (token == JsonToken.NUMBER) {
                        deserializedPath.contentLength = reader.getLong();
                        continue;
                    }
                    if (token == JsonToken.NULL) {
                        deserializedPath.contentLength = null;
                        continue;
                    }
                    throw new IllegalStateException("Invalid token, expected one of STRING, NUMBER, or NULL. Was " + (Object)((Object)token));
                }
                if ("owner".equals(fieldName)) {
                    deserializedPath.owner = reader.getString();
                    continue;
                }
                if ("group".equals(fieldName)) {
                    deserializedPath.group = reader.getString();
                    continue;
                }
                if ("permissions".equals(fieldName)) {
                    deserializedPath.permissions = reader.getString();
                    continue;
                }
                if ("EncryptionScope".equals(fieldName)) {
                    deserializedPath.encryptionScope = reader.getString();
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedPath.creationTime = reader.getString();
                    continue;
                }
                if ("expiryTime".equals(fieldName)) {
                    deserializedPath.expiryTime = reader.getString();
                    continue;
                }
                if ("EncryptionContext".equals(fieldName)) {
                    deserializedPath.encryptionContext = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedPath.eTag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPath;
        });
    }
}

