/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobPropertiesInternal
implements XmlSerializable<BlobPropertiesInternal> {
    private DateTimeRfc1123 creationTime;
    private DateTimeRfc1123 lastModified;
    private String etag;
    private Long contentLength;
    private String contentType;
    private String contentEncoding;
    private String contentLanguage;
    private byte[] contentMD5;
    private String contentDisposition;
    private String cacheControl;
    private Long blobSequenceNumber;
    private String copyId;
    private String copySource;
    private String copyProgress;
    private DateTimeRfc1123 copyCompletionTime;
    private String copyStatusDescription;
    private Boolean serverEncrypted;
    private Boolean incrementalCopy;
    private String destinationSnapshot;
    private DateTimeRfc1123 deletedTime;
    private Integer remainingRetentionDays;
    private Boolean accessTierInferred;
    private String customerProvidedKeySha256;
    private String encryptionScope;
    private DateTimeRfc1123 accessTierChangeTime;
    private Integer tagCount;
    private DateTimeRfc1123 expiresOn;
    private Boolean isSealed;
    private DateTimeRfc1123 lastAccessedOn;
    private DateTimeRfc1123 deleteTime;

    public OffsetDateTime getCreationTime() {
        if (this.creationTime == null) {
            return null;
        }
        return this.creationTime.getDateTime();
    }

    public BlobPropertiesInternal setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime == null ? null : new DateTimeRfc1123(creationTime);
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobPropertiesInternal setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getEtag() {
        return this.etag;
    }

    public BlobPropertiesInternal setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public BlobPropertiesInternal setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BlobPropertiesInternal setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public BlobPropertiesInternal setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public BlobPropertiesInternal setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone(this.contentMD5);
    }

    public BlobPropertiesInternal setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone(contentMD5);
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public BlobPropertiesInternal setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public BlobPropertiesInternal setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public BlobPropertiesInternal setBlobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
        return this;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public BlobPropertiesInternal setCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public BlobPropertiesInternal setCopySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public String getCopyProgress() {
        return this.copyProgress;
    }

    public BlobPropertiesInternal setCopyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public OffsetDateTime getCopyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.getDateTime();
    }

    public BlobPropertiesInternal setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    public BlobPropertiesInternal setCopyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.serverEncrypted;
    }

    public BlobPropertiesInternal setServerEncrypted(Boolean serverEncrypted) {
        this.serverEncrypted = serverEncrypted;
        return this;
    }

    public Boolean isIncrementalCopy() {
        return this.incrementalCopy;
    }

    public BlobPropertiesInternal setIncrementalCopy(Boolean incrementalCopy) {
        this.incrementalCopy = incrementalCopy;
        return this;
    }

    public String getDestinationSnapshot() {
        return this.destinationSnapshot;
    }

    public BlobPropertiesInternal setDestinationSnapshot(String destinationSnapshot) {
        this.destinationSnapshot = destinationSnapshot;
        return this;
    }

    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    public BlobPropertiesInternal setDeletedTime(OffsetDateTime deletedTime) {
        this.deletedTime = deletedTime == null ? null : new DateTimeRfc1123(deletedTime);
        return this;
    }

    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public BlobPropertiesInternal setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    public Boolean isAccessTierInferred() {
        return this.accessTierInferred;
    }

    public BlobPropertiesInternal setAccessTierInferred(Boolean accessTierInferred) {
        this.accessTierInferred = accessTierInferred;
        return this;
    }

    public String getCustomerProvidedKeySha256() {
        return this.customerProvidedKeySha256;
    }

    public BlobPropertiesInternal setCustomerProvidedKeySha256(String customerProvidedKeySha256) {
        this.customerProvidedKeySha256 = customerProvidedKeySha256;
        return this;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public BlobPropertiesInternal setEncryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope;
        return this;
    }

    public OffsetDateTime getAccessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.getDateTime();
    }

    public BlobPropertiesInternal setAccessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        this.accessTierChangeTime = accessTierChangeTime == null ? null : new DateTimeRfc1123(accessTierChangeTime);
        return this;
    }

    public Integer getTagCount() {
        return this.tagCount;
    }

    public BlobPropertiesInternal setTagCount(Integer tagCount) {
        this.tagCount = tagCount;
        return this;
    }

    public OffsetDateTime getExpiresOn() {
        if (this.expiresOn == null) {
            return null;
        }
        return this.expiresOn.getDateTime();
    }

    public BlobPropertiesInternal setExpiresOn(OffsetDateTime expiresOn) {
        this.expiresOn = expiresOn == null ? null : new DateTimeRfc1123(expiresOn);
        return this;
    }

    public Boolean isSealed() {
        return this.isSealed;
    }

    public BlobPropertiesInternal setIsSealed(Boolean isSealed) {
        this.isSealed = isSealed;
        return this;
    }

    public OffsetDateTime getLastAccessedOn() {
        if (this.lastAccessedOn == null) {
            return null;
        }
        return this.lastAccessedOn.getDateTime();
    }

    public BlobPropertiesInternal setLastAccessedOn(OffsetDateTime lastAccessedOn) {
        this.lastAccessedOn = lastAccessedOn == null ? null : new DateTimeRfc1123(lastAccessedOn);
        return this;
    }

    public OffsetDateTime getDeleteTime() {
        if (this.deleteTime == null) {
            return null;
        }
        return this.deleteTime.getDateTime();
    }

    public BlobPropertiesInternal setDeleteTime(OffsetDateTime deleteTime) {
        this.deleteTime = deleteTime == null ? null : new DateTimeRfc1123(deleteTime);
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Properties" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Creation-Time", Objects.toString(this.creationTime, null));
        xmlWriter.writeStringElement("Last-Modified", Objects.toString(this.lastModified, null));
        xmlWriter.writeStringElement("Etag", this.etag);
        xmlWriter.writeNumberElement("Content-Length", this.contentLength);
        xmlWriter.writeStringElement("Content-Type", this.contentType);
        xmlWriter.writeStringElement("Content-Encoding", this.contentEncoding);
        xmlWriter.writeStringElement("Content-Language", this.contentLanguage);
        xmlWriter.writeBinaryElement("Content-MD5", this.contentMD5);
        xmlWriter.writeStringElement("Content-Disposition", this.contentDisposition);
        xmlWriter.writeStringElement("Cache-Control", this.cacheControl);
        xmlWriter.writeNumberElement("x-ms-blob-sequence-number", this.blobSequenceNumber);
        xmlWriter.writeStringElement("CopyId", this.copyId);
        xmlWriter.writeStringElement("CopySource", this.copySource);
        xmlWriter.writeStringElement("CopyProgress", this.copyProgress);
        xmlWriter.writeStringElement("CopyCompletionTime", Objects.toString(this.copyCompletionTime, null));
        xmlWriter.writeStringElement("CopyStatusDescription", this.copyStatusDescription);
        xmlWriter.writeBooleanElement("ServerEncrypted", this.serverEncrypted);
        xmlWriter.writeBooleanElement("IncrementalCopy", this.incrementalCopy);
        xmlWriter.writeStringElement("DestinationSnapshot", this.destinationSnapshot);
        xmlWriter.writeStringElement("DeletedTime", Objects.toString(this.deletedTime, null));
        xmlWriter.writeNumberElement("RemainingRetentionDays", this.remainingRetentionDays);
        xmlWriter.writeBooleanElement("AccessTierInferred", this.accessTierInferred);
        xmlWriter.writeStringElement("CustomerProvidedKeySha256", this.customerProvidedKeySha256);
        xmlWriter.writeStringElement("EncryptionScope", this.encryptionScope);
        xmlWriter.writeStringElement("AccessTierChangeTime", Objects.toString(this.accessTierChangeTime, null));
        xmlWriter.writeNumberElement("TagCount", this.tagCount);
        xmlWriter.writeStringElement("Expiry-Time", Objects.toString(this.expiresOn, null));
        xmlWriter.writeBooleanElement("Sealed", this.isSealed);
        xmlWriter.writeStringElement("LastAccessTime", Objects.toString(this.lastAccessedOn, null));
        xmlWriter.writeStringElement("DeleteTime", Objects.toString(this.deleteTime, null));
        return xmlWriter.writeEndElement();
    }

    public static BlobPropertiesInternal fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobPropertiesInternal.fromXml(xmlReader, null);
    }

    public static BlobPropertiesInternal fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Properties" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            BlobPropertiesInternal deserializedBlobPropertiesInternal = new BlobPropertiesInternal();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Creation-Time".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.creationTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("Last-Modified".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.lastModified = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("Etag".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.etag = reader.getStringElement();
                    continue;
                }
                if ("Content-Length".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.contentLength = reader.getNullableElement(Long::parseLong);
                    continue;
                }
                if ("Content-Type".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.contentType = reader.getStringElement();
                    continue;
                }
                if ("Content-Encoding".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.contentEncoding = reader.getStringElement();
                    continue;
                }
                if ("Content-Language".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.contentLanguage = reader.getStringElement();
                    continue;
                }
                if ("Content-MD5".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.contentMD5 = reader.getBinaryElement();
                    continue;
                }
                if ("Content-Disposition".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.contentDisposition = reader.getStringElement();
                    continue;
                }
                if ("Cache-Control".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.cacheControl = reader.getStringElement();
                    continue;
                }
                if ("x-ms-blob-sequence-number".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.blobSequenceNumber = reader.getNullableElement(Long::parseLong);
                    continue;
                }
                if ("CopyId".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.copyId = reader.getStringElement();
                    continue;
                }
                if ("CopySource".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.copySource = reader.getStringElement();
                    continue;
                }
                if ("CopyProgress".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.copyProgress = reader.getStringElement();
                    continue;
                }
                if ("CopyCompletionTime".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.copyCompletionTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("CopyStatusDescription".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.copyStatusDescription = reader.getStringElement();
                    continue;
                }
                if ("ServerEncrypted".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.serverEncrypted = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("IncrementalCopy".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.incrementalCopy = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("DestinationSnapshot".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.destinationSnapshot = reader.getStringElement();
                    continue;
                }
                if ("DeletedTime".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.deletedTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("RemainingRetentionDays".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.remainingRetentionDays = reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("AccessTierInferred".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.accessTierInferred = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("CustomerProvidedKeySha256".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.customerProvidedKeySha256 = reader.getStringElement();
                    continue;
                }
                if ("EncryptionScope".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.encryptionScope = reader.getStringElement();
                    continue;
                }
                if ("AccessTierChangeTime".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.accessTierChangeTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("TagCount".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.tagCount = reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("Expiry-Time".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.expiresOn = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("Sealed".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.isSealed = reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("LastAccessTime".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.lastAccessedOn = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                if ("DeleteTime".equals(elementName.getLocalPart())) {
                    deserializedBlobPropertiesInternal.deleteTime = reader.getNullableElement(DateTimeRfc1123::new);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobPropertiesInternal;
        });
    }
}

