/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.models.BlobContainerAccessPolicies;
import com.azure.storage.blob.models.BlobContainerProperties;
import com.azure.storage.blob.options.BlobContainerCreateOptions;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemAsyncClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClientBuilder;
import com.azure.storage.file.datalake.DataLakePathAsyncClient;
import com.azure.storage.file.datalake.DataLakePathClient;
import com.azure.storage.file.datalake.DataLakeServiceVersion;
import com.azure.storage.file.datalake.Transforms;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImpl;
import com.azure.storage.file.datalake.implementation.AzureDataLakeStorageRestAPIImplBuilder;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListBlobHierarchySegmentHeaders;
import com.azure.storage.file.datalake.implementation.models.FileSystemsListPathsHeaders;
import com.azure.storage.file.datalake.implementation.models.ListBlobsHierarchySegmentResponse;
import com.azure.storage.file.datalake.implementation.models.ListBlobsShowOnly;
import com.azure.storage.file.datalake.implementation.models.PathList;
import com.azure.storage.file.datalake.implementation.models.PathResourceType;
import com.azure.storage.file.datalake.implementation.models.PathsUndeleteHeaders;
import com.azure.storage.file.datalake.implementation.util.DataLakeImplUtils;
import com.azure.storage.file.datalake.implementation.util.DataLakeSasImplUtil;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.DataLakeSignedIdentifier;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import com.azure.storage.file.datalake.models.FileSystemAccessPolicies;
import com.azure.storage.file.datalake.models.FileSystemProperties;
import com.azure.storage.file.datalake.models.ListPathsOptions;
import com.azure.storage.file.datalake.models.PathDeletedItem;
import com.azure.storage.file.datalake.models.PathHttpHeaders;
import com.azure.storage.file.datalake.models.PathInfo;
import com.azure.storage.file.datalake.models.PathItem;
import com.azure.storage.file.datalake.models.PublicAccessType;
import com.azure.storage.file.datalake.models.UserDelegationKey;
import com.azure.storage.file.datalake.options.DataLakePathCreateOptions;
import com.azure.storage.file.datalake.options.DataLakePathDeleteOptions;
import com.azure.storage.file.datalake.sas.DataLakeServiceSasSignatureValues;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@ServiceClient(builder=DataLakeFileSystemClientBuilder.class)
public class DataLakeFileSystemClient {
    private static final ClientLogger LOGGER = new ClientLogger(DataLakeFileSystemClient.class);
    private final AzureDataLakeStorageRestAPIImpl azureDataLakeStorage;
    private final AzureDataLakeStorageRestAPIImpl blobDataLakeStorageFs;
    private final String accountName;
    private final String fileSystemName;
    private final DataLakeServiceVersion serviceVersion;
    private final AzureSasCredential sasToken;
    private final boolean isTokenCredentialAuthenticated;
    private final DataLakeFileSystemAsyncClient dataLakeFileSystemAsyncClient;
    final BlobContainerClient blobContainerClient;
    public static final String ROOT_FILESYSTEM_NAME = "$root";
    public static final String ROOT_DIRECTORY_NAME = "";

    DataLakeFileSystemClient(DataLakeFileSystemAsyncClient dataLakeFileSystemAsyncClient, BlobContainerClient blobContainerClient, HttpPipeline pipeline, String url, DataLakeServiceVersion serviceVersion, String accountName, String fileSystemName, AzureSasCredential sasToken, boolean isTokenCredentialAuthenticated) {
        this.azureDataLakeStorage = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(url).fileSystem(fileSystemName).version(serviceVersion.getVersion()).buildClient();
        String blobUrl = DataLakeImplUtils.endpointToDesiredEndpoint(url, "blob", "dfs");
        this.blobDataLakeStorageFs = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(pipeline).url(blobUrl).fileSystem(fileSystemName).version(serviceVersion.getVersion()).buildClient();
        this.dataLakeFileSystemAsyncClient = dataLakeFileSystemAsyncClient;
        this.blobContainerClient = blobContainerClient;
        this.serviceVersion = serviceVersion;
        this.accountName = accountName;
        this.fileSystemName = fileSystemName;
        this.sasToken = sasToken;
        this.isTokenCredentialAuthenticated = isTokenCredentialAuthenticated;
    }

    public DataLakeFileClient getFileClient(String fileName) {
        Objects.requireNonNull(fileName, "'fileName' can not be set to null");
        return new DataLakeFileClient(this.dataLakeFileSystemAsyncClient.getFileAsyncClient(fileName), this.blobContainerClient.getBlobClient(fileName).getBlockBlobClient(), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), fileName, this.sasToken, Transforms.fromBlobCpkInfo(this.blobContainerClient.getCustomerProvidedKey()), this.isTokenCredentialAuthenticated);
    }

    public DataLakeDirectoryClient getDirectoryClient(String directoryName) {
        Objects.requireNonNull(directoryName, "'directoryName' can not be set to null");
        BlockBlobClient blockBlobClient = this.blobContainerClient.getBlobClient(directoryName).getBlockBlobClient();
        return new DataLakeDirectoryClient(this.dataLakeFileSystemAsyncClient.getDirectoryAsyncClient(directoryName), blockBlobClient, this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getFileSystemName(), directoryName, this.sasToken, Transforms.fromBlobCpkInfo(this.blobContainerClient.getCustomerProvidedKey()), this.isTokenCredentialAuthenticated);
    }

    DataLakeDirectoryClient getRootDirectoryClient() {
        return this.getDirectoryClient(ROOT_DIRECTORY_NAME);
    }

    public String getFileSystemName() {
        return this.fileSystemName;
    }

    public String getAccountUrl() {
        return this.azureDataLakeStorage.getUrl();
    }

    public String getFileSystemUrl() {
        return this.azureDataLakeStorage.getUrl() + "/" + this.fileSystemName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public DataLakeServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureDataLakeStorage.getHttpPipeline();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void create() {
        this.createWithResponse(null, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createWithResponse(Map<String, String> metadata, PublicAccessType accessType, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobContainerClient.createWithResponse(metadata, Transforms.toBlobPublicAccessType(accessType), timeout, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean createIfNotExists() {
        return this.createIfNotExistsWithResponse(null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> createIfNotExistsWithResponse(Map<String, String> metadata, PublicAccessType accessType, Duration timeout, Context context) {
        BlobContainerCreateOptions options = new BlobContainerCreateOptions().setMetadata(metadata).setPublicAccessType(Transforms.toBlobPublicAccessType(accessType));
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobContainerClient.createIfNotExistsWithResponse(options, timeout, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete() {
        this.deleteWithResponse(null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobContainerClient.deleteWithResponse(Transforms.toBlobRequestConditions(requestConditions), timeout, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteIfExists() {
        return this.deleteIfExistsWithResponse(new DataLakePathDeleteOptions(), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteIfExistsWithResponse(DataLakePathDeleteOptions options, Duration timeout, Context context) {
        DataLakeRequestConditions requestConditions = options == null ? new DataLakeRequestConditions() : options.getRequestConditions();
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobContainerClient.deleteIfExistsWithResponse(Transforms.toBlobRequestConditions(requestConditions), timeout, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileSystemProperties getProperties() {
        return this.getPropertiesWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FileSystemProperties> getPropertiesWithResponse(String leaseId, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> {
            Response<BlobContainerProperties> response = this.blobContainerClient.getPropertiesWithResponse(leaseId, timeout, context);
            return new SimpleResponse<FileSystemProperties>(response, Transforms.toFileSystemProperties(response.getValue()));
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean exists() {
        return this.existsWithResponse(null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> existsWithResponse(Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobContainerClient.existsWithResponse(timeout, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setMetadata(Map<String, String> metadata) {
        this.setMetadataWithResponse(metadata, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setMetadataWithResponse(Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobContainerClient.setMetadataWithResponse(metadata, Transforms.toBlobRequestConditions(requestConditions), timeout, context), LOGGER);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathItem> listPaths() {
        return this.listPaths(new ListPathsOptions(), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathItem> listPaths(ListPathsOptions options, Duration timeout) {
        ListPathsOptions finalOptions = options == null ? new ListPathsOptions() : options;
        Integer maxResults = finalOptions.getMaxResults();
        boolean recursive = finalOptions.isRecursive();
        boolean upn = finalOptions.isUserPrincipalNameReturned();
        String path = finalOptions.getPath();
        BiFunction pageRetriever = (continuation, pageSize) -> {
            Callable<ResponseBase> operation = () -> this.azureDataLakeStorage.getFileSystems().listPathsWithResponse(recursive, null, null, (String)continuation, path, pageSize == null ? maxResults : pageSize, upn, Context.NONE);
            ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, DataLakeStorageException.class);
            List items = ((PathList)response.getValue()).getPaths().stream().map(Transforms::toPathItem).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), items, ((FileSystemsListPathsHeaders)response.getDeserializedHeaders()).getXMsContinuation(), (FileSystemsListPathsHeaders)response.getDeserializedHeaders());
        };
        return new PagedIterable<PathItem>(pageSize -> (PagedResponse)pageRetriever.apply((String)null, (Integer)pageSize), pageRetriever);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathDeletedItem> listDeletedPaths() {
        return this.listDeletedPaths(null, null, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PathDeletedItem> listDeletedPaths(String prefix, Duration timeout, Context context) {
        BiFunction retriever = (marker, pageSize) -> {
            Callable<ResponseBase> operation = () -> this.blobDataLakeStorageFs.getFileSystems().listBlobHierarchySegmentWithResponse(prefix, null, (String)marker, (Integer)pageSize, null, ListBlobsShowOnly.DELETED, null, null, context);
            ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, DataLakeStorageException.class);
            List items = ((ListBlobsHierarchySegmentResponse)response.getValue()).getSegment() == null ? Collections.emptyList() : Stream.concat(((ListBlobsHierarchySegmentResponse)response.getValue()).getSegment().getBlobItems().stream().map(Transforms::toPathDeletedItem), ((ListBlobsHierarchySegmentResponse)response.getValue()).getSegment().getBlobPrefixes().stream().map(Transforms::toPathDeletedItem)).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), items, ((ListBlobsHierarchySegmentResponse)response.getValue()).getNextMarker(), (FileSystemsListBlobHierarchySegmentHeaders)response.getDeserializedHeaders());
        };
        return new PagedIterable<PathDeletedItem>(pageSize -> (PagedResponse)retriever.apply((String)null, (Integer)pageSize), retriever);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFile(String fileName) {
        return this.createFile(fileName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFile(String fileName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createFileWithResponse(fileName, new DataLakePathCreateOptions().setRequestConditions(requestConditions), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> createFileWithResponse(String fileName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakePathCreateOptions options = new DataLakePathCreateOptions().setPermissions(permissions).setUmask(umask).setPathHttpHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions);
        return this.createFileWithResponse(fileName, options, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> createFileWithResponse(String fileName, DataLakePathCreateOptions options, Duration timeout, Context context) {
        DataLakeFileClient dataLakeFileClient = this.getFileClient(fileName);
        return new SimpleResponse<DataLakeFileClient>(dataLakeFileClient.createWithResponse(options, timeout, context), dataLakeFileClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeFileClient createFileIfNotExists(String fileName) {
        return this.createFileIfNotExistsWithResponse(fileName, new DataLakePathCreateOptions(), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeFileClient> createFileIfNotExistsWithResponse(String fileName, DataLakePathCreateOptions options, Duration timeout, Context context) {
        DataLakeFileClient dataLakeFileClient = this.getFileClient(fileName);
        Response<PathInfo> response = dataLakeFileClient.createIfNotExistsWithResponse(options, timeout, context);
        return new SimpleResponse<DataLakeFileClient>(response, dataLakeFileClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteFile(String fileName) {
        this.deleteFileWithResponse(fileName, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFileWithResponse(String fileName, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return this.getFileClient(fileName).deleteWithResponse(requestConditions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteFileIfExists(String fileName) {
        return this.deleteFileIfExistsWithResponse(fileName, new DataLakePathDeleteOptions(), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteFileIfExistsWithResponse(String fileName, DataLakePathDeleteOptions options, Duration timeout, Context context) {
        return this.getFileClient(fileName).deleteIfExistsWithResponse(options, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createDirectory(String directoryName) {
        return this.createDirectory(directoryName, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createDirectory(String directoryName, boolean overwrite) {
        DataLakeRequestConditions requestConditions = new DataLakeRequestConditions();
        if (!overwrite) {
            requestConditions.setIfNoneMatch("*");
        }
        return this.createDirectoryWithResponse(directoryName, null, null, null, null, requestConditions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> createDirectoryWithResponse(String directoryName, String permissions, String umask, PathHttpHeaders headers, Map<String, String> metadata, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        DataLakePathCreateOptions options = new DataLakePathCreateOptions().setPermissions(permissions).setUmask(umask).setPathHttpHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions);
        return this.createDirectoryWithResponse(directoryName, options, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> createDirectoryWithResponse(String directoryName, DataLakePathCreateOptions options, Duration timeout, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getDirectoryClient(directoryName);
        return new SimpleResponse<DataLakeDirectoryClient>(dataLakeDirectoryClient.createWithResponse(options, timeout, context), dataLakeDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakeDirectoryClient createDirectoryIfNotExists(String directoryName) {
        return this.createDirectoryIfNotExistsWithResponse(directoryName, new DataLakePathCreateOptions(), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakeDirectoryClient> createDirectoryIfNotExistsWithResponse(String directoryName, DataLakePathCreateOptions options, Duration timeout, Context context) {
        DataLakeDirectoryClient dataLakeDirectoryClient = this.getDirectoryClient(directoryName);
        Response<PathInfo> response = dataLakeDirectoryClient.createIfNotExistsWithResponse(options, timeout, context);
        return new SimpleResponse<DataLakeDirectoryClient>(response, dataLakeDirectoryClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDirectory(String directoryName) {
        this.deleteDirectoryWithResponse(directoryName, false, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDirectoryWithResponse(String directoryName, boolean recursive, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return this.getDirectoryClient(directoryName).deleteWithResponse(recursive, requestConditions, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean deleteDirectoryIfExists(String directoryName) {
        return this.deleteDirectoryIfExistsWithResponse(directoryName, new DataLakePathDeleteOptions(), null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> deleteDirectoryIfExistsWithResponse(String directoryName, DataLakePathDeleteOptions options, Duration timeout, Context context) {
        return this.getDirectoryClient(directoryName).deleteIfExistsWithResponse(options, timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataLakePathClient undeletePath(String deletedPath, String deletionId) {
        return this.undeletePathWithResponse(deletedPath, deletionId, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataLakePathClient> undeletePathWithResponse(String deletedPath, String deletionId, Duration timeout, Context context) {
        Objects.requireNonNull(deletedPath);
        Objects.requireNonNull(deletionId);
        Context finalContext = context == null ? Context.NONE : context;
        String blobUrl = DataLakeImplUtils.endpointToDesiredEndpoint(this.blobDataLakeStorageFs.getUrl(), "blob", "dfs");
        AzureDataLakeStorageRestAPIImpl blobDataLakeStoragePath = new AzureDataLakeStorageRestAPIImplBuilder().pipeline(this.blobDataLakeStorageFs.getHttpPipeline()).url(blobUrl).fileSystem(this.blobDataLakeStorageFs.getFileSystem()).path(deletedPath).version(this.serviceVersion.getVersion()).buildClient();
        Callable<ResponseBase> operation = () -> blobDataLakeStoragePath.getPaths().undeleteWithResponse(null, "?deletionid=" + deletionId, null, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, DataLakeStorageException.class);
        DataLakePathAsyncClient pathAsyncClient = new DataLakePathAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.serviceVersion, this.accountName, this.fileSystemName, deletedPath, PathResourceType.fromString(((PathsUndeleteHeaders)response.getDeserializedHeaders()).getXMsResourceType()), this.dataLakeFileSystemAsyncClient.getBlobContainerAsyncClient().getBlobAsyncClient(deletedPath, null).getBlockBlobAsyncClient(), this.sasToken, Transforms.fromBlobCpkInfo(this.blobContainerClient.getCustomerProvidedKey()), this.isTokenCredentialAuthenticated);
        DataLakePathClient pathClient = new DataLakePathClient(pathAsyncClient, this.blobContainerClient.getBlobClient(deletedPath, null).getBlockBlobClient(), this.getHttpPipeline(), this.getAccountUrl(), this.serviceVersion, this.accountName, this.fileSystemName, deletedPath, PathResourceType.fromString(((PathsUndeleteHeaders)response.getDeserializedHeaders()).getXMsResourceType()), this.sasToken, Transforms.fromBlobCpkInfo(this.blobContainerClient.getCustomerProvidedKey()), this.isTokenCredentialAuthenticated);
        if (PathResourceType.DIRECTORY.equals((Object)pathClient.pathResourceType)) {
            return new SimpleResponse<DataLakePathClient>(response, new DataLakeDirectoryClient(pathClient));
        }
        if (PathResourceType.FILE.equals((Object)pathClient.pathResourceType)) {
            return new SimpleResponse<DataLakePathClient>(response, new DataLakeFileClient(pathClient));
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException("'pathClient' expected to be either a file or directory client."));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileSystemAccessPolicies getAccessPolicy() {
        return this.getAccessPolicyWithResponse(null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FileSystemAccessPolicies> getAccessPolicyWithResponse(String leaseId, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> {
            Response<BlobContainerAccessPolicies> response = this.blobContainerClient.getAccessPolicyWithResponse(leaseId, timeout, context);
            return new SimpleResponse<FileSystemAccessPolicies>(response, Transforms.toFileSystemAccessPolicies(response.getValue()));
        }, LOGGER);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessPolicy(PublicAccessType accessType, List<DataLakeSignedIdentifier> identifiers) {
        this.setAccessPolicyWithResponse(accessType, identifiers, null, null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setAccessPolicyWithResponse(PublicAccessType accessType, List<DataLakeSignedIdentifier> identifiers, DataLakeRequestConditions requestConditions, Duration timeout, Context context) {
        return DataLakeImplUtils.returnOrConvertException(() -> this.blobContainerClient.setAccessPolicyWithResponse(Transforms.toBlobPublicAccessType(accessType), Transforms.toBlobIdentifierList(identifiers), Transforms.toBlobRequestConditions(requestConditions), timeout, context), LOGGER);
    }

    BlobContainerClient getBlobContainerClient() {
        return this.blobContainerClient;
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey) {
        return this.generateUserDelegationSas(dataLakeServiceSasSignatureValues, userDelegationKey, this.getAccountName(), Context.NONE);
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Context context) {
        return this.generateUserDelegationSas(dataLakeServiceSasSignatureValues, userDelegationKey, accountName, null, context);
    }

    public String generateUserDelegationSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, UserDelegationKey userDelegationKey, String accountName, Consumer<String> stringToSignHandler, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName()).generateUserDelegationSas(userDelegationKey, accountName, stringToSignHandler, context);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues) {
        return this.generateSas(dataLakeServiceSasSignatureValues, Context.NONE);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, Context context) {
        return this.generateSas(dataLakeServiceSasSignatureValues, null, context);
    }

    public String generateSas(DataLakeServiceSasSignatureValues dataLakeServiceSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return new DataLakeSasImplUtil(dataLakeServiceSasSignatureValues, this.getFileSystemName()).generateSas(SasImplUtils.extractSharedKeyCredential(this.getHttpPipeline()), stringToSignHandler, context);
    }
}

