/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.ProxyOptions;
import com.azure.core.util.CoreUtils;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.DeviceCodeInfo;
import com.azure.identity.implementation.IdentityClientBase;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.IntelliJCacheAccessor;
import com.azure.identity.implementation.MSIToken;
import com.azure.identity.implementation.ManagedIdentityParameters;
import com.azure.identity.implementation.ManagedIdentityType;
import com.azure.identity.implementation.MsalToken;
import com.azure.identity.implementation.PowershellManager;
import com.azure.identity.implementation.SynchronizedAccessor;
import com.azure.identity.implementation.VisualStudioCacheAccessor;
import com.azure.identity.implementation.util.IdentitySslUtil;
import com.azure.identity.implementation.util.IdentityUtil;
import com.azure.identity.implementation.util.LoggingUtil;
import com.azure.identity.implementation.util.ScopeUtil;
import com.azure.identity.implementation.util.ValidationUtil;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.microsoft.aad.msal4j.AppTokenProviderParameters;
import com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import com.microsoft.aad.msal4j.ClaimsRequest;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.ManagedIdentityApplication;
import com.microsoft.aad.msal4j.ManagedIdentityParameters;
import com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import com.microsoft.aad.msal4j.MsalInteractionRequiredException;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.RefreshTokenParameters;
import com.microsoft.aad.msal4j.SilentParameters;
import com.microsoft.aad.msal4j.TokenProviderResult;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.HttpsURLConnection;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class IdentityClient
extends IdentityClientBase {
    private final SynchronizedAccessor<PublicClientApplication> publicClientApplicationAccessor = new SynchronizedAccessor(() -> this.getPublicClientApplication(isSharedTokenCacheCredential, false));
    private final SynchronizedAccessor<PublicClientApplication> publicClientApplicationAccessorWithCae = new SynchronizedAccessor(() -> this.getPublicClientApplication(isSharedTokenCacheCredential, true));
    private final SynchronizedAccessor<ConfidentialClientApplication> confidentialClientApplicationAccessor = new SynchronizedAccessor(() -> this.getConfidentialClientApplication(false));
    private final SynchronizedAccessor<ConfidentialClientApplication> confidentialClientApplicationAccessorWithCae = new SynchronizedAccessor(() -> this.getConfidentialClientApplication(true));
    private final SynchronizedAccessor<ConfidentialClientApplication> managedIdentityConfidentialClientApplicationAccessor = new SynchronizedAccessor(this::getManagedIdentityConfidentialClientApplication);
    private final SynchronizedAccessor<ManagedIdentityApplication> managedIdentityMsalApplicationAccessor = new SynchronizedAccessor(this::getManagedIdentityMsalClient);
    private final SynchronizedAccessor<ConfidentialClientApplication> workloadIdentityConfidentialClientApplicationAccessor = new SynchronizedAccessor(this::getWorkloadIdentityConfidentialClientApplication);
    private final SynchronizedAccessor<String> clientAssertionAccessor;

    IdentityClient(String tenantId, String clientId, String clientSecret, String certificatePath, String clientAssertionFilePath, String resourceId, String objectId, Supplier<String> clientAssertionSupplier, Function<HttpPipeline, String> clientAssertionSupplierWithHttpPipeline, byte[] certificate, String certificatePassword, boolean isSharedTokenCacheCredential, Duration clientAssertionTimeout, IdentityClientOptions options) {
        super(tenantId, clientId, clientSecret, certificatePath, clientAssertionFilePath, resourceId, objectId, clientAssertionSupplier, clientAssertionSupplierWithHttpPipeline, certificate, certificatePassword, isSharedTokenCacheCredential, clientAssertionTimeout, options);
        Duration cacheTimeout = clientAssertionTimeout == null ? Duration.ofMinutes(5L) : clientAssertionTimeout;
        this.clientAssertionAccessor = new SynchronizedAccessor(this::parseClientAssertion, cacheTimeout);
    }

    public Mono<ManagedIdentityApplication> getManagedIdentityMsalClient() {
        return Mono.defer(() -> {
            try {
                return Mono.just(this.getManagedIdentityMsalApplication());
            }
            catch (RuntimeException e) {
                return Mono.error(e);
            }
        });
    }

    private Mono<ConfidentialClientApplication> getConfidentialClientApplication(boolean enableCae) {
        return Mono.defer(() -> {
            try {
                return Mono.just(this.getConfidentialClient(enableCae));
            }
            catch (RuntimeException e) {
                return Mono.error(e);
            }
        });
    }

    private Mono<ConfidentialClientApplication> getManagedIdentityConfidentialClientApplication() {
        return Mono.defer(() -> {
            try {
                return Mono.just(super.getManagedIdentityConfidentialClient());
            }
            catch (RuntimeException e) {
                return Mono.error(e);
            }
        });
    }

    private Mono<ConfidentialClientApplication> getWorkloadIdentityConfidentialClientApplication() {
        return Mono.defer(() -> {
            try {
                return Mono.just(super.getWorkloadIdentityConfidentialClient());
            }
            catch (RuntimeException e) {
                return Mono.error(e);
            }
        });
    }

    @Override
    Mono<AccessToken> getTokenFromTargetManagedIdentity(TokenRequestContext tokenRequestContext) {
        ManagedIdentityParameters parameters = this.options.getManagedIdentityParameters();
        ManagedIdentityType managedIdentityType = this.options.getManagedIdentityType();
        switch (managedIdentityType) {
            case APP_SERVICE: {
                return this.authenticateToManagedIdentityEndpoint(parameters.getIdentityEndpoint(), parameters.getIdentityHeader(), parameters.getMsiEndpoint(), parameters.getMsiSecret(), tokenRequestContext);
            }
            case SERVICE_FABRIC: {
                return this.authenticateToServiceFabricManagedIdentityEndpoint(parameters.getIdentityEndpoint(), parameters.getIdentityHeader(), parameters.getIdentityServerThumbprint(), tokenRequestContext);
            }
            case ARC: {
                return this.authenticateToArcManagedIdentityEndpoint(parameters.getIdentityEndpoint(), tokenRequestContext);
            }
            case AKS: {
                return this.authenticateWithExchangeToken(tokenRequestContext);
            }
            case VM: {
                return this.authenticateToIMDSEndpoint(tokenRequestContext);
            }
        }
        return Mono.error(LOGGER.logExceptionAsError(new CredentialUnavailableException("Unknown Managed Identity type, authentication not available.")));
    }

    private Mono<String> parseClientAssertion() {
        return Mono.fromCallable(() -> {
            if (this.clientAssertionFilePath != null) {
                byte[] encoded = Files.readAllBytes(Paths.get(this.clientAssertionFilePath, new String[0]));
                return new String(encoded, StandardCharsets.UTF_8);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("Client Assertion File Path is not provided. It should be provided to authenticate with client assertion."));
        });
    }

    private Mono<PublicClientApplication> getPublicClientApplication(boolean sharedTokenCacheCredential, boolean enableCae) {
        return Mono.defer(() -> {
            try {
                return Mono.just(this.getPublicClient(sharedTokenCacheCredential, enableCae));
            }
            catch (RuntimeException e) {
                return Mono.error(e);
            }
        });
    }

    public Mono<MsalToken> authenticateWithIntelliJ(TokenRequestContext request) {
        try {
            IntelliJCacheAccessor cacheAccessor = new IntelliJCacheAccessor();
            String cachedRefreshToken = cacheAccessor.getIntelliJCredentialsFromIdentityMsalCache();
            if (!CoreUtils.isNullOrEmpty(cachedRefreshToken)) {
                RefreshTokenParameters.RefreshTokenParametersBuilder refreshTokenParametersBuilder = RefreshTokenParameters.builder(new HashSet<String>(request.getScopes()), cachedRefreshToken);
                if (request.getClaims() != null) {
                    ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest(request.getClaims());
                    refreshTokenParametersBuilder.claims(claimsRequest);
                }
                return this.publicClientApplicationAccessor.getValue().flatMap(pc -> Mono.fromFuture(pc.acquireToken(refreshTokenParametersBuilder.build())).map(MsalToken::new));
            }
            String exception = "IntelliJ authentication not available. Please login with the Azure Toolkit for IntelliJ. You may also need to upgrade to a newer version of the Azure Toolkit for IntelliJ. This authentication is supported on version 3.53 and higher. Please see https://aka.ms/azsdk/java/identity/intellijcredential/troubleshoot for more information.";
            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException(exception)));
        }
        catch (RuntimeException e) {
            return Mono.error(e);
        }
    }

    public Mono<AccessToken> authenticateWithAzureCli(TokenRequestContext request) {
        StringBuilder azCommand = new StringBuilder("az account get-access-token --output json --resource ");
        String scopes = ScopeUtil.scopesToResource(request.getScopes());
        try {
            ScopeUtil.validateScope(scopes);
        }
        catch (IllegalArgumentException ex) {
            return Mono.error(LOGGER.logExceptionAsError(ex));
        }
        azCommand.append(scopes);
        try {
            String tenant = IdentityUtil.resolveTenantId(this.tenantId, request, this.options);
            ValidationUtil.validateTenantIdCharacterRange(tenant, LOGGER);
            if (!CoreUtils.isNullOrEmpty(tenant) && !tenant.equals("organizations")) {
                azCommand.append(" --tenant ").append(tenant);
            }
        }
        catch (ClientAuthenticationException | IllegalArgumentException e) {
            return Mono.error(e);
        }
        try {
            AccessToken token = this.getTokenFromAzureCLIAuthentication(azCommand);
            return Mono.just(token);
        }
        catch (RuntimeException e) {
            return Mono.error(e instanceof CredentialUnavailableException ? LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, (CredentialUnavailableException)e) : LOGGER.logExceptionAsError(e));
        }
    }

    public Mono<AccessToken> authenticateWithAzureDeveloperCli(TokenRequestContext request) {
        StringBuilder azdCommand = new StringBuilder("azd auth token --output json --scope ");
        List<String> scopes = request.getScopes();
        if (scopes.size() == 0) {
            return Mono.error(LOGGER.logExceptionAsError(new IllegalArgumentException("Missing scope in request")));
        }
        for (String scope : scopes) {
            try {
                ScopeUtil.validateScope(scope);
            }
            catch (IllegalArgumentException ex) {
                return Mono.error(LOGGER.logExceptionAsError(ex));
            }
        }
        azdCommand.append(String.join((CharSequence)" --scope ", scopes));
        try {
            String tenant = IdentityUtil.resolveTenantId(this.tenantId, request, this.options);
            ValidationUtil.validateTenantIdCharacterRange(tenant, LOGGER);
            if (!CoreUtils.isNullOrEmpty(tenant) && !tenant.equals("organizations")) {
                azdCommand.append(" --tenant-id ").append(tenant);
            }
        }
        catch (ClientAuthenticationException | IllegalArgumentException e) {
            return Mono.error(e);
        }
        try {
            AccessToken token = this.getTokenFromAzureDeveloperCLIAuthentication(azdCommand);
            return Mono.just(token);
        }
        catch (RuntimeException e) {
            return Mono.error(e instanceof CredentialUnavailableException ? LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, (CredentialUnavailableException)e) : LOGGER.logExceptionAsError(e));
        }
    }

    public Mono<AccessToken> authenticateWithAzurePowerShell(TokenRequestContext request) {
        ValidationUtil.validateTenantIdCharacterRange(this.tenantId, LOGGER);
        ArrayList exceptions = new ArrayList(2);
        PowershellManager defaultPowerShellManager = new PowershellManager(false);
        PowershellManager legacyPowerShellManager = Platform.isWindows() ? new PowershellManager(true) : null;
        ArrayList<PowershellManager> powershellManagers = new ArrayList<PowershellManager>(2);
        powershellManagers.add(defaultPowerShellManager);
        if (legacyPowerShellManager != null) {
            powershellManagers.add(legacyPowerShellManager);
        }
        return Flux.fromIterable(powershellManagers).flatMap(powershellManager -> this.getAccessTokenFromPowerShell(request, (PowershellManager)powershellManager).onErrorResume(t -> {
            if (!t.getClass().getSimpleName().equals("CredentialUnavailableException")) {
                return Mono.error(new ClientAuthenticationException("Azure Powershell authentication failed. Error Details: " + t.getMessage() + ". To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/powershellcredential/troubleshoot", null, (Throwable)t));
            }
            exceptions.add((CredentialUnavailableException)t);
            return Mono.empty();
        }), 1).next().switchIfEmpty(Mono.defer(() -> {
            CredentialUnavailableException last = (CredentialUnavailableException)exceptions.get(exceptions.size() - 1);
            for (int z = exceptions.size() - 2; z >= 0; --z) {
                CredentialUnavailableException current = (CredentialUnavailableException)exceptions.get(z);
                last = new CredentialUnavailableException("Azure PowerShell authentication failed using defaultpowershell(pwsh) with following error: " + current.getMessage() + "\r\nAzure PowerShell authentication failed using powershell-core(powershell) with following error: " + last.getMessage(), last.getCause());
            }
            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, last));
        }));
    }

    public Mono<AccessToken> authenticateWithOBO(TokenRequestContext request) {
        return this.getConfidentialClientInstance(request).getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> confidentialClient.acquireToken(this.buildOBOFlowParameters(request))).map(MsalToken::new));
    }

    private Mono<AccessToken> getAccessTokenFromPowerShell(TokenRequestContext request, PowershellManager powershellManager) {
        String scope = ScopeUtil.scopesToResource(request.getScopes());
        try {
            ScopeUtil.validateScope(scope);
        }
        catch (IllegalArgumentException ex) {
            throw LOGGER.logExceptionAsError(ex);
        }
        return Mono.defer(() -> {
            String sep = System.lineSeparator();
            String command = "$ErrorActionPreference = 'Stop'" + sep + "[version]$minimumVersion = '2.2.0'" + sep + "" + sep + "$m = Import-Module Az.Accounts -MinimumVersion $minimumVersion -PassThru -ErrorAction SilentlyContinue" + sep + "" + sep + "if (! $m) {" + sep + "    Write-Output 'VersionTooOld'" + sep + "    exit" + sep + "}" + sep + "" + sep + "$useSecureString = $m.Version -ge [version]'2.17.0'" + sep + "" + sep + "$params = @{" + sep + "    'WarningAction'='Ignore'" + sep + "    'ResourceUrl'='" + scope + "'" + sep + "}" + sep + "" + sep + "if ($useSecureString) {" + sep + "    $params['AsSecureString'] = $true" + sep + "}" + sep + "" + sep + "$token = Get-AzAccessToken @params" + sep + "$customToken = New-Object -TypeName psobject" + sep + "" + sep + "$customToken | Add-Member -MemberType NoteProperty -Name Token -Value ($useSecureString -eq $true ? (ConvertFrom-SecureString -AsPlainText $token.Token) : $token.Token)" + sep + "$customToken | Add-Member -MemberType NoteProperty -Name ExpiresOn -Value $token.ExpiresOn" + sep + "" + sep + "return $customToken | ConvertTo-Json";
            return powershellManager.runCommand(command).flatMap(output -> {
                Mono<AccessToken> mono;
                block10: {
                    if (output.contains("VersionTooOld")) {
                        return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Az.Account module with version >= 2.2.0 is not installed. It needs to be installed to use Azure PowerShell Credential.")));
                    }
                    if (output.contains("Run Connect-AzAccount to login")) {
                        return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Run Connect-AzAccount to login to Azure account in PowerShell.")));
                    }
                    JsonReader reader = JsonProviders.createReader(output);
                    try {
                        reader.nextToken();
                        Map<String, String> objectMap = reader.readMap(JsonReader::getString);
                        String accessToken = objectMap.get("Token");
                        String time = objectMap.get("ExpiresOn");
                        OffsetDateTime expiresOn = OffsetDateTime.parse(time).withOffsetSameInstant(ZoneOffset.UTC);
                        mono = Mono.just(new AccessToken(accessToken, expiresOn));
                        if (reader == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Encountered error when deserializing response from Azure Power Shell.", (Throwable)e)));
                        }
                    }
                    reader.close();
                }
                return mono;
            });
        });
    }

    public Mono<AccessToken> authenticateWithConfidentialClient(TokenRequestContext request) {
        return this.getConfidentialClientInstance(request).getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> {
            ClientCredentialParameters.ClientCredentialParametersBuilder builder = this.buildConfidentialClientParameters(request);
            return confidentialClient.acquireToken(builder.build());
        })).map(MsalToken::new);
    }

    private SynchronizedAccessor<ConfidentialClientApplication> getConfidentialClientInstance(TokenRequestContext requestContext) {
        return requestContext.isCaeEnabled() ? this.confidentialClientApplicationAccessorWithCae : this.confidentialClientApplicationAccessor;
    }

    private ClientCredentialParameters.ClientCredentialParametersBuilder buildConfidentialClientParameters(TokenRequestContext request) {
        ClientCredentialParameters.ClientCredentialParametersBuilder builder = ClientCredentialParameters.builder(new HashSet<String>(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        if (this.clientAssertionSupplier != null) {
            builder.clientCredential(ClientCredentialFactory.createFromClientAssertion((String)this.clientAssertionSupplier.get()));
        } else if (this.clientAssertionSupplierWithHttpPipeline != null) {
            builder.clientCredential(ClientCredentialFactory.createFromClientAssertion((String)this.clientAssertionSupplierWithHttpPipeline.apply(this.getPipeline())));
        }
        if (request.isCaeEnabled() && request.getClaims() != null) {
            ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest(request.getClaims());
            builder.claims(claimsRequest);
        }
        return builder;
    }

    public Mono<AccessToken> authenticateWithManagedIdentityConfidentialClient(TokenRequestContext request) {
        return this.managedIdentityConfidentialClientApplicationAccessor.getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> {
            ClientCredentialParameters.ClientCredentialParametersBuilder builder = ClientCredentialParameters.builder(new HashSet<String>(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
            return confidentialClient.acquireToken(builder.build());
        })).onErrorMap(t -> new CredentialUnavailableException("Managed Identity authentication is not available.", (Throwable)t)).map(MsalToken::new);
    }

    public Mono<AccessToken> authenticateWithManagedIdentityMsalClient(TokenRequestContext request) {
        String resource = ScopeUtil.scopesToResource(request.getScopes());
        return Mono.fromSupplier(() -> this.options.isChained() && ManagedIdentitySourceType.DEFAULT_TO_IMDS.equals((Object)ManagedIdentityApplication.getManagedIdentitySource())).flatMap(shouldProbe -> shouldProbe != false ? this.checkIMDSAvailable(this.getImdsEndpoint()) : Mono.just(true)).flatMap(ignored -> this.getTokenFromMsalMIClient(resource));
    }

    private Mono<AccessToken> getTokenFromMsalMIClient(String resource) {
        return this.managedIdentityMsalApplicationAccessor.getValue().flatMap(managedIdentityApplication -> Mono.fromFuture(() -> {
            ManagedIdentityParameters.ManagedIdentityParametersBuilder builder = com.microsoft.aad.msal4j.ManagedIdentityParameters.builder(resource);
            try {
                return managedIdentityApplication.acquireTokenForManagedIdentity(builder.build());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })).onErrorMap(t -> new CredentialUnavailableException("Managed Identity authentication is not available.", (Throwable)t)).map(MsalToken::new);
    }

    public Mono<AccessToken> authenticateWithWorkloadIdentityConfidentialClient(TokenRequestContext request) {
        return this.workloadIdentityConfidentialClientApplicationAccessor.getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> {
            ClientCredentialParameters.ClientCredentialParametersBuilder builder = ClientCredentialParameters.builder(new HashSet<String>(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
            return confidentialClient.acquireToken(builder.build());
        })).onErrorMap(t -> new CredentialUnavailableException("Workload Identity authentication is not available.", (Throwable)t)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithUsernamePassword(TokenRequestContext request, String username, String password) {
        return this.getPublicClientInstance(request).getValue().flatMap(pc -> Mono.fromFuture(() -> {
            UserNamePasswordParameters.UserNamePasswordParametersBuilder userNamePasswordParametersBuilder = this.buildUsernamePasswordFlowParameters(request, username, password);
            return pc.acquireToken(userNamePasswordParametersBuilder.build());
        })).onErrorMap(t -> new ClientAuthenticationException("Failed to acquire token with username and password. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/usernamepasswordcredential/troubleshoot", null, (Throwable)t)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithPublicClientCache(TokenRequestContext request, IAccount account) {
        return this.getPublicClientInstance(request).getValue().flatMap(pc -> Mono.fromFuture(() -> this.acquireTokenFromPublicClientSilently(request, (PublicClientApplication)pc, account, false)).map(MsalToken::new).filter(t -> OffsetDateTime.now().isBefore(t.getExpiresAt().minus(REFRESH_OFFSET))).switchIfEmpty(Mono.fromFuture(() -> this.acquireTokenFromPublicClientSilently(request, (PublicClientApplication)pc, account, true)).map(MsalToken::new)));
    }

    private CompletableFuture<IAuthenticationResult> acquireTokenFromPublicClientSilently(TokenRequestContext request, PublicClientApplication pc, IAccount account, boolean forceRefresh) {
        SilentParameters.SilentParametersBuilder parametersBuilder = SilentParameters.builder(new HashSet<String>(request.getScopes()));
        if (forceRefresh) {
            parametersBuilder.forceRefresh(true);
        }
        if (request.isCaeEnabled() && request.getClaims() != null) {
            ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest(request.getClaims());
            parametersBuilder.claims(claimsRequest);
            parametersBuilder.forceRefresh(true);
        }
        if (account != null) {
            parametersBuilder = parametersBuilder.account(account);
        }
        parametersBuilder.tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        try {
            return pc.acquireTokenSilently(parametersBuilder.build());
        }
        catch (MalformedURLException e) {
            return this.getFailedCompletableFuture(LOGGER.logExceptionAsError(new RuntimeException(e)));
        }
    }

    private SynchronizedAccessor<PublicClientApplication> getPublicClientInstance(TokenRequestContext request) {
        return request.isCaeEnabled() ? this.publicClientApplicationAccessorWithCae : this.publicClientApplicationAccessor;
    }

    public Mono<AccessToken> authenticateWithConfidentialClientCache(TokenRequestContext request) {
        return this.authenticateWithConfidentialClientCache(request, null);
    }

    public Mono<AccessToken> authenticateWithConfidentialClientCache(TokenRequestContext request, IAccount account) {
        return this.getConfidentialClientInstance(request).getValue().flatMap(confidentialClient -> Mono.fromFuture(() -> {
            SilentParameters.SilentParametersBuilder parametersBuilder = SilentParameters.builder(new HashSet<String>(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
            if (account != null) {
                parametersBuilder.account(account);
            }
            try {
                return confidentialClient.acquireTokenSilently(parametersBuilder.build());
            }
            catch (MalformedURLException e) {
                return this.getFailedCompletableFuture(LOGGER.logExceptionAsError(new RuntimeException(e)));
            }
        }).map(ar -> new MsalToken((IAuthenticationResult)ar)).filter(t -> OffsetDateTime.now().isBefore(t.getExpiresAt().minus(REFRESH_OFFSET))));
    }

    public Mono<MsalToken> authenticateWithDeviceCode(TokenRequestContext request, Consumer<DeviceCodeInfo> deviceCodeConsumer) {
        return this.getPublicClientInstance(request).getValue().flatMap(pc -> Mono.fromFuture(() -> {
            DeviceCodeFlowParameters.DeviceCodeFlowParametersBuilder parametersBuilder = this.buildDeviceCodeFlowParameters(request, deviceCodeConsumer);
            return pc.acquireToken(parametersBuilder.build());
        }).onErrorMap(t -> new ClientAuthenticationException("Failed to acquire token with device code.", null, (Throwable)t)).map(MsalToken::new));
    }

    public Mono<MsalToken> authenticateWithVsCodeCredential(TokenRequestContext request, String cloud) {
        if (this.isADFSTenant()) {
            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("VsCodeCredential  authentication unavailable. ADFS tenant/authorities are not supported. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/vscodecredential/troubleshoot")));
        }
        VisualStudioCacheAccessor accessor = new VisualStudioCacheAccessor();
        String credential = null;
        try {
            credential = accessor.getCredentials("VS Code Azure", cloud);
        }
        catch (CredentialUnavailableException e) {
            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, e));
        }
        RefreshTokenParameters.RefreshTokenParametersBuilder parametersBuilder = RefreshTokenParameters.builder(new HashSet<String>(request.getScopes()), credential);
        if (request.isCaeEnabled() && request.getClaims() != null) {
            ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest(request.getClaims());
            parametersBuilder.claims(claimsRequest);
        }
        return this.getPublicClientInstance(request).getValue().flatMap(pc -> Mono.fromFuture(pc.acquireToken(parametersBuilder.build())).onErrorResume(t -> {
            if (t instanceof MsalInteractionRequiredException) {
                return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Failed to acquire token with VS code credential. To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/vscodecredential/troubleshoot", (Throwable)t)));
            }
            return Mono.error(new ClientAuthenticationException("Failed to acquire token with VS code credential", null, (Throwable)t));
        }).map(MsalToken::new));
    }

    public Mono<MsalToken> authenticateWithAuthorizationCode(TokenRequestContext request, String authorizationCode, URI redirectUrl) {
        Mono acquireToken;
        AuthorizationCodeParameters.AuthorizationCodeParametersBuilder parametersBuilder = AuthorizationCodeParameters.builder(authorizationCode, redirectUrl).scopes(new HashSet<String>(request.getScopes())).tenant(IdentityUtil.resolveTenantId(this.tenantId, request, this.options));
        if (request.getClaims() != null) {
            ClaimsRequest claimsRequest = ClaimsRequest.formatAsClaimsRequest(request.getClaims());
            parametersBuilder.claims(claimsRequest);
        }
        if (this.clientSecret != null) {
            acquireToken = this.getConfidentialClientInstance(request).getValue().flatMap(pc -> Mono.fromFuture(() -> pc.acquireToken(parametersBuilder.build())));
        } else {
            SynchronizedAccessor<PublicClientApplication> publicClient = this.getPublicClientInstance(request);
            acquireToken = publicClient.getValue().flatMap(pc -> Mono.fromFuture(() -> pc.acquireToken(parametersBuilder.build())));
        }
        return acquireToken.onErrorMap(t -> new ClientAuthenticationException("Failed to acquire token with authorization code", null, (Throwable)t)).map(MsalToken::new);
    }

    public Mono<MsalToken> authenticateWithBrowserInteraction(TokenRequestContext request, Integer port, String redirectUrl, String loginHint) {
        URI redirectUri;
        String redirect = port != null ? "http://localhost:" + port : (redirectUrl != null ? redirectUrl : "http://localhost");
        try {
            redirectUri = new URI(redirect);
        }
        catch (URISyntaxException e) {
            return Mono.error(LOGGER.logExceptionAsError(new RuntimeException(e)));
        }
        return this.getPublicClientInstance(request).getValue().flatMap(pc -> {
            if (this.options.isBrokerEnabled() && this.options.useDefaultBrokerAccount()) {
                return Mono.fromFuture(() -> this.acquireTokenFromPublicClientSilently(request, (PublicClientApplication)pc, null, false)).onErrorResume(e -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> {
            InteractiveRequestParameters.InteractiveRequestParametersBuilder builder = this.buildInteractiveRequestParameters(request, loginHint, redirectUri);
            SynchronizedAccessor<PublicClientApplication> publicClient = this.getPublicClientInstance(request);
            return publicClient.getValue().flatMap(pc -> Mono.fromFuture(() -> pc.acquireToken(builder.build())));
        })).onErrorMap(t -> !(t instanceof ClientAuthenticationException), t -> {
            throw new ClientAuthenticationException("Failed to acquire token with Interactive Browser Authentication.", null, (Throwable)t);
        }).map(iAuthenticationResult -> {
            if (this.options.isBrokerEnabled() && request.getProofOfPossessionOptions() != null) {
                return new MsalToken((IAuthenticationResult)iAuthenticationResult, "PoP");
            }
            return new MsalToken((IAuthenticationResult)iAuthenticationResult);
        });
    }

    public Mono<MsalToken> authenticateWithSharedTokenCache(TokenRequestContext request, String username) {
        SynchronizedAccessor<PublicClientApplication> publicClient = this.getPublicClientInstance(request);
        return publicClient.getValue().flatMap(pc -> Mono.fromFuture(pc::getAccounts)).onErrorMap(t -> new CredentialUnavailableException("Cannot get accounts from token cache. Error: " + t.getMessage(), (Throwable)t)).flatMap(set -> {
            HashMap<String, IAccount> accounts = new HashMap<String, IAccount>();
            if (set.isEmpty()) {
                return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("SharedTokenCacheCredential authentication unavailable. No accounts were found in the cache.")));
            }
            for (IAccount cached : set) {
                if (username != null && !username.equals(cached.username())) continue;
                accounts.putIfAbsent(cached.homeAccountId(), cached);
            }
            if (accounts.isEmpty()) {
                return Mono.error(new RuntimeException(String.format("SharedTokenCacheCredential authentication unavailable. No account matching the specified username: %s was found in the cache.", username)));
            }
            if (accounts.size() > 1) {
                if (username == null) {
                    return Mono.error(new RuntimeException("SharedTokenCacheCredential authentication unavailable. Multiple accounts were found in the cache. Use username and tenant id to disambiguate."));
                }
                return Mono.error(new RuntimeException(String.format("SharedTokenCacheCredential authentication unavailable. Multiple accounts matching the specified username: %s were found in the cache.", username)));
            }
            IAccount requestedAccount = (IAccount)accounts.values().iterator().next();
            return this.authenticateWithPublicClientCache(request, requestedAccount);
        });
    }

    private Mono<AccessToken> authenticateToArcManagedIdentityEndpoint(String identityEndpoint, TokenRequestContext request) {
        return Mono.fromCallable(() -> {
            String secretKey;
            URL url;
            HttpURLConnection connection;
            block14: {
                connection = null;
                String payload = identityEndpoint + "?resource=" + IdentityClient.urlEncode(ScopeUtil.scopesToResource(request.getScopes())) + "&api-version=" + "2019-11-01";
                url = IdentityClient.getUrl(payload);
                secretKey = null;
                try {
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("Metadata", "true");
                    connection.setRequestProperty("User-Agent", this.userAgent);
                    connection.connect();
                }
                catch (IOException e) {
                    if (connection == null) {
                        throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Failed to initialize Http URL connection to the endpoint.", null, e));
                    }
                    int status = connection.getResponseCode();
                    if (status != 401) {
                        throw LOGGER.logExceptionAsError(new ClientAuthenticationException(String.format("Expected a 401 Unauthorized response from Azure Arc Managed Identity Endpoint, received: %d", status), null, e));
                    }
                }
                finally {
                    String realm = connection.getHeaderField("WWW-Authenticate");
                    if (realm == null) {
                        throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Did not receive a value for WWW-Authenticate header in the response from Azure Arc Managed Identity Endpoint", null));
                    }
                    int separatorIndex = realm.indexOf("=");
                    if (separatorIndex == -1) {
                        throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Did not receive a correct value for WWW-Authenticate header in the response from Azure Arc Managed Identity Endpoint", null));
                    }
                    String secretKeyPathHeaderValue = realm.substring(separatorIndex + 1);
                    Path secretKeyPath = ValidationUtil.validateSecretFile(new File(secretKeyPathHeaderValue), LOGGER);
                    secretKey = new String(Files.readAllBytes(secretKeyPath), StandardCharsets.UTF_8);
                    if (connection != null) {
                        connection.disconnect();
                    }
                    if (secretKey != null) break block14;
                    throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Did not receive a secret value in the response from Azure Arc Managed Identity Endpoint", null));
                }
            }
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Authorization", "Basic " + secretKey);
                connection.setRequestProperty("Metadata", "true");
                connection.connect();
                MSIToken mSIToken = MSIToken.fromJson(JsonProviders.createReader(connection.getInputStream()));
                return mSIToken;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        });
    }

    public Mono<AccessToken> authenticateWithExchangeToken(TokenRequestContext request) {
        return this.clientAssertionAccessor.getValue().flatMap(assertionToken -> Mono.fromCallable(() -> this.authenticateWithExchangeTokenHelper(request, (String)assertionToken)));
    }

    private Mono<AccessToken> authenticateToServiceFabricManagedIdentityEndpoint(String identityEndpoint, String identityHeader, String thumbprint, TokenRequestContext request) {
        return Mono.fromCallable(() -> {
            HttpURLConnection connection = null;
            String resource = ScopeUtil.scopesToResource(request.getScopes());
            StringBuilder payload = new StringBuilder(1024).append(identityEndpoint);
            payload.append("?resource=");
            payload.append(IdentityClient.urlEncode(resource));
            payload.append("&api-version=");
            payload.append("2019-07-01-preview");
            if (this.clientId != null) {
                LOGGER.warning("User assigned managed identities are not supported in the Service Fabric environment.");
                payload.append("&client_id=");
                payload.append(IdentityClient.urlEncode(this.clientId));
            }
            if (this.resourceId != null) {
                LOGGER.warning("User assigned managed identities are not supported in the Service Fabric environment.");
                payload.append("&mi_res_id=");
                payload.append(IdentityClient.urlEncode(this.resourceId));
            }
            if (this.objectId != null) {
                LOGGER.warning("User-assigned managed identities are not supported in the Service Fabric environment.");
                payload.append("&object_id=");
                payload.append(IdentityClient.urlEncode(this.objectId));
            }
            try {
                URL url = IdentityClient.getUrl(payload.toString());
                connection = (HttpsURLConnection)url.openConnection();
                IdentitySslUtil.addTrustedCertificateThumbprint((HttpsURLConnection)connection, thumbprint, LOGGER);
                connection.setRequestMethod("GET");
                if (identityHeader != null) {
                    connection.setRequestProperty("Secret", identityHeader);
                }
                connection.setRequestProperty("Metadata", "true");
                connection.setRequestProperty("User-Agent", this.userAgent);
                connection.connect();
                MSIToken mSIToken = MSIToken.fromJson(JsonProviders.createReader(connection.getInputStream()));
                return mSIToken;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        });
    }

    public Mono<AccessToken> authenticateToManagedIdentityEndpoint(String identityEndpoint, String identityHeader, String msiEndpoint, String msiSecret, TokenRequestContext request) {
        return Mono.fromCallable(() -> {
            String endpointVersion;
            String headerValue;
            String endpoint;
            if (identityEndpoint != null) {
                endpoint = identityEndpoint;
                headerValue = identityHeader;
                endpointVersion = "2019-08-01";
            } else {
                endpoint = msiEndpoint;
                headerValue = msiSecret;
                endpointVersion = "2017-09-01";
            }
            String resource = ScopeUtil.scopesToResource(request.getScopes());
            HttpURLConnection connection = null;
            StringBuilder payload = new StringBuilder(1024).append(endpoint);
            payload.append("?resource=");
            payload.append(IdentityClient.urlEncode(resource));
            payload.append("&api-version=");
            payload.append(URLEncoder.encode(endpointVersion, StandardCharsets.UTF_8.name()));
            if (this.clientId != null) {
                if (endpointVersion.equals("2019-08-01")) {
                    payload.append("&client_id=");
                } else {
                    if (headerValue == null) {
                        LOGGER.warning("User assigned managed identities are not supported in the Cloud Shell environment.");
                    }
                    payload.append("&clientid=");
                }
                payload.append(IdentityClient.urlEncode(this.clientId));
            }
            if (this.resourceId != null) {
                if (endpointVersion.equals("2017-09-01") && headerValue == null) {
                    LOGGER.warning("User assigned managed identities are not supported in the Cloud Shell environment.");
                }
                payload.append("&mi_res_id=");
                payload.append(IdentityClient.urlEncode(this.resourceId));
            }
            if (this.objectId != null) {
                if (endpointVersion.equals("2017-09-01") && headerValue == null) {
                    LOGGER.warning("User-assigned managed identities are not supported in the Cloud Shell environment.");
                }
                payload.append("&object_id=");
                payload.append(IdentityClient.urlEncode(this.objectId));
            }
            try {
                URL url = IdentityClient.getUrl(payload.toString());
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                if (headerValue != null) {
                    if ("2019-08-01".equals(endpointVersion)) {
                        connection.setRequestProperty("X-IDENTITY-HEADER", headerValue);
                    } else {
                        connection.setRequestProperty("Secret", headerValue);
                    }
                }
                connection.setRequestProperty("Metadata", "true");
                connection.setRequestProperty("User-Agent", this.userAgent);
                connection.connect();
                MSIToken mSIToken = MSIToken.fromJson(JsonProviders.createReader(connection.getInputStream()));
                return mSIToken;
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        });
    }

    public Mono<AccessToken> authenticateToIMDSEndpoint(TokenRequestContext request) {
        String resource = ScopeUtil.scopesToResource(request.getScopes());
        StringBuilder payload = new StringBuilder();
        int imdsUpgradeTimeInMs = 70000;
        try {
            payload.append("api-version=2018-02-01");
            payload.append("&resource=");
            payload.append(IdentityClient.urlEncode(resource));
            if (this.clientId != null) {
                payload.append("&client_id=");
                payload.append(IdentityClient.urlEncode(this.clientId));
            }
            if (this.resourceId != null) {
                payload.append("&mi_res_id=");
                payload.append(IdentityClient.urlEncode(this.resourceId));
            }
            if (this.objectId != null) {
                payload.append("&object_Id=");
                payload.append(IdentityClient.urlEncode(this.objectId));
            }
        }
        catch (IOException exception) {
            return Mono.error(exception);
        }
        String endpoint = this.getImdsEndpoint();
        return this.checkIMDSAvailable(endpoint).flatMap(available -> Mono.fromCallable(() -> {
            int retry = 1;
            while (retry <= this.options.getMaxRetry()) {
                URL url = null;
                HttpURLConnection connection = null;
                try {
                    url = IdentityClient.getUrl(endpoint + "?" + payload);
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("Metadata", "true");
                    connection.setRequestProperty("User-Agent", this.userAgent);
                    connection.connect();
                    MSIToken mSIToken = MSIToken.fromJson(JsonProviders.createReader(connection.getInputStream()));
                    return mSIToken;
                }
                catch (IOException exception) {
                    int responseCode;
                    if (connection == null) {
                        throw LOGGER.logExceptionAsError(new RuntimeException("Could not connect to the url: " + url + ".", exception));
                    }
                    try {
                        responseCode = connection.getResponseCode();
                    }
                    catch (Exception e) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. Connection to IMDS endpoint cannot be established, " + e.getMessage() + ".", (Throwable)e));
                    }
                    if (responseCode == 400) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. Connection to IMDS endpoint cannot be established.", (Throwable)exception));
                    }
                    if (responseCode == 403 && connection.getResponseMessage().contains("A socket operation was attempted to an unreachable network")) {
                        throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("Managed Identity response was not in the expected format. See the inner exception for details.", (Throwable)new Exception(connection.getResponseMessage())));
                    }
                    if (responseCode == 410 || responseCode == 429 || responseCode == 404 || responseCode >= 500 && responseCode <= 599) {
                        int retryTimeoutInMs = this.getRetryTimeoutInMs(retry);
                        int n = retryTimeoutInMs = responseCode == 410 && retryTimeoutInMs < 70000 ? 70000 : retryTimeoutInMs;
                        if (++retry > this.options.getMaxRetry()) break;
                        IdentityClient.sleep(retryTimeoutInMs);
                        continue;
                    }
                    throw LOGGER.logExceptionAsError(new RuntimeException("Couldn't acquire access token from IMDS, verify your objectId, clientId or msiResourceId", exception));
                }
                finally {
                    if (connection == null) continue;
                    connection.disconnect();
                }
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(String.format("MSI: Failed to acquire tokens after retrying %s times", this.options.getMaxRetry())));
        }));
    }

    private String getImdsEndpoint() {
        return TRAILING_FORWARD_SLASHES.matcher(this.options.getImdsAuthorityHost()).replaceAll("") + "/metadata/identity/oauth2/token";
    }

    int getRetryTimeoutInMs(int retry) {
        return (int)this.options.getRetryTimeout().apply(Duration.ofSeconds(retry)).toMillis();
    }

    private Mono<Boolean> checkIMDSAvailable(String endpoint) {
        return Mono.fromCallable(() -> {
            HttpURLConnection connection = null;
            URL url = IdentityClient.getUrl(endpoint + "?api-version=2018-02-01");
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(1000);
                connection.connect();
            }
            catch (Exception e) {
                throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.options, new CredentialUnavailableException("ManagedIdentityCredential authentication unavailable. Connection to IMDS endpoint cannot be established, " + e.getMessage() + ".", (Throwable)e));
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            return true;
        });
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Proxy proxyOptionsToJavaNetProxy(ProxyOptions options) {
        switch (options.getType()) {
            case SOCKS4: 
            case SOCKS5: {
                return new Proxy(Proxy.Type.SOCKS, options.getAddress());
            }
        }
        return new Proxy(Proxy.Type.HTTP, options.getAddress());
    }

    void openUrl(String url) throws IOException {
        Runtime rt = Runtime.getRuntime();
        String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (os.contains("win")) {
            rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else if (os.contains("mac")) {
            rt.exec("open " + url);
        } else if (os.contains("nix") || os.contains("nux")) {
            rt.exec("xdg-open " + url);
        } else {
            LOGGER.error("Browser could not be opened - please open {} in a browser on this device.", url);
        }
    }

    private CompletableFuture<IAuthenticationResult> getFailedCompletableFuture(Exception e) {
        CompletableFuture<IAuthenticationResult> completableFuture = new CompletableFuture<IAuthenticationResult>();
        completableFuture.completeExceptionally(e);
        return completableFuture;
    }

    public IdentityClientOptions getIdentityClientOptions() {
        return this.options;
    }

    private boolean isADFSTenant() {
        return "adfs".equals(this.tenantId);
    }

    @Override
    Function<AppTokenProviderParameters, CompletableFuture<TokenProviderResult>> getWorkloadIdentityTokenProvider() {
        return appTokenProviderParameters -> {
            TokenRequestContext trc = new TokenRequestContext().setScopes(new ArrayList<String>(appTokenProviderParameters.scopes)).setClaims(appTokenProviderParameters.claims).setTenantId(appTokenProviderParameters.tenantId);
            Mono<AccessToken> accessTokenAsync = this.authenticateWithExchangeToken(trc);
            return accessTokenAsync.map(accessToken -> {
                TokenProviderResult result = new TokenProviderResult();
                result.setAccessToken(accessToken.getToken());
                result.setTenantId(trc.getTenantId());
                result.setExpiresInSeconds(accessToken.getExpiresAt().toEpochSecond());
                return result;
            }).toFuture();
        };
    }
}

