/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialUnavailableException;
import com.azure.identity.implementation.IdentityClient;
import com.azure.identity.implementation.IdentityClientBuilder;
import com.azure.identity.implementation.IdentityClientOptions;
import com.azure.identity.implementation.IdentitySyncClient;
import com.azure.identity.implementation.util.LoggingUtil;
import com.azure.identity.implementation.util.ValidationUtil;
import reactor.core.publisher.Mono;

public class WorkloadIdentityCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(WorkloadIdentityCredential.class);
    private final IdentityClient identityClient;
    private final IdentitySyncClient identitySyncClient;
    private final IdentityClientOptions identityClientOptions;

    WorkloadIdentityCredential(String tenantId, String clientId, String federatedTokenFilePath, IdentityClientOptions identityClientOptions) {
        String clientIdInput;
        ValidationUtil.validateTenantIdCharacterRange(tenantId, LOGGER);
        Configuration configuration = identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : identityClientOptions.getConfiguration();
        String tenantIdInput = CoreUtils.isNullOrEmpty(tenantId) ? configuration.get("AZURE_TENANT_ID") : tenantId;
        String federatedTokenFilePathInput = CoreUtils.isNullOrEmpty(federatedTokenFilePath) ? configuration.get("AZURE_FEDERATED_TOKEN_FILE") : federatedTokenFilePath;
        String string = clientIdInput = CoreUtils.isNullOrEmpty(clientId) ? configuration.get("AZURE_CLIENT_ID") : clientId;
        if (!(CoreUtils.isNullOrEmpty(tenantIdInput) || CoreUtils.isNullOrEmpty(federatedTokenFilePathInput) || CoreUtils.isNullOrEmpty(clientIdInput) || CoreUtils.isNullOrEmpty(identityClientOptions.getAuthorityHost()))) {
            IdentityClientBuilder builder = new IdentityClientBuilder().clientAssertionPath(federatedTokenFilePathInput).clientId(clientIdInput).tenantId(tenantIdInput).identityClientOptions(identityClientOptions);
            this.identityClient = builder.build();
            this.identitySyncClient = builder.buildSyncClient();
        } else {
            this.identityClient = null;
            this.identitySyncClient = null;
        }
        this.identityClientOptions = identityClientOptions;
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        if (this.identityClient == null) {
            return Mono.error(LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("WorkloadIdentityCredential authentication unavailable. The workload options are not fully configured. See the troubleshooting guide for more information. https://aka.ms/azsdk/java/identity/workloadidentitycredential/troubleshoot")));
        }
        return this.identityClient.authenticateWithWorkloadIdentityConfidentialClient(request);
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext request) {
        if (this.identitySyncClient == null) {
            throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("WorkloadIdentityCredential authentication unavailable. The workload options are not fully configured. See the troubleshooting guide for more information. https://aka.ms/azsdk/java/identity/workloadidentitycredential/troubleshoot"));
        }
        return this.identitySyncClient.authenticateWithWorkloadIdentityConfidentialClient(request);
    }

    String getClientId() {
        return this.identityClient.getClientId();
    }
}

