/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.identity.CredentialBuilderBase;
import com.azure.identity.EnvironmentCredential;
import com.azure.identity.implementation.util.ValidationUtil;
import java.util.concurrent.ExecutorService;

public class EnvironmentCredentialBuilder
extends CredentialBuilderBase<EnvironmentCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(EnvironmentCredentialBuilder.class);
    private String authorityHost;

    public EnvironmentCredentialBuilder authorityHost(String authorityHost) {
        ValidationUtil.validateAuthHost(authorityHost, LOGGER);
        this.authorityHost = authorityHost;
        return this;
    }

    public EnvironmentCredentialBuilder executorService(ExecutorService executorService) {
        this.identityClientOptions.setExecutorService(executorService);
        return this;
    }

    public EnvironmentCredential build() {
        if (!CoreUtils.isNullOrEmpty(this.authorityHost)) {
            this.identityClientOptions.setAuthorityHost(this.authorityHost);
        }
        return new EnvironmentCredential(this.identityClientOptions);
    }
}

