/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.CloudEventDataFormat;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.annotation.JsonAnyGetter;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.annotation.JsonAnySetter;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.annotation.JsonRawValue;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;

public final class CloudEvent
implements JsonSerializable<CloudEvent> {
    private static final String SPEC_VERSION = "1.0";
    private static final ClientLogger LOGGER = new ClientLogger(CloudEvent.class);
    private static final Set<String> RESERVED_ATTRIBUTE_NAMES = new HashSet<String>(Arrays.asList("specversion", "id", "source", "type", "datacontenttype", "dataschema", "subject", "time", "data", "data_base64"));
    private static final String ILLEGAL_ATTRIBUTE_NAME_MESSAGE = "Extension attribute 'name' must have only lower-case alphanumeric characters and not be one of the CloudEvent reserved attribute names: " + String.join((CharSequence)", ", RESERVED_ATTRIBUTE_NAMES);
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="source", required=true)
    private String source;
    @JsonProperty(value="data")
    @JsonRawValue
    @JsonDeserialize(using=AnyToStringDeserializer.class)
    private String data;
    @JsonProperty(value="data_base64")
    private String dataBase64;
    @JsonProperty(value="type", required=true)
    private String type;
    @JsonProperty(value="time")
    private OffsetDateTime time;
    @JsonProperty(value="specversion", required=true)
    private String specVersion;
    @JsonProperty(value="dataschema")
    private String dataSchema;
    @JsonProperty(value="datacontenttype")
    private String dataContentType;
    @JsonProperty(value="subject")
    private String subject;
    @JsonIgnore
    private Map<String, Object> extensionAttributes;
    @JsonIgnore
    private BinaryData binaryData;

    public CloudEvent(String source, String type, BinaryData data, CloudEventDataFormat format, String dataContentType) {
        this.source = Objects.requireNonNull(source, "'source' cannot be null.");
        this.type = Objects.requireNonNull(type, "'type' cannot be null.");
        if (data != null) {
            Objects.requireNonNull(format, "'format' cannot be null when 'data' isn't null.");
            if (CloudEventDataFormat.BYTES == format) {
                this.dataBase64 = Base64.getEncoder().encodeToString(data.toBytes());
            } else {
                try (JsonReader jsonReader = JsonProviders.createReader(data.toBytes());){
                    JsonToken token = jsonReader.nextToken();
                    this.data = token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY ? jsonReader.readChildren() : (token == JsonToken.STRING ? "\"" + jsonReader.getString() + "\"" : jsonReader.getString());
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError(new IllegalArgumentException("'data' isn't in valid Json format", e));
                }
            }
        }
        this.dataContentType = dataContentType;
        this.id = CoreUtils.randomUuid().toString();
        this.specVersion = SPEC_VERSION;
        this.binaryData = data;
        this.time = OffsetDateTime.now(ZoneOffset.UTC);
    }

    private CloudEvent() {
    }

    public static List<CloudEvent> fromString(String cloudEventsJson) {
        return CloudEvent.fromString(cloudEventsJson, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<CloudEvent> fromString(String cloudEventsJson, boolean skipValidation) {
        ArrayList<CloudEvent> cloudEvents;
        Objects.requireNonNull(cloudEventsJson, "'cloudEventsJson' cannot be null");
        try (JsonReader jsonReader = JsonProviders.createReader(cloudEventsJson);){
            JsonToken arrayOrObjectCheckToken = jsonReader.nextToken();
            if (arrayOrObjectCheckToken == JsonToken.START_OBJECT) {
                cloudEvents = new ArrayList<CloudEvent>(1);
                cloudEvents.add(jsonReader.readObject(CloudEvent::fromJson));
            } else {
                if (arrayOrObjectCheckToken != JsonToken.START_ARRAY) {
                    if (arrayOrObjectCheckToken != JsonToken.NULL) throw LOGGER.logExceptionAsError(new IllegalArgumentException("JSON string started at an invalid state for reading a single instance or an array of CloudEvents. Starting token was: " + (Object)((Object)arrayOrObjectCheckToken)));
                    List<CloudEvent> list = null;
                    return list;
                }
                cloudEvents = jsonReader.readArray(CloudEvent::fromJson);
            }
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(ex));
        }
        if (skipValidation) return cloudEvents;
        if (cloudEvents == null) {
            return cloudEvents;
        }
        int i = 0;
        while (i < cloudEvents.size()) {
            CloudEvent event = (CloudEvent)cloudEvents.get(i);
            if (event.getId() == null || event.getSource() == null || event.getType() == null) {
                ArrayList<String> nullAttributes = new ArrayList<String>();
                if (event.getId() == null) {
                    nullAttributes.add("'id'");
                }
                if (event.getSource() == null) {
                    nullAttributes.add("'source'");
                }
                if (event.getType() != null) throw LOGGER.logExceptionAsError(new IllegalArgumentException("'id', 'source' and 'type' are mandatory attributes for a CloudEvent according to the spec. This JSON string doesn't have " + CoreUtils.stringJoin(", ", nullAttributes) + " for the object at index " + i + ". Please make sure the input Json string has the required attributes or use CloudEvent.fromString(cloudEventsJson, true) to skip the null check."));
                nullAttributes.add("'type'");
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("'id', 'source' and 'type' are mandatory attributes for a CloudEvent according to the spec. This JSON string doesn't have " + CoreUtils.stringJoin(", ", nullAttributes) + " for the object at index " + i + ". Please make sure the input Json string has the required attributes or use CloudEvent.fromString(cloudEventsJson, true) to skip the null check."));
            }
            ++i;
        }
        return cloudEvents;
    }

    public String getId() {
        return this.id;
    }

    public CloudEvent setId(String id) {
        Objects.requireNonNull(id, "'id' cannot be null");
        if (id.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'id' cannot be empty"));
        }
        this.id = id;
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public BinaryData getData() {
        if (this.binaryData == null) {
            if (this.data != null) {
                this.binaryData = BinaryData.fromString(this.data);
            } else if (this.dataBase64 != null) {
                this.binaryData = BinaryData.fromBytes(Base64.getDecoder().decode(this.dataBase64));
            }
        }
        return this.binaryData;
    }

    public String getType() {
        return this.type;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public CloudEvent setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public String getDataContentType() {
        return this.dataContentType;
    }

    public String getDataSchema() {
        return this.dataSchema;
    }

    public CloudEvent setDataSchema(String dataSchema) {
        this.dataSchema = dataSchema;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public CloudEvent setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getExtensionAttributes() {
        return this.extensionAttributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.extensionAttributes);
    }

    @JsonAnySetter
    public CloudEvent addExtensionAttribute(String name, Object value) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(value, "'value' cannot be null.");
        if (!CloudEvent.validateAttributeName(name)) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(ILLEGAL_ATTRIBUTE_NAME_MESSAGE));
        }
        if (this.extensionAttributes == null) {
            this.extensionAttributes = new HashMap<String, Object>();
        }
        this.extensionAttributes.put(name, value);
        return this;
    }

    String getSpecVersion() {
        return this.specVersion;
    }

    CloudEvent setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
        return this;
    }

    private static boolean validateAttributeName(String name) {
        if (RESERVED_ATTRIBUTE_NAMES.contains(name)) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("id", this.id).writeStringField("source", this.source);
        if (this.dataBase64 != null) {
            jsonWriter.writeStringField("data_base64", this.dataBase64);
        } else if (this.data != null) {
            jsonWriter.writeRawField("data", this.data);
        } else {
            jsonWriter.writeNullField("data");
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.time != null) {
            jsonWriter.writeStringField("time", this.time.toString());
        }
        jsonWriter.writeStringField("specversion", this.specVersion).writeStringField("dataschema", this.dataSchema).writeStringField("datacontenttype", this.dataContentType).writeStringField("subject", this.subject);
        if (!CoreUtils.isNullOrEmpty(this.extensionAttributes)) {
            for (Map.Entry<String, Object> extensionAttribute : this.extensionAttributes.entrySet()) {
                jsonWriter.writeUntypedField(String.valueOf(extensionAttribute.getKey()), extensionAttribute.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CloudEvent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CloudEvent cloudEvent = new CloudEvent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                JsonToken token = reader.nextToken();
                if ("id".equals(fieldName)) {
                    cloudEvent.id = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    cloudEvent.source = reader.getString();
                    continue;
                }
                if ("data".equals(fieldName)) {
                    if (token == JsonToken.START_OBJECT || token == JsonToken.START_ARRAY) {
                        cloudEvent.data = jsonReader.readChildren();
                        continue;
                    }
                    if (token == JsonToken.STRING) {
                        cloudEvent.data = "\"" + jsonReader.getRawText() + "\"";
                        continue;
                    }
                    cloudEvent.data = jsonReader.getString();
                    continue;
                }
                if ("data_base64".equals(fieldName)) {
                    cloudEvent.dataBase64 = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    cloudEvent.type = reader.getString();
                    continue;
                }
                if ("time".equals(fieldName)) {
                    cloudEvent.time = reader.getNullable(r -> OffsetDateTime.parse(r.getString()));
                    continue;
                }
                if ("specversion".equals(fieldName)) {
                    cloudEvent.specVersion = reader.getString();
                    continue;
                }
                if ("dataschema".equals(fieldName)) {
                    cloudEvent.dataSchema = reader.getString();
                    continue;
                }
                if ("datacontenttype".equals(fieldName)) {
                    cloudEvent.dataContentType = reader.getString();
                    continue;
                }
                if ("subject".equals(fieldName)) {
                    cloudEvent.subject = reader.getString();
                    continue;
                }
                if (cloudEvent.extensionAttributes == null) {
                    cloudEvent.extensionAttributes = new LinkedHashMap<String, Object>();
                }
                cloudEvent.extensionAttributes.put(fieldName, reader.readUntyped());
            }
            return cloudEvent;
        });
    }

    private static final class AnyToStringDeserializer
    extends JsonDeserializer<String> {
        private AnyToStringDeserializer() {
        }

        @Override
        public String deserialize(JsonParser p, DeserializationContext context) throws IOException {
            return p.readValueAsTree().toString();
        }
    }
}

