/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.HTTPHeaders;
import org.apache.iceberg.rest.HTTPRequest;
import org.apache.iceberg.rest.ImmutableHTTPHeaders;
import org.apache.iceberg.rest.ImmutableHTTPRequest;
import org.apache.iceberg.rest.auth.AuthSession;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.auth.signer.params.SignerChecksumParams;
import software.amazon.awssdk.core.checksums.Algorithm;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

public class RESTSigV4AuthSession
implements AuthSession {
    static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    static final String RELOCATED_HEADER_PREFIX = "Original-";
    private final Aws4Signer signer;
    private final AuthSession delegate;
    private final Region signingRegion;
    private final String signingName;
    private final AwsCredentialsProvider credentialsProvider;

    public RESTSigV4AuthSession(Aws4Signer aws4Signer, AuthSession delegateAuthSession, AwsProperties awsProperties) {
        this.signer = (Aws4Signer)Preconditions.checkNotNull((Object)aws4Signer, (Object)"Invalid signer: null");
        this.delegate = (AuthSession)Preconditions.checkNotNull((Object)delegateAuthSession, (Object)"Invalid delegate: null");
        Preconditions.checkNotNull((Object)awsProperties, (Object)"Invalid AWS properties: null");
        this.signingRegion = awsProperties.restSigningRegion();
        this.signingName = awsProperties.restSigningName();
        this.credentialsProvider = awsProperties.restCredentialsProvider();
    }

    public HTTPRequest authenticate(HTTPRequest request) {
        return this.sign(this.delegate.authenticate(request));
    }

    public void close() {
        this.delegate.close();
    }

    private HTTPRequest sign(HTTPRequest request) {
        Aws4SignerParams params = Aws4SignerParams.builder().signingName(this.signingName).signingRegion(this.signingRegion).awsCredentials(this.credentialsProvider.resolveCredentials()).checksumParams(SignerChecksumParams.builder().algorithm(Algorithm.SHA256).isStreamingRequest(false).checksumHeaderName("x-amz-content-sha256").build()).build();
        SdkHttpFullRequest.Builder sdkRequestBuilder = SdkHttpFullRequest.builder();
        URI uri = request.requestUri();
        sdkRequestBuilder.method(SdkHttpMethod.fromValue((String)request.method().name())).protocol(uri.getScheme()).uri(uri).headers(this.convertHeaders(request.headers()));
        String body = request.encodedBody();
        if (body == null) {
            sdkRequestBuilder.putHeader("x-amz-content-sha256", EMPTY_BODY_SHA256);
        } else {
            sdkRequestBuilder.contentStreamProvider(() -> IOUtils.toInputStream((String)body, (Charset)StandardCharsets.UTF_8));
        }
        SdkHttpFullRequest signedSdkRequest = this.signer.sign(sdkRequestBuilder.build(), params);
        HTTPHeaders newHeaders = this.updateRequestHeaders(request.headers(), signedSdkRequest.headers());
        return ImmutableHTTPRequest.builder().from(request).headers(newHeaders).build();
    }

    private Map<String, List<String>> convertHeaders(HTTPHeaders headers) {
        return headers.entries().stream().collect(Collectors.groupingBy(header -> header.name().equalsIgnoreCase("Authorization") ? RELOCATED_HEADER_PREFIX + header.name() : header.name(), Collectors.mapping(HTTPHeaders.HTTPHeader::value, Collectors.toList())));
    }

    private HTTPHeaders updateRequestHeaders(HTTPHeaders originalHeaders, Map<String, List<String>> signedHeaders) {
        ImmutableHTTPHeaders.Builder newHeaders = ImmutableHTTPHeaders.builder();
        signedHeaders.forEach((name, signedValues) -> {
            if (originalHeaders.contains(name)) {
                for (HTTPHeaders.HTTPHeader originalHeader : originalHeaders.entries(name)) {
                    if (signedValues.contains(originalHeader.value())) continue;
                    newHeaders.addEntry(HTTPHeaders.HTTPHeader.of((String)(RELOCATED_HEADER_PREFIX + name), (String)originalHeader.value()));
                }
            }
            signedValues.forEach(value -> newHeaders.addEntry(HTTPHeaders.HTTPHeader.of((String)name, (String)value)));
        });
        return newHeaders.build();
    }
}

