/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.util.Map;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.RESTSigV4AuthSession;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.auth.AuthManager;
import org.apache.iceberg.rest.auth.AuthSession;
import software.amazon.awssdk.auth.signer.Aws4Signer;

public class RESTSigV4AuthManager
implements AuthManager {
    private final Aws4Signer signer = Aws4Signer.create();
    private final AuthManager delegate;
    private Map<String, String> catalogProperties = Map.of();

    public RESTSigV4AuthManager(String name, AuthManager delegate) {
        this.delegate = (AuthManager)Preconditions.checkNotNull((Object)delegate, (Object)"Invalid delegate: null");
    }

    public RESTSigV4AuthSession initSession(RESTClient initClient, Map<String, String> properties) {
        return new RESTSigV4AuthSession(this.signer, this.delegate.initSession(initClient, properties), new AwsProperties(properties));
    }

    public RESTSigV4AuthSession catalogSession(RESTClient sharedClient, Map<String, String> properties) {
        this.catalogProperties = properties;
        AwsProperties awsProperties = new AwsProperties(this.catalogProperties);
        return new RESTSigV4AuthSession(this.signer, this.delegate.catalogSession(sharedClient, this.catalogProperties), awsProperties);
    }

    public AuthSession contextualSession(SessionCatalog.SessionContext context, AuthSession parent) {
        AwsProperties contextProperties = new AwsProperties(RESTUtil.merge(this.catalogProperties, (Map)context.properties()));
        return new RESTSigV4AuthSession(this.signer, this.delegate.contextualSession(context, parent), contextProperties);
    }

    public AuthSession tableSession(TableIdentifier table, Map<String, String> properties, AuthSession parent) {
        AwsProperties tableProperties = new AwsProperties(RESTUtil.merge(this.catalogProperties, properties));
        return new RESTSigV4AuthSession(this.signer, this.delegate.tableSession(table, properties, parent), tableProperties);
    }

    public void close() {
        this.delegate.close();
    }
}

