/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class IndexParents
extends TypeUtil.SchemaVisitor<Map<Integer, Integer>> {
    private final Map<Integer, Integer> idToParent = Maps.newHashMap();
    private final Deque<Integer> idStack = Lists.newLinkedList();

    @Override
    public void beforeField(Types.NestedField field) {
        this.idStack.push(field.fieldId());
    }

    @Override
    public void afterField(Types.NestedField field) {
        this.idStack.pop();
    }

    @Override
    public Map<Integer, Integer> schema(Schema schema, Map<Integer, Integer> structResult) {
        return this.idToParent;
    }

    @Override
    public Map<Integer, Integer> struct(Types.StructType struct, List<Map<Integer, Integer>> fieldResults) {
        for (Types.NestedField field : struct.fields()) {
            Integer parentId = this.idStack.peek();
            if (parentId == null) continue;
            this.idToParent.put(field.fieldId(), parentId);
        }
        return this.idToParent;
    }

    @Override
    public Map<Integer, Integer> field(Types.NestedField field, Map<Integer, Integer> fieldResult) {
        return this.idToParent;
    }

    @Override
    public Map<Integer, Integer> list(Types.ListType list, Map<Integer, Integer> element) {
        this.idToParent.put(list.elementId(), this.idStack.peek());
        return this.idToParent;
    }

    @Override
    public Map<Integer, Integer> map(Types.MapType map, Map<Integer, Integer> key, Map<Integer, Integer> value) {
        this.idToParent.put(map.keyId(), this.idStack.peek());
        this.idToParent.put(map.valueId(), this.idStack.peek());
        return this.idToParent;
    }

    @Override
    public Map<Integer, Integer> variant() {
        return this.idToParent;
    }

    @Override
    public Map<Integer, Integer> primitive(Type.PrimitiveType primitive) {
        return this.idToParent;
    }
}

