/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Table;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.UpdateStatistics;

public interface Transaction {
    public Table table();

    public UpdateSchema updateSchema();

    public UpdatePartitionSpec updateSpec();

    public UpdateProperties updateProperties();

    public ReplaceSortOrder replaceSortOrder();

    public UpdateLocation updateLocation();

    public AppendFiles newAppend();

    default public AppendFiles newFastAppend() {
        return this.newAppend();
    }

    public RewriteFiles newRewrite();

    public RewriteManifests rewriteManifests();

    public OverwriteFiles newOverwrite();

    public RowDelta newRowDelta();

    public ReplacePartitions newReplacePartitions();

    public DeleteFiles newDelete();

    default public UpdateStatistics updateStatistics() {
        throw new UnsupportedOperationException("Updating statistics is not supported by " + this.getClass().getName());
    }

    public ExpireSnapshots expireSnapshots();

    default public ManageSnapshots manageSnapshots() {
        throw new UnsupportedOperationException("Managing snapshots is not supported by " + this.getClass().getName());
    }

    public void commitTransaction();
}

