/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieDatasetBulkInsertHelper$;
import org.apache.hudi.HoodieSparkSqlWriter;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.SparkConfigs$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieBootstrapConfig;
import org.apache.hudi.config.HoodieInternalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BulkInsertInternalPartitionerWithRowsFactory;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.execution.bulkinsert.NonSortPartitionerWithRows;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.AvroSchemaEvolutionUtils;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.util.SyncUtilHelpers;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.package$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class HoodieSparkSqlWriter$ {
    public static HoodieSparkSqlWriter$ MODULE$;
    private final Logger log;
    private boolean tableExists;
    private boolean asyncCompactionTriggerFnDefined;
    private boolean asyncClusteringTriggerFnDefined;

    static {
        new HoodieSparkSqlWriter$();
    }

    private Logger log() {
        return this.log;
    }

    private boolean tableExists() {
        return this.tableExists;
    }

    private void tableExists_$eq(boolean x$1) {
        this.tableExists = x$1;
    }

    private boolean asyncCompactionTriggerFnDefined() {
        return this.asyncCompactionTriggerFnDefined;
    }

    private void asyncCompactionTriggerFnDefined_$eq(boolean x$1) {
        this.asyncCompactionTriggerFnDefined = x$1;
    }

    private boolean asyncClusteringTriggerFnDefined() {
        return this.asyncClusteringTriggerFnDefined;
    }

    private void asyncClusteringTriggerFnDefined_$eq(boolean x$1) {
        this.asyncClusteringTriggerFnDefined = x$1;
    }

    public Tuple6<Object, Option<String>, Option<String>, Option<String>, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, HoodieTableConfig> write(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> optParams, Dataset<Row> df, scala.Option<HoodieTableConfig> hoodieTableConfigOpt, scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> hoodieWriteClient, scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> asyncCompactionTriggerFn, scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> asyncClusteringTriggerFn) {
        Tuple6 tuple6;
        block28: {
            SparkRDDWriteClient writeClient;
            HoodieWriteResult writeResult;
            String commitActionType;
            String instantTime;
            JavaSparkContext jsc;
            WriteOperationType operation;
            scala.collection.immutable.Map parameters;
            HoodieTableConfig tableConfig;
            Path basePath;
            block33: {
                Tuple2 tuple2;
                block32: {
                    Tuple2 tuple22;
                    Boolean dropPartitionColumns;
                    String partitionColumns;
                    KeyGenerator keyGenerator;
                    String tblName;
                    HoodieConfig hoodieConfig;
                    FileSystem fs;
                    SparkContext sparkContext;
                    String path;
                    block29: {
                        Option commitTime;
                        boolean success;
                        block31: {
                            Tuple2<Object, Option<String>> tuple23;
                            block30: {
                                HoodieTableType tableType;
                                String databaseName;
                                scala.collection.immutable.Map<String, String> timestampKeyGeneratorConfigs;
                                String originKeyGeneratorClassName;
                                block27: {
                                    Some some;
                                    String ser;
                                    Predef$.MODULE$.assert(optParams.get((Object)"path").exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$write$1(x$1))), (Function0 & Serializable & scala.Serializable)() -> "'path' must be set");
                                    path = (String)optParams.apply((Object)"path");
                                    basePath = new Path(path);
                                    sparkContext = sqlContext.sparkContext();
                                    fs = basePath.getFileSystem(sparkContext.hadoopConfiguration());
                                    this.tableExists_$eq(fs.exists(new Path(basePath, ".hoodie")));
                                    tableConfig = this.getHoodieTableConfig(sparkContext, path, hoodieTableConfigOpt);
                                    SaveMode saveMode = mode;
                                    SaveMode saveMode2 = SaveMode.Overwrite;
                                    HoodieWriterUtils$.MODULE$.validateTableConfig(sqlContext.sparkSession(), optParams, (HoodieConfig)tableConfig, !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null));
                                    Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> tuple24 = this.mergeParamsAndGetHoodieConfig(optParams, tableConfig, mode);
                                    if (tuple24 == null) {
                                        throw new MatchError(tuple24);
                                    }
                                    scala.collection.immutable.Map parameters2 = (scala.collection.immutable.Map)tuple24._1();
                                    HoodieConfig hoodieConfig2 = (HoodieConfig)tuple24._2();
                                    Tuple2 tuple25 = new Tuple2((Object)parameters2, (Object)hoodieConfig2);
                                    Tuple2 tuple26 = tuple25;
                                    parameters = (scala.collection.immutable.Map)tuple26._1();
                                    hoodieConfig = (HoodieConfig)tuple26._2();
                                    originKeyGeneratorClassName = HoodieWriterUtils$.MODULE$.getOriginKeyGenerator((scala.collection.immutable.Map<String, String>)parameters);
                                    timestampKeyGeneratorConfigs = this.extractConfigsRelatedToTimestampBasedKeyGenerator(originKeyGeneratorClassName, (scala.collection.immutable.Map<String, String>)parameters);
                                    HoodieWriterUtils$.MODULE$.validateKeyGeneratorConfig(originKeyGeneratorClassName, (HoodieConfig)tableConfig);
                                    databaseName = hoodieConfig.getStringOrDefault(HoodieTableConfig.DATABASE_NAME, "");
                                    tblName = hoodieConfig.getStringOrThrow(HoodieWriteConfig.TBL_NAME, new StringBuilder(15).append("'").append(HoodieWriteConfig.TBL_NAME.key()).append("' must be set.").toString()).trim();
                                    Predef$.MODULE$.assert(!StringUtils.isNullOrEmpty((String)hoodieConfig.getString(HoodieWriteConfig.TBL_NAME)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("'").append(HoodieWriteConfig.TBL_NAME.key()).append("' must be set.").toString());
                                    this.asyncCompactionTriggerFnDefined_$eq(asyncCompactionTriggerFn.isDefined());
                                    this.asyncClusteringTriggerFnDefined_$eq(asyncClusteringTriggerFn.isDefined());
                                    scala.Option option = sparkContext.getConf().getOption("spark.serializer");
                                    if (!(option instanceof Some) || !(ser = (String)(some = (Some)option).value()).equals("org.apache.spark.serializer.KryoSerializer")) {
                                        throw new HoodieException("hoodie only support org.apache.spark.serializer.KryoSerializer as spark.serializer");
                                    }
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    tableType = HoodieTableType.valueOf((String)hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.TABLE_TYPE()));
                                    operation = WriteOperationType.fromValue((String)hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.OPERATION()));
                                    if (Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS()))) {
                                        WriteOperationType writeOperationType = operation;
                                        WriteOperationType writeOperationType2 = WriteOperationType.UPSERT;
                                        if (!(writeOperationType != null ? !writeOperationType.equals(writeOperationType2) : writeOperationType2 != null)) {
                                            this.log().warn((Object)new StringBuilder(66).append(DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()).append(" is not applicable ").append("when ").append(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS()).append(" is set to be true, ").append("overriding the ").append(DataSourceWriteOptions$.MODULE$.OPERATION()).append(" to be ").append(DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).toString());
                                            operation = WriteOperationType.INSERT;
                                        }
                                    }
                                    jsc = new JavaSparkContext(sparkContext);
                                    if (asyncCompactionTriggerFn.isDefined() && jsc.getConf().getOption(SparkConfigs$.MODULE$.SPARK_SCHEDULER_ALLOCATION_FILE_KEY()).isDefined()) {
                                        jsc.setLocalProperty("spark.scheduler.pool", SparkConfigs$.MODULE$.SPARK_DATASOURCE_WRITER_POOL_NAME());
                                    }
                                    instantTime = HoodieActiveTimeline.createNewInstantTime();
                                    keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator((TypedProperties)new TypedProperties((Properties)hoodieConfig.getProps()));
                                    SaveMode saveMode3 = mode;
                                    SaveMode saveMode4 = SaveMode.Ignore;
                                    if ((saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) || !this.tableExists()) break block27;
                                    this.log().warn((Object)new StringBuilder(73).append("hoodie table at ").append(basePath).append(" already exists. Ignoring & not performing actual writes.").toString());
                                    tuple6 = new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Option.empty(), (Object)Option.empty(), (Object)Option.empty(), hoodieWriteClient.orNull(Predef$.MODULE$.$conforms()), (Object)tableConfig);
                                    break block28;
                                }
                                this.handleSaveModes(sqlContext.sparkSession(), mode, basePath, tableConfig, tblName, operation, fs);
                                partitionColumns = HoodieSparkUtils$.MODULE$.getPartitionColumns(keyGenerator, HoodieConversionUtils$.MODULE$.toProperties(parameters));
                                if (!this.tableExists()) {
                                    String baseFileFormat = hoodieConfig.getStringOrDefault(HoodieTableConfig.BASE_FILE_FORMAT);
                                    String archiveLogFolder = hoodieConfig.getStringOrDefault(HoodieTableConfig.ARCHIVELOG_FOLDER);
                                    String recordKeyFields = hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD());
                                    boolean populateMetaFields = hoodieConfig.getBooleanOrDefault(HoodieTableConfig.POPULATE_META_FIELDS);
                                    boolean useBaseFormatMetaFile = hoodieConfig.getBooleanOrDefault(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT);
                                    HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.withPropertyBuilder().setTableType(tableType).setDatabaseName(databaseName).setTableName(tblName).setRecordKeyFields(recordKeyFields).setBaseFileFormat(baseFileFormat).setArchiveLogFolder(archiveLogFolder).setPayloadClassName(hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME())).setPreCombineField((String)optParams.getOrElse((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), (Function0 & Serializable & scala.Serializable)() -> null)).setPartitionFields(partitionColumns).setPopulateMetaFields(populateMetaFields).setRecordKeyFields(hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD())).setKeyGeneratorClassProp(originKeyGeneratorClassName).set(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap(timestampKeyGeneratorConfigs)).setHiveStylePartitioningEnable(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING())).setUrlEncodePartitioning(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING())).setPartitionMetafileUseBaseFormat(Predef$.MODULE$.boolean2Boolean(useBaseFormatMetaFile)).setShouldDropPartitionColumns(Predef$.MODULE$.boolean2Boolean(hoodieConfig.getBooleanOrDefault(HoodieTableConfig.DROP_PARTITION_COLUMNS))).setCommitTimezone(HoodieTimelineTimeZone.valueOf((String)hoodieConfig.getStringOrDefault(HoodieTableConfig.TIMELINE_TIMEZONE))).initTable(sparkContext.hadoopConfiguration(), path);
                                    tableConfig = tableMetaClient.getTableConfig();
                                }
                                commitActionType = CommitUtils.getCommitActionType((WriteOperationType)operation, (HoodieTableType)tableConfig.getTableType());
                                dropPartitionColumns = hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS());
                                if (!Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER()))) break block29;
                                WriteOperationType writeOperationType = operation;
                                WriteOperationType writeOperationType3 = WriteOperationType.BULK_INSERT;
                                if (writeOperationType != null ? !writeOperationType.equals(writeOperationType3) : writeOperationType3 != null) break block29;
                                tuple23 = this.bulkInsertAsRow(sqlContext, (scala.collection.immutable.Map<String, String>)parameters, df, tblName, basePath, path, instantTime, partitionColumns);
                                if (tuple23 == null) break block30;
                                success = tuple23._1$mcZ$sp();
                                commitTime = (Option)tuple23._2();
                                if (commitTime != null) break block31;
                            }
                            throw new MatchError(tuple23);
                        }
                        Option option = commitTime;
                        Tuple2 tuple27 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)success), (Object)option);
                        Tuple2 tuple28 = tuple27;
                        boolean success2 = tuple28._1$mcZ$sp();
                        Option commitTime2 = (Option)tuple28._2();
                        return new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)success2), (Object)commitTime2, (Object)Option.empty(), (Object)Option.empty(), hoodieWriteClient.orNull(Predef$.MODULE$.$conforms()), (Object)tableConfig);
                    }
                    boolean reconcileSchema = new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA().key()))).toBoolean();
                    WriteOperationType writeOperationType = operation;
                    if (WriteOperationType.DELETE.equals(writeOperationType)) {
                        RDD<GenericRecord> genericRecords = this.registerKryoClassesAndGetGenericRecords(tblName, sparkContext, df, reconcileSchema);
                        JavaRDD hoodieKeysToDelete = genericRecords.map((Function1 & Serializable & scala.Serializable)gr -> keyGenerator.getKey(gr), ClassTag$.MODULE$.apply(HoodieKey.class)).toJavaRDD();
                        if (!this.tableExists()) {
                            throw new HoodieException(new StringBuilder(31).append("hoodie table at ").append(basePath).append(" does not exist").toString());
                        }
                        scala.Option<InternalSchema> internalSchemaOpt = this.getLatestTableInternalSchema(fs, basePath, sparkContext);
                        SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataSourceUtils.createHoodieClient(jsc, null, path, tblName, JavaConversions$.MODULE$.mapAsJavaMap(MODULE$.addSchemaEvolutionParameters((scala.collection.immutable.Map<String, String>)parameters, internalSchemaOpt).$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key()))));
                        Object object = this.isAsyncCompactionEnabled((SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>)client, tableConfig, (scala.collection.immutable.Map<String, String>)parameters, jsc.hadoopConfiguration()) ? ((Function1)asyncCompactionTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                        Object object2 = this.isAsyncClusteringEnabled((SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>)client, (scala.collection.immutable.Map<String, String>)parameters) ? ((Function1)asyncClusteringTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                        client.startCommitWithTime(instantTime, commitActionType);
                        HoodieWriteResult writeStatuses = DataSourceUtils.doDeleteOperation(client, (JavaRDD<HoodieKey>)hoodieKeysToDelete, instantTime);
                        tuple22 = new Tuple2((Object)writeStatuses, (Object)client);
                    } else if (WriteOperationType.DELETE_PARTITION.equals(writeOperationType)) {
                        java.util.List list;
                        if (!this.tableExists()) {
                            throw new HoodieException(new StringBuilder(31).append("hoodie table at ").append(basePath).append(" does not exist").toString());
                        }
                        if (JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)parameters).containsKey(DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key())) {
                            String[] partitionColsToDelete = ((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.PARTITIONS_TO_DELETE().key())).split(",");
                            list = Arrays.asList((Object[])partitionColsToDelete);
                        } else {
                            RDD<GenericRecord> genericRecords = this.registerKryoClassesAndGetGenericRecords(tblName, sparkContext, df, reconcileSchema);
                            list = genericRecords.map((Function1 & Serializable & scala.Serializable)gr -> keyGenerator.getKey(gr).getPartitionPath(), ClassTag$.MODULE$.apply(String.class)).toJavaRDD().distinct().collect();
                        }
                        java.util.List partitionsToDelete = list;
                        SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataSourceUtils.createHoodieClient(jsc, null, path, tblName, JavaConversions$.MODULE$.mapAsJavaMap(parameters.$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key()))));
                        client.startCommitWithTime(instantTime, commitActionType);
                        HoodieWriteResult writeStatuses = DataSourceUtils.doDeletePartitionsOperation(client, partitionsToDelete, instantTime);
                        tuple22 = new Tuple2((Object)writeStatuses, (Object)client);
                    } else {
                        Schema schema;
                        Tuple2 tuple29 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tblName);
                        if (tuple29 == null) {
                            throw new MatchError((Object)tuple29);
                        }
                        String structName = (String)tuple29._1();
                        String nameSpace = (String)tuple29._2();
                        Tuple2 tuple210 = new Tuple2((Object)structName, (Object)nameSpace);
                        Tuple2 tuple211 = tuple210;
                        String structName2 = (String)tuple211._1();
                        String nameSpace2 = (String)tuple211._2();
                        sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
                        Schema sourceSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)df.schema(), structName2, nameSpace2);
                        Schema latestTableSchema = (Schema)this.getLatestTableSchema(fs, basePath, sparkContext).getOrElse((Function0 & Serializable & scala.Serializable)() -> sourceSchema);
                        boolean schemaEvolutionEnabled = new StringOps(Predef$.MODULE$.augmentString(JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)parameters).getOrDefault(DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().key(), "false"))).toBoolean();
                        ObjectRef internalSchemaOpt = ObjectRef.create(this.getLatestTableInternalSchema(fs, basePath, sparkContext));
                        if (reconcileSchema) {
                            if (schemaEvolutionEnabled && ((scala.Option)internalSchemaOpt.elem).isEmpty()) {
                                internalSchemaOpt.elem = new Some((Object)AvroInternalSchemaConverter.convert((Schema)sourceSchema));
                            }
                            if (((scala.Option)internalSchemaOpt.elem).isDefined()) {
                                InternalSchema mergedInternalSchema = AvroSchemaEvolutionUtils.reconcileSchema((Schema)sourceSchema, (InternalSchema)((InternalSchema)((scala.Option)internalSchemaOpt.elem).get()));
                                schema = AvroInternalSchemaConverter.convert((InternalSchema)mergedInternalSchema, (String)latestTableSchema.getName());
                            } else {
                                schema = TableSchemaResolver.isSchemaCompatible((Schema)sourceSchema, (Schema)latestTableSchema) ? latestTableSchema : sourceSchema;
                            }
                        } else {
                            schema = AvroSchemaEvolutionUtils.canonicalizeColumnNullability((Schema)sourceSchema, (Schema)latestTableSchema);
                        }
                        Schema writerSchema = schema;
                        this.validateSchemaForHoodieIsDeleted(writerSchema);
                        sparkContext.getConf().registerAvroSchemas((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{writerSchema}));
                        this.log().info((Object)new StringBuilder(25).append("Registered avro schema : ").append(writerSchema.toString(true)).toString());
                        RDD genericRecords = HoodieSparkUtils$.MODULE$.createRdd(df, structName2, nameSpace2, reconcileSchema, Option.of((Object)writerSchema));
                        boolean shouldCombine = new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key()))).toBoolean() || operation.equals((Object)WriteOperationType.UPSERT) || new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)HoodieWriteConfig.COMBINE_BEFORE_INSERT.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieWriteConfig.COMBINE_BEFORE_INSERT.defaultValue()))).toBoolean();
                        JavaRDD<HoodieRecord> hoodieAllIncomingRecords = genericRecords.map((Function1 & Serializable & scala.Serializable)gr -> {
                            HoodieRecord hoodieRecord;
                            GenericRecord processedRecord = MODULE$.getProcessedRecord(partitionColumns, (GenericRecord)gr, Predef$.MODULE$.Boolean2boolean(dropPartitionColumns));
                            if (shouldCombine) {
                                Comparable orderingVal = (Comparable)HoodieAvroUtils.getNestedFieldVal((GenericRecord)gr, (String)hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD()), (boolean)false, (boolean)new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED().key(), (Function0 & Serializable & scala.Serializable)() -> (String)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED().defaultValue()))).toBoolean());
                                hoodieRecord = DataSourceUtils.createHoodieRecord(processedRecord, orderingVal, keyGenerator.getKey(gr), hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME()));
                            } else {
                                hoodieRecord = DataSourceUtils.createHoodieRecord(processedRecord, keyGenerator.getKey(gr), hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME()));
                            }
                            HoodieRecord hoodieRecord2 = hoodieRecord;
                            return hoodieRecord2;
                        }, ClassTag$.MODULE$.apply(HoodieRecord.class)).toJavaRDD();
                        Schema writerDataSchema = Predef$.MODULE$.Boolean2boolean(dropPartitionColumns) ? this.generateSchemaWithoutPartitionColumns(partitionColumns, writerSchema) : writerSchema;
                        SparkRDDWriteClient client = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataSourceUtils.createHoodieClient(jsc, writerDataSchema.toString(), path, tblName, JavaConversions$.MODULE$.mapAsJavaMap(MODULE$.addSchemaEvolutionParameters((scala.collection.immutable.Map<String, String>)parameters, (scala.Option<InternalSchema>)((scala.Option)internalSchemaOpt$2.elem)).$minus((Object)HoodieWriteConfig.AUTO_COMMIT_ENABLE.key()))));
                        Object object = this.isAsyncCompactionEnabled((SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>)client, tableConfig, (scala.collection.immutable.Map<String, String>)parameters, jsc.hadoopConfiguration()) ? ((Function1)asyncCompactionTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                        Object object3 = this.isAsyncClusteringEnabled((SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>)client, (scala.collection.immutable.Map<String, String>)parameters) ? ((Function1)asyncClusteringTriggerFn.get()).apply((Object)client) : BoxedUnit.UNIT;
                        JavaRDD<HoodieRecord> hoodieRecords = Predef$.MODULE$.Boolean2boolean(hoodieConfig.getBoolean(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS())) ? DataSourceUtils.dropDuplicates(jsc, hoodieAllIncomingRecords, JavaConversions$.MODULE$.mapAsJavaMap((Map)parameters)) : hoodieAllIncomingRecords;
                        client.startCommitWithTime(instantTime, commitActionType);
                        HoodieWriteResult writeResult2 = DataSourceUtils.doWriteOperation(client, hoodieRecords, instantTime, operation);
                        tuple22 = new Tuple2((Object)writeResult2, (Object)client);
                    }
                    tuple2 = tuple22;
                    if (tuple2 == null) break block32;
                    writeResult = (HoodieWriteResult)tuple2._1();
                    writeClient = (SparkRDDWriteClient)tuple2._2();
                    if (writeClient != null) break block33;
                }
                throw new MatchError((Object)tuple2);
            }
            SparkRDDWriteClient sparkRDDWriteClient = writeClient;
            Tuple2 tuple2 = new Tuple2((Object)writeResult, (Object)sparkRDDWriteClient);
            Tuple2 tuple212 = tuple2;
            HoodieWriteResult writeResult3 = (HoodieWriteResult)tuple212._1();
            SparkRDDWriteClient writeClient2 = (SparkRDDWriteClient)tuple212._2();
            Tuple3<Object, Option<String>, Option<String>> tuple3 = this.commitAndPerformPostOperations(sqlContext.sparkSession(), df.schema(), writeResult3, (scala.collection.immutable.Map<String, String>)parameters, (SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>)writeClient2, tableConfig, jsc, new HoodieSparkSqlWriter.TableInstantInfo(basePath, instantTime, commitActionType, operation));
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            boolean writeSuccessful = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
            Option compactionInstant = (Option)tuple3._2();
            Option clusteringInstant = (Option)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)writeSuccessful), (Object)compactionInstant, (Object)clusteringInstant);
            Tuple3 tuple33 = tuple32;
            boolean writeSuccessful2 = BoxesRunTime.unboxToBoolean((Object)tuple33._1());
            Option compactionInstant2 = (Option)tuple33._2();
            Option clusteringInstant2 = (Option)tuple33._3();
            tuple6 = new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)writeSuccessful2), (Object)Option.ofNullable((Object)instantTime), (Object)compactionInstant2, (Object)clusteringInstant2, (Object)writeClient2, (Object)tableConfig);
        }
        return tuple6;
    }

    public scala.Option<HoodieTableConfig> write$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> write$default$6() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> write$default$7() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<Function1<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, BoxedUnit>> write$default$8() {
        return Option$.MODULE$.empty();
    }

    public Schema generateSchemaWithoutPartitionColumns(String partitionParam, Schema schema) {
        ArrayList fieldsToRemove = new ArrayList();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionParam.split(","))).map((Function1 & Serializable & scala.Serializable)partitionField -> partitionField.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$generateSchemaWithoutPartitionColumns$2(s))))).map((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)fieldsToRemove.add(field)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
        return HoodieAvroUtils.removeFields((Schema)schema, fieldsToRemove);
    }

    public GenericRecord getProcessedRecord(String partitionParam, GenericRecord record, boolean dropPartitionColumns) {
        GenericRecord processedRecord;
        block0: {
            processedRecord = record;
            if (!dropPartitionColumns) break block0;
            Schema writeSchema = this.generateSchemaWithoutPartitionColumns(partitionParam, record.getSchema());
            processedRecord = HoodieAvroUtils.rewriteRecord((GenericRecord)record, (Schema)writeSchema);
        }
        return processedRecord;
    }

    public scala.collection.immutable.Map<String, String> addSchemaEvolutionParameters(scala.collection.immutable.Map<String, String> parameters, scala.Option<InternalSchema> internalSchemaOpt) {
        String schemaEvolutionEnable = internalSchemaOpt.isDefined() ? "true" : "false";
        return parameters.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.INTERNAL_SCHEMA_STRING.key()), (Object)SerDeHelper.toJson((InternalSchema)((InternalSchema)internalSchemaOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.key()), (Object)schemaEvolutionEnable)})));
    }

    public scala.Option<InternalSchema> getLatestTableInternalSchema(FileSystem fs, Path basePath, SparkContext sparkContext) {
        Object object;
        block3: {
            try {
                if (FSUtils.isTableExists((String)basePath.toString(), (FileSystem)fs)) {
                    HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.builder().setConf(sparkContext.hadoopConfiguration()).setBasePath(basePath.toString()).build();
                    TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(tableMetaClient);
                    Option internalSchemaOpt = tableSchemaResolver.getTableInternalSchemaFromCommitMetadata();
                    object = internalSchemaOpt.isPresent() ? new Some(internalSchemaOpt.get()) : None$.MODULE$;
                    break block3;
                }
                object = None$.MODULE$;
            }
            catch (Exception exception) {
                object = None$.MODULE$;
            }
        }
        return object;
    }

    public scala.Option<Schema> getLatestTableSchema(FileSystem fs, Path basePath, SparkContext sparkContext) {
        None$ none$;
        if (FSUtils.isTableExists((String)basePath.toString(), (FileSystem)fs)) {
            HoodieTableMetaClient tableMetaClient = HoodieTableMetaClient.builder().setConf(sparkContext.hadoopConfiguration()).setBasePath(basePath.toString()).build();
            TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(tableMetaClient);
            none$ = HoodieConversionUtils$.MODULE$.toScalaOption(tableSchemaResolver.getTableAvroSchemaFromLatestCommit(false));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public RDD<GenericRecord> registerKryoClassesAndGetGenericRecords(String tblName, SparkContext sparkContext, Dataset<Row> df, boolean reconcileSchema) {
        String structName = new StringBuilder(7).append(tblName).append("_record").toString();
        String nameSpace = new StringBuilder(7).append("hoodie.").append(tblName).toString();
        sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
        return HoodieSparkUtils$.MODULE$.createRdd(df, structName, nameSpace, reconcileSchema, HoodieSparkUtils$.MODULE$.createRdd$default$5());
    }

    public boolean bootstrap(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> optParams, Dataset<Row> df, scala.Option<HoodieTableConfig> hoodieTableConfigOpt, scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> hoodieWriteClient) {
        boolean bl;
        Predef$.MODULE$.assert(optParams.get((Object)"path").exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$bootstrap$1(x$7))), (Function0 & Serializable & scala.Serializable)() -> "'path' must be set");
        String path = (String)optParams.apply((Object)"path");
        Path basePath = new Path(path);
        SparkContext sparkContext = sqlContext.sparkContext();
        FileSystem fs = basePath.getFileSystem(sparkContext.hadoopConfiguration());
        this.tableExists_$eq(fs.exists(new Path(basePath, ".hoodie")));
        HoodieTableConfig tableConfig = this.getHoodieTableConfig(sparkContext, path, hoodieTableConfigOpt);
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Overwrite;
        HoodieWriterUtils$.MODULE$.validateTableConfig(sqlContext.sparkSession(), optParams, (HoodieConfig)tableConfig, !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null));
        Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> tuple2 = this.mergeParamsAndGetHoodieConfig(optParams, tableConfig, mode);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        scala.collection.immutable.Map parameters = (scala.collection.immutable.Map)tuple2._1();
        HoodieConfig hoodieConfig = (HoodieConfig)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)parameters, (Object)hoodieConfig);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Map parameters2 = (scala.collection.immutable.Map)tuple23._1();
        HoodieConfig hoodieConfig2 = (HoodieConfig)tuple23._2();
        String tableName = hoodieConfig2.getStringOrThrow(HoodieWriteConfig.TBL_NAME, new StringBuilder(15).append("'").append(HoodieWriteConfig.TBL_NAME.key()).append("' must be set.").toString());
        String tableType = hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.TABLE_TYPE());
        String bootstrapBasePath = hoodieConfig2.getStringOrThrow(HoodieBootstrapConfig.BASE_PATH, new StringBuilder(32).append("'").append(HoodieBootstrapConfig.BASE_PATH.key()).append("' is required for '").append(DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()).append("'").append(" operation'").toString());
        String bootstrapIndexClass = hoodieConfig2.getStringOrDefault(HoodieBootstrapConfig.INDEX_CLASS_NAME);
        ObjectRef schema = ObjectRef.create(null);
        if (df.schema().nonEmpty()) {
            Tuple2 tuple24 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tableName);
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            String structName = (String)tuple24._1();
            String namespace = (String)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)structName, (Object)namespace);
            Tuple2 tuple26 = tuple25;
            String structName2 = (String)tuple26._1();
            String namespace2 = (String)tuple26._2();
            schema.elem = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)df.schema(), structName2, namespace2).toString();
        } else {
            schema.elem = HoodieAvroUtils.getNullSchema().toString();
        }
        SaveMode saveMode3 = mode;
        SaveMode saveMode4 = SaveMode.Ignore;
        if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && this.tableExists()) {
            this.log().warn((Object)new StringBuilder(73).append("hoodie table at ").append(basePath).append(" already exists. Ignoring & not performing actual writes.").toString());
            if (!hoodieWriteClient.isEmpty()) {
                ((BaseHoodieWriteClient)hoodieWriteClient.get()).close();
            }
            bl = false;
        } else {
            boolean metaSyncSuccess;
            BoxedUnit boxedUnit;
            this.handleSaveModes(sqlContext.sparkSession(), mode, basePath, tableConfig, tableName, WriteOperationType.BOOTSTRAP, fs);
            if (!this.tableExists()) {
                String archiveLogFolder = hoodieConfig2.getStringOrDefault(HoodieTableConfig.ARCHIVELOG_FOLDER);
                String partitionColumns = HoodieWriterUtils$.MODULE$.getPartitionColumns((scala.collection.immutable.Map<String, String>)parameters2);
                String recordKeyFields = hoodieConfig2.getString(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD());
                String keyGenProp = hoodieConfig2.getString(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME);
                boolean populateMetaFields = Boolean.parseBoolean((String)parameters2.getOrElse((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Function0 & Serializable & scala.Serializable)() -> String.valueOf(HoodieTableConfig.POPULATE_META_FIELDS.defaultValue())));
                String baseFileFormat = hoodieConfig2.getStringOrDefault(HoodieTableConfig.BASE_FILE_FORMAT);
                boolean useBaseFormatMetaFile = Boolean.parseBoolean((String)parameters2.getOrElse((Object)HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT.key(), (Function0 & Serializable & scala.Serializable)() -> String.valueOf(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT.defaultValue())));
                boxedUnit = HoodieTableMetaClient.withPropertyBuilder().setTableType(HoodieTableType.valueOf((String)tableType)).setTableName(tableName).setRecordKeyFields(recordKeyFields).setArchiveLogFolder(archiveLogFolder).setPayloadClassName(hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME())).setPreCombineField(hoodieConfig2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD(), null)).setBootstrapIndexClass(bootstrapIndexClass).setBaseFileFormat(baseFileFormat).setBootstrapBasePath(bootstrapBasePath).setPartitionFields(partitionColumns).setPopulateMetaFields(populateMetaFields).setKeyGeneratorClassProp(keyGenProp).setHiveStylePartitioningEnable(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING())).setUrlEncodePartitioning(hoodieConfig2.getBoolean(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING())).setCommitTimezone(HoodieTimelineTimeZone.valueOf((String)hoodieConfig2.getStringOrDefault(HoodieTableConfig.TIMELINE_TIMEZONE))).setPartitionMetafileUseBaseFormat(Predef$.MODULE$.boolean2Boolean(useBaseFormatMetaFile)).initTable(sparkContext.hadoopConfiguration(), path);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            JavaSparkContext jsc = new JavaSparkContext(sqlContext.sparkContext());
            try (SparkRDDWriteClient writeClient = (SparkRDDWriteClient)hoodieWriteClient.getOrElse((Function0 & Serializable & scala.Serializable)() -> DataSourceUtils.createHoodieClient(jsc, (String)schema$1.elem, path, tableName, JavaConversions$.MODULE$.mapAsJavaMap((Map)parameters2)));){
                writeClient.bootstrap(Option.empty());
            }
            bl = metaSyncSuccess = this.metaSync(sqlContext.sparkSession(), hoodieConfig2, basePath, df.schema());
        }
        return bl;
    }

    public scala.Option<HoodieTableConfig> bootstrap$default$5() {
        return Option$.MODULE$.empty();
    }

    public scala.Option<SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>> bootstrap$default$6() {
        return Option$.MODULE$.empty();
    }

    public void validateSchemaForHoodieIsDeleted(Schema schema) {
        if (schema.getField("_hoodie_is_deleted") != null) {
            Schema.Type type = ((Schema)AvroConversionUtils$.MODULE$.resolveAvroTypeNullability(schema.getField("_hoodie_is_deleted").schema())._2()).getType();
            Schema.Type type2 = Schema.Type.BOOLEAN;
            if (type == null ? type2 != null : !type.equals(type2)) {
                throw new HoodieException(new StringBuilder(81).append("_hoodie_is_deleted has to be BOOLEAN type. Passed in dataframe's schema has type ").append(schema.getField("_hoodie_is_deleted").schema().getType()).toString());
            }
        }
    }

    public Tuple2<Object, Option<String>> bulkInsertAsRow(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> df, String tblName, Path basePath, String path, String instantTime, String partitionColumns) {
        Option<BulkInsertPartitioner<Dataset<Row>>> userDefinedBulkInsertPartitionerOpt;
        SparkContext sparkContext = sqlContext.sparkContext();
        boolean populateMetaFields = Boolean.parseBoolean((String)parameters.getOrElse((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), (Function0 & Serializable & scala.Serializable)() -> String.valueOf(HoodieTableConfig.POPULATE_META_FIELDS.defaultValue())));
        boolean dropPartitionColumns = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS().key()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$bulkInsertAsRow$2(x$10))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS().defaultValue())));
        Tuple2 tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(tblName);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String structName = (String)tuple2._1();
        String nameSpace = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)structName, (Object)nameSpace);
        Tuple2 tuple23 = tuple22;
        String structName2 = (String)tuple23._1();
        String nameSpace2 = (String)tuple23._2();
        sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
        Schema schema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)df.schema(), structName2, nameSpace2);
        if (dropPartitionColumns) {
            schema = this.generateSchemaWithoutPartitionColumns(partitionColumns, schema);
        }
        this.validateSchemaForHoodieIsDeleted(schema);
        sparkContext.getConf().registerAvroSchemas((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{schema}));
        this.log().info((Object)new StringBuilder(25).append("Registered avro schema : ").append(schema.toString(true)).toString());
        if (new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key()))).toBoolean()) {
            throw new HoodieException("Dropping duplicates with bulk_insert in row writer path is not supported yet");
        }
        scala.collection.mutable.Map params = (scala.collection.mutable.Map)Map$.MODULE$.apply(parameters.toSeq());
        params.update((Object)HoodieWriteConfig.AVRO_SCHEMA_STRING.key(), (Object)schema.toString());
        HoodieWriteConfig writeConfig = DataSourceUtils.createHoodieConfig(schema.toString(), path, tblName, JavaConversions$.MODULE$.mapAsJavaMap((Map)params));
        NonSortPartitionerWithRows bulkInsertPartitionerRows = populateMetaFields ? ((userDefinedBulkInsertPartitionerOpt = DataSourceUtils.createUserDefinedBulkInsertPartitionerWithRows(writeConfig)).isPresent() ? (BulkInsertPartitioner)userDefinedBulkInsertPartitionerOpt.get() : BulkInsertInternalPartitionerWithRowsFactory.get((BulkInsertSortMode)writeConfig.getBulkInsertSortMode())) : new NonSortPartitionerWithRows();
        boolean arePartitionRecordsSorted = bulkInsertPartitionerRows.arePartitionRecordsSorted();
        params.update((Object)"hoodie.bulkinsert.are.partitioner.records.sorted", (Object)((Object)BoxesRunTime.boxToBoolean((boolean)arePartitionRecordsSorted)).toString());
        boolean isGlobalIndex = populateMetaFields ? SparkHoodieIndexFactory.isGlobalIndex((HoodieWriteConfig)writeConfig) : false;
        Dataset<Row> hoodieDF = HoodieDatasetBulkInsertHelper$.MODULE$.prepareForBulkInsert(df, writeConfig, (BulkInsertPartitioner<Dataset<Row>>)bulkInsertPartitionerRows, dropPartitionColumns);
        if (HoodieSparkUtils$.MODULE$.isSpark2()) {
            hoodieDF.write().format("org.apache.hudi.internal").option("hoodie.instant.time", instantTime).options((Map)params).mode(SaveMode.Append).save();
        } else if (HoodieSparkUtils$.MODULE$.isSpark3()) {
            hoodieDF.write().format("org.apache.hudi.spark3.internal").option("hoodie.instant.time", instantTime).option(HoodieInternalConfig.BULKINSERT_INPUT_DATA_SCHEMA_DDL.key(), hoodieDF.schema().toDDL()).options((Map)params).mode(SaveMode.Append).save();
        } else {
            throw new HoodieException("Bulk insert using row writer is not supported with current Spark version. To use row writer please switch to spark 2 or spark 3");
        }
        boolean syncHiveSuccess = this.metaSync(sqlContext.sparkSession(), (HoodieConfig)writeConfig, basePath, df.schema());
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)syncHiveSuccess), (Object)Option.ofNullable((Object)instantTime));
    }

    private void handleSaveModes(SparkSession spark, SaveMode mode, Path tablePath, HoodieTableConfig tableConfig, String tableName, WriteOperationType operation, FileSystem fs) {
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.Append;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && this.tableExists()) {
            String existingTableName = tableConfig.getTableName();
            Function2 resolver = spark.sessionState().conf().resolver();
            if (!BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)existingTableName, (Object)tableName))) {
                throw new HoodieException(new StringBuilder(96).append("hoodie table with name ").append(existingTableName).append(" already exists at ").append(tablePath).append(",").append(" can not append data to the table with another name ").append(tableName).append(".").toString());
            }
        }
        WriteOperationType writeOperationType = operation;
        WriteOperationType writeOperationType2 = WriteOperationType.DELETE;
        if (writeOperationType == null ? writeOperationType2 != null : !writeOperationType.equals(writeOperationType2)) {
            SaveMode saveMode3 = mode;
            SaveMode saveMode4 = SaveMode.ErrorIfExists;
            if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && this.tableExists()) {
                throw new HoodieException(new StringBuilder(32).append("hoodie table at ").append(tablePath).append(" already exists.").toString());
            }
            SaveMode saveMode5 = mode;
            SaveMode saveMode6 = SaveMode.Overwrite;
            if (!(saveMode5 != null ? !saveMode5.equals(saveMode6) : saveMode6 != null) && this.tableExists()) {
                WriteOperationType writeOperationType3 = operation;
                WriteOperationType writeOperationType4 = WriteOperationType.INSERT_OVERWRITE_TABLE;
                if (writeOperationType3 == null ? writeOperationType4 != null : !writeOperationType3.equals(writeOperationType4)) {
                    this.log().warn((Object)new StringBuilder(84).append("hoodie table at ").append(tablePath).append(" already exists. Deleting existing data & overwriting with new data.").toString());
                    fs.delete(tablePath, true);
                    this.tableExists_$eq(false);
                }
            }
        } else {
            SaveMode saveMode7 = mode;
            SaveMode saveMode8 = SaveMode.Append;
            if (saveMode7 == null ? saveMode8 != null : !saveMode7.equals(saveMode8)) {
                throw new HoodieException(new StringBuilder(54).append("Append is the only save mode applicable for ").append(operation.toString()).append(" operation").toString());
            }
        }
    }

    private boolean metaSync(SparkSession spark, HoodieConfig hoodieConfig, Path basePath, StructType schema) {
        block3: {
            BoxedUnit boxedUnit;
            boolean hiveSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(HiveSyncConfigHolder.HIVE_SYNC_ENABLED))).toBoolean();
            boolean metaSyncEnabled = new StringOps(Predef$.MODULE$.augmentString(hoodieConfig.getStringOrDefault(HoodieSyncConfig.META_SYNC_ENABLED))).toBoolean();
            ObjectRef syncClientToolClassSet = ObjectRef.create((Object)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hoodieConfig.getString(DataSourceWriteOptions$.MODULE$.META_SYNC_CLIENT_TOOL_CLASS_NAME()).split(","))).foreach((Function1 & Serializable & scala.Serializable)syncClass -> (Set)((Set)syncClientToolClassSet$1.elem).$plus$eq(syncClass));
            if (hiveSyncEnabled) {
                metaSyncEnabled = true;
                boxedUnit = ((Set)syncClientToolClassSet.elem).$plus$eq((Object)HiveSyncTool.class.getName());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (metaSyncEnabled) {
                FileSystem fs = basePath.getFileSystem(spark.sessionState().newHadoopConf());
                String baseFileFormat = hoodieConfig.getStringOrDefault(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT);
                TypedProperties properties = new TypedProperties();
                properties.putAll((java.util.Map)hoodieConfig.getProps());
                properties.put((Object)HiveSyncConfigHolder.HIVE_SYNC_SCHEMA_STRING_LENGTH_THRESHOLD.key(), (Object)spark.sessionState().conf().getConf(StaticSQLConf$.MODULE$.SCHEMA_STRING_LENGTH_THRESHOLD()).toString());
                properties.put((Object)HoodieSyncConfig.META_SYNC_SPARK_VERSION.key(), (Object)package$.MODULE$.SPARK_VERSION());
                properties.put((Object)HoodieSyncConfig.META_SYNC_USE_FILE_LISTING_FROM_METADATA.key(), (Object)hoodieConfig.getBoolean(HoodieMetadataConfig.ENABLE));
                ((Set)syncClientToolClassSet.elem).foreach((Function1 & Serializable & scala.Serializable)impl -> {
                    HoodieSparkSqlWriter$.$anonfun$metaSync$2(properties, fs, basePath, baseFileFormat, impl);
                    return BoxedUnit.UNIT;
                });
            }
            if (!metaSyncEnabled) break block3;
            this.getHiveTableNames(hoodieConfig).foreach((Function1 & Serializable & scala.Serializable)name -> {
                HoodieSparkSqlWriter$.$anonfun$metaSync$3(hoodieConfig, spark, name);
                return BoxedUnit.UNIT;
            });
        }
        return true;
    }

    private List<String> getHiveTableNames(HoodieConfig hoodieConfig) {
        .colon.colon colon2;
        String tableName = hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_TABLE());
        String tableType = hoodieConfig.getStringOrDefault(DataSourceWriteOptions$.MODULE$.TABLE_TYPE());
        if (tableType.equals(DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL())) {
            colon2 = new .colon.colon((Object)tableName, (List)Nil$.MODULE$);
        } else {
            String roSuffix = hoodieConfig.getBooleanOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_SKIP_RO_SUFFIX_FOR_READ_OPTIMIZED_TABLE()) ? "" : "_ro";
            colon2 = new .colon.colon((Object)new StringBuilder(0).append(tableName).append(roSuffix).toString(), (List)new .colon.colon((Object)new StringBuilder(3).append(tableName).append("_rt").toString(), (List)Nil$.MODULE$));
        }
        return colon2;
    }

    private Tuple3<Object, Option<String>, Option<String>> commitAndPerformPostOperations(SparkSession spark, StructType schema, HoodieWriteResult writeResult, scala.collection.immutable.Map<String, String> parameters, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>> client, HoodieTableConfig tableConfig, JavaSparkContext jsc, HoodieSparkSqlWriter.TableInstantInfo tableInstantInfo) {
        Tuple3 tuple3;
        if (writeResult.getWriteStatuses().rdd().filter((Function1 & Serializable & scala.Serializable)ws -> BoxesRunTime.boxToBoolean((boolean)ws.hasErrors())).count() == 0L) {
            this.log().info((Object)"Proceeding to commit the write.");
            scala.collection.immutable.Map metaMap = (scala.collection.immutable.Map)parameters.filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$commitAndPerformPostOperations$2(parameters, kv)));
            boolean commitSuccess = client.commit(tableInstantInfo.instantTime(), writeResult.getWriteStatuses(), Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap))), tableInstantInfo.commitActionType(), writeResult.getPartitionToReplaceFileIds());
            if (commitSuccess) {
                this.log().info((Object)new StringBuilder(19).append("Commit ").append(tableInstantInfo.instantTime()).append(" successful!").toString());
            } else {
                this.log().info((Object)new StringBuilder(15).append("Commit ").append(tableInstantInfo.instantTime()).append(" failed!").toString());
            }
            boolean asyncCompactionEnabled = this.isAsyncCompactionEnabled(client, tableConfig, parameters, jsc.hadoopConfiguration());
            Option compactionInstant = asyncCompactionEnabled ? client.scheduleCompaction(Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap)))) : Option.empty();
            this.log().info((Object)new StringBuilder(24).append("Compaction Scheduled is ").append(compactionInstant).toString());
            boolean asyncClusteringEnabled = this.isAsyncClusteringEnabled(client, parameters);
            Option clusteringInstant = asyncClusteringEnabled ? client.scheduleClustering(Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap)))) : Option.empty();
            this.log().info((Object)new StringBuilder(24).append("Clustering Scheduled is ").append(clusteringInstant).toString());
            boolean metaSyncSuccess = this.metaSync(spark, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig(parameters), tableInstantInfo.basePath(), schema);
            this.log().info((Object)new StringBuilder(30).append("Is Async Compaction Enabled ? ").append(asyncCompactionEnabled).toString());
            if (!asyncCompactionEnabled && !asyncClusteringEnabled) {
                client.close();
            }
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((commitSuccess && metaSyncSuccess ? 1 : 0) != 0), (Object)compactionInstant, (Object)clusteringInstant);
        } else {
            this.log().error((Object)new StringBuilder(19).append(tableInstantInfo.operation()).append(" failed with errors").toString());
            if (this.log().isTraceEnabled()) {
                this.log().trace((Object)"Printing out the top 100 errors");
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])writeResult.getWriteStatuses().rdd().filter((Function1 & Serializable & scala.Serializable)ws -> BoxesRunTime.boxToBoolean((boolean)ws.hasErrors())).take(100))).foreach((Function1 & Serializable & scala.Serializable)ws -> {
                    HoodieSparkSqlWriter$.$anonfun$commitAndPerformPostOperations$4(ws);
                    return BoxedUnit.UNIT;
                });
            }
            tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Option.empty(), (Object)Option.empty());
        }
        return tuple3;
    }

    private boolean isAsyncCompactionEnabled(SparkRDDWriteClient<HoodieRecordPayload<Nothing$>> client, HoodieTableConfig tableConfig, scala.collection.immutable.Map<String, String> parameters, Configuration configuration) {
        boolean bl;
        this.log().info((Object)new StringBuilder(33).append("Config.inlineCompactionEnabled ? ").append(client.getConfig().inlineCompactionEnabled()).toString());
        if (this.asyncCompactionTriggerFnDefined() && !client.getConfig().inlineCompactionEnabled() && parameters.get((Object)DataSourceWriteOptions$.MODULE$.ASYNC_COMPACT_ENABLE().key()).exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlWriter$.$anonfun$isAsyncCompactionEnabled$1(r)))) {
            HoodieTableType hoodieTableType = tableConfig.getTableType();
            HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
            bl = !(hoodieTableType != null ? !hoodieTableType.equals(hoodieTableType2) : hoodieTableType2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean isAsyncClusteringEnabled(SparkRDDWriteClient<HoodieRecordPayload<Nothing$>> client, scala.collection.immutable.Map<String, String> parameters) {
        this.log().info((Object)new StringBuilder(32).append("Config.asyncClusteringEnabled ? ").append(client.getConfig().isAsyncClusteringEnabled()).toString());
        return this.asyncClusteringTriggerFnDefined() && client.getConfig().isAsyncClusteringEnabled();
    }

    private HoodieTableConfig getHoodieTableConfig(SparkContext sparkContext, String tablePath, scala.Option<HoodieTableConfig> hoodieTableConfigOpt) {
        return this.tableExists() ? (HoodieTableConfig)hoodieTableConfigOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> HoodieTableMetaClient.builder().setConf(sparkContext.hadoopConfiguration()).setBasePath(tablePath).build().getTableConfig()) : null;
    }

    private Tuple2<scala.collection.immutable.Map<String, String>, HoodieConfig> mergeParamsAndGetHoodieConfig(scala.collection.immutable.Map<String, String> optParams, HoodieTableConfig tableConfig, SaveMode mode) {
        scala.collection.immutable.Map<String, String> translatedOptions = DataSourceWriteOptions$.MODULE$.translateSqlOptions(optParams);
        scala.collection.mutable.Map mergedParams = Map$.MODULE$.empty().$plus$plus(HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(translatedOptions));
        if (!mergedParams.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key()) && mergedParams.contains((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key())) {
            mergedParams.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), mergedParams.apply((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key()));
        }
        if (tableConfig != null) {
            SaveMode saveMode = mode;
            SaveMode saveMode2 = SaveMode.Overwrite;
            if (saveMode == null ? saveMode2 != null : !saveMode.equals(saveMode2)) {
                JavaConversions$.MODULE$.deprecated$u0020propertiesAsScalaMap((Properties)tableConfig.getProps()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    HoodieSparkSqlWriter$.$anonfun$mergeParamsAndGetHoodieConfig$1(mergedParams, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
        }
        Object object = mergedParams.contains((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()) ? mergedParams.put((Object)"hoodie.payload.ordering.field", mergedParams.apply((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key())) : BoxedUnit.UNIT;
        scala.collection.immutable.Map params = mergedParams.toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)params, (Object)HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)params));
    }

    private scala.collection.immutable.Map<String, String> extractConfigsRelatedToTimestampBasedKeyGenerator(String keyGenerator, scala.collection.immutable.Map<String, String> params) {
        return keyGenerator.equals(TimestampBasedKeyGenerator.class.getCanonicalName()) || keyGenerator.equals(TimestampBasedAvroKeyGenerator.class.getCanonicalName()) ? params.filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieTableConfig.PERSISTED_CONFIG_LIST.contains(x$1))) : Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ boolean $anonfun$write$1(String x$1) {
        return !StringUtils.isNullOrEmpty((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$generateSchemaWithoutPartitionColumns$2(String s) {
        return !s.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$bootstrap$1(String x$7) {
        return !StringUtils.isNullOrEmpty((String)x$7);
    }

    public static final /* synthetic */ boolean $anonfun$bulkInsertAsRow$2(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toBoolean();
    }

    public static final /* synthetic */ void $anonfun$metaSync$2(TypedProperties properties$1, FileSystem fs$1, Path basePath$1, String baseFileFormat$1, String impl) {
        SyncUtilHelpers.runHoodieMetaSync((String)impl.trim(), (TypedProperties)properties$1, (Configuration)fs$1.getConf(), (FileSystem)fs$1, (String)basePath$1.toString(), (String)baseFileFormat$1);
    }

    public static final /* synthetic */ void $anonfun$metaSync$3(HoodieConfig hoodieConfig$2, SparkSession spark$1, String name) {
        block0: {
            String qualifiedTableName = String.join((CharSequence)".", hoodieConfig$2.getStringOrDefault(DataSourceWriteOptions$.MODULE$.HIVE_DATABASE()), name);
            if (!spark$1.catalog().tableExists(qualifiedTableName)) break block0;
            spark$1.catalog().refreshTable(qualifiedTableName);
        }
    }

    public static final /* synthetic */ boolean $anonfun$commitAndPerformPostOperations$2(scala.collection.immutable.Map parameters$3, Tuple2 kv) {
        return ((String)kv._1()).startsWith((String)parameters$3.apply((Object)DataSourceWriteOptions$.MODULE$.COMMIT_METADATA_KEYPREFIX().key()));
    }

    public static final /* synthetic */ void $anonfun$commitAndPerformPostOperations$5(Tuple2 kt) {
        MODULE$.log().trace((Object)new StringBuilder(15).append("Error for key: ").append(kt._1()).toString(), (Throwable)kt._2());
    }

    public static final /* synthetic */ void $anonfun$commitAndPerformPostOperations$4(WriteStatus ws) {
        block0: {
            MODULE$.log().trace((Object)"Global error :", ws.getGlobalError());
            if (ws.getErrors().size() <= 0) break block0;
            JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap((java.util.Map)ws.getErrors()).foreach((Function1 & Serializable & scala.Serializable)kt -> {
                HoodieSparkSqlWriter$.$anonfun$commitAndPerformPostOperations$5(kt);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$isAsyncCompactionEnabled$1(String r) {
        return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
    }

    public static final /* synthetic */ void $anonfun$mergeParamsAndGetHoodieConfig$1(scala.collection.mutable.Map mergedParams$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        mergedParams$1.update((Object)key, (Object)value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private HoodieSparkSqlWriter$() {
        MODULE$ = this;
        this.log = LogManager.getLogger(this.getClass());
        this.tableExists = false;
        this.asyncCompactionTriggerFnDefined = false;
        this.asyncClusteringTriggerFnDefined = false;
    }
}

