/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.net.URI;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultRedirectStrategy {
    @Test
    public void testIsRedirectable() {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        Assert.assertTrue((boolean)redirectStrategy.isRedirectable("GET"));
        Assert.assertTrue((boolean)redirectStrategy.isRedirectable("HEAD"));
        Assert.assertFalse((boolean)redirectStrategy.isRedirectable("PUT"));
        Assert.assertFalse((boolean)redirectStrategy.isRedirectable("POST"));
        Assert.assertFalse((boolean)redirectStrategy.isRedirectable("DELETE"));
    }

    @Test
    public void testIsRedirectedMovedTemporary() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response.addHeader("Location", "http://localhost/stuff");
        Assert.assertTrue((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        HttpPost httppost = new HttpPost("http://localhost/");
        Assert.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httppost, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedMovedTemporaryNoLocation() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        Assert.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedMovedPermanently() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 301, "Redirect");
        Assert.assertTrue((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        HttpPost httppost = new HttpPost("http://localhost/");
        Assert.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httppost, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedTemporaryRedirect() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 307, "Redirect");
        Assert.assertTrue((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        HttpPost httppost = new HttpPost("http://localhost/");
        Assert.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httppost, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedSeeOther() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 303, "Redirect");
        Assert.assertTrue((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        HttpPost httppost = new HttpPost("http://localhost/");
        Assert.assertTrue((boolean)redirectStrategy.isRedirected((HttpRequest)httppost, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedUnknownStatus() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 333, "Redirect");
        Assert.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        HttpPost httppost = new HttpPost("http://localhost/");
        Assert.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httppost, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedInvalidInput() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 303, "Redirect");
        try {
            redirectStrategy.isRedirected(null, (HttpResponse)response, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            redirectStrategy.isRedirected((HttpRequest)httpget, null, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    @Test
    public void testGetLocationUri() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response.addHeader("Location", "http://localhost/stuff");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)URI.create("http://localhost/stuff"), (Object)uri);
    }

    @Test(expected=ProtocolException.class)
    public void testGetLocationUriMissingHeader() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
    }

    @Test(expected=ProtocolException.class)
    public void testGetLocationUriInvalidLocation() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response.addHeader("Location", "http://localhost/not valid");
        redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
    }

    @Test
    public void testGetLocationUriRelative() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.target_host", (Object)new HttpHost("localhost"));
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response.addHeader("Location", "/stuff");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)URI.create("http://localhost/stuff"), (Object)uri);
    }

    @Test(expected=IllegalStateException.class)
    public void testGetLocationUriRelativeMissingTargetHost() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response.addHeader("Location", "/stuff");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)URI.create("http://localhost/stuff"), (Object)uri);
    }

    @Test
    public void testGetLocationUriRelativeWithFragment() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.target_host", (Object)new HttpHost("localhost"));
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response.addHeader("Location", "/stuff#fragment");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)URI.create("http://localhost/stuff#fragment"), (Object)uri);
    }

    @Test
    public void testGetLocationUriAbsoluteWithFragment() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.target_host", (Object)new HttpHost("localhost"));
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response.addHeader("Location", "http://localhost/stuff#fragment");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)URI.create("http://localhost/stuff#fragment"), (Object)uri);
    }

    @Test
    public void testGetLocationUriNormalized() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.target_host", (Object)new HttpHost("localhost"));
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response.addHeader("Location", "http://localhost/././stuff/../morestuff");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((Object)URI.create("http://localhost/morestuff"), (Object)uri);
    }

    @Test(expected=ProtocolException.class)
    public void testGetLocationUriRelativeLocationNotAllowed() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.target_host", (Object)new HttpHost("localhost"));
        RequestConfig config = RequestConfig.custom().setRelativeRedirectsAllowed(false).build();
        context.setRequestConfig(config);
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response.addHeader("Location", "/stuff");
        redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
    }

    @Test
    public void testGetLocationUriAllowCircularRedirects() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.target_host", (Object)new HttpHost("localhost"));
        RequestConfig config = RequestConfig.custom().setCircularRedirectsAllowed(true).build();
        context.setRequestConfig(config);
        URI uri1 = URI.create("http://localhost/stuff1");
        URI uri2 = URI.create("http://localhost/stuff2");
        URI uri3 = URI.create("http://localhost/stuff3");
        HttpGet httpget1 = new HttpGet("http://localhost/");
        BasicHttpResponse response1 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response1.addHeader("Location", uri1.toASCIIString());
        HttpGet httpget2 = new HttpGet(uri1.toASCIIString());
        BasicHttpResponse response2 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response2.addHeader("Location", uri2.toASCIIString());
        HttpGet httpget3 = new HttpGet(uri2.toASCIIString());
        BasicHttpResponse response3 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response3.addHeader("Location", uri3.toASCIIString());
        Assert.assertEquals((Object)uri1, (Object)redirectStrategy.getLocationURI((HttpRequest)httpget1, (HttpResponse)response1, (HttpContext)context));
        Assert.assertEquals((Object)uri2, (Object)redirectStrategy.getLocationURI((HttpRequest)httpget2, (HttpResponse)response2, (HttpContext)context));
        Assert.assertEquals((Object)uri3, (Object)redirectStrategy.getLocationURI((HttpRequest)httpget3, (HttpResponse)response3, (HttpContext)context));
        List uris = context.getRedirectLocations();
        Assert.assertNotNull((Object)uris);
        Assert.assertTrue((boolean)uris.contains(uri1));
        Assert.assertTrue((boolean)uris.contains(uri2));
        Assert.assertTrue((boolean)uris.contains(uri3));
        Assert.assertEquals((long)3L, (long)uris.size());
        Assert.assertEquals((Object)uri1, uris.get(0));
        Assert.assertEquals((Object)uri2, uris.get(1));
        Assert.assertEquals((Object)uri3, uris.get(2));
    }

    @Test(expected=ProtocolException.class)
    public void testGetLocationUriDisallowCircularRedirects() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.target_host", (Object)new HttpHost("localhost"));
        HttpGet httpget = new HttpGet("http://localhost/stuff");
        RequestConfig config = RequestConfig.custom().setCircularRedirectsAllowed(false).build();
        context.setRequestConfig(config);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response.addHeader("Location", "http://localhost/stuff");
        URI uri = URI.create("http://localhost/stuff");
        Assert.assertEquals((Object)uri, (Object)redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
    }

    @Test
    public void testGetLocationUriInvalidInput() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, "Redirect");
        response.addHeader("Location", "http://localhost/stuff");
        try {
            redirectStrategy.getLocationURI(null, (HttpResponse)response, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            redirectStrategy.getLocationURI((HttpRequest)httpget, null, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
    }

    @Test
    public void testGetRedirectRequest() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 303, "Redirect");
        response.addHeader("Location", "http://localhost/stuff");
        BasicHttpContext context1 = new BasicHttpContext();
        HttpUriRequest redirect1 = redirectStrategy.getRedirect((HttpRequest)new HttpGet("http://localhost/"), (HttpResponse)response, (HttpContext)context1);
        Assert.assertEquals((Object)"GET", (Object)redirect1.getMethod());
        BasicHttpContext context2 = new BasicHttpContext();
        HttpUriRequest redirect2 = redirectStrategy.getRedirect((HttpRequest)new HttpPost("http://localhost/"), (HttpResponse)response, (HttpContext)context2);
        Assert.assertEquals((Object)"GET", (Object)redirect2.getMethod());
        BasicHttpContext context3 = new BasicHttpContext();
        HttpUriRequest redirect3 = redirectStrategy.getRedirect((HttpRequest)new HttpHead("http://localhost/"), (HttpResponse)response, (HttpContext)context3);
        Assert.assertEquals((Object)"HEAD", (Object)redirect3.getMethod());
    }

    @Test
    public void testGetRedirectRequestForTemporaryRedirect() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 307, "Temporary Redirect");
        response.addHeader("Location", "http://localhost/stuff");
        BasicHttpContext context1 = new BasicHttpContext();
        HttpUriRequest redirect1 = redirectStrategy.getRedirect((HttpRequest)new HttpTrace("http://localhost/"), (HttpResponse)response, (HttpContext)context1);
        Assert.assertEquals((Object)"TRACE", (Object)redirect1.getMethod());
        BasicHttpContext context2 = new BasicHttpContext();
        HttpPost httppost = new HttpPost("http://localhost/");
        BasicHttpEntity entity = new BasicHttpEntity();
        httppost.setEntity((HttpEntity)entity);
        HttpUriRequest redirect2 = redirectStrategy.getRedirect((HttpRequest)httppost, (HttpResponse)response, (HttpContext)context2);
        Assert.assertEquals((Object)"POST", (Object)redirect2.getMethod());
        Assert.assertTrue((boolean)(redirect2 instanceof HttpEntityEnclosingRequest));
        Assert.assertSame((Object)entity, (Object)((HttpEntityEnclosingRequest)redirect2).getEntity());
    }

    @Test(expected=ProtocolException.class)
    public void testCreateLocationURIInvalid() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        redirectStrategy.createLocationURI(":::::::");
    }

    @Test
    public void testWithoutNormalize() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 307, "Temporary Redirect");
        response.addHeader("Location", "http://somewhere.com//foo");
        HttpClientContext context1 = new HttpClientContext((HttpContext)new BasicHttpContext());
        context1.setRequestConfig(RequestConfig.custom().setNormalizeUri(false).build());
        Assert.assertEquals((Object)"http://somewhere.com//foo", (Object)redirectStrategy.getRedirect((HttpRequest)new HttpGet("http://localhost/stuff"), (HttpResponse)response, (HttpContext)context1).getURI().toASCIIString());
    }
}

