/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.SSLServerSetupHandler;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.localserver.SSLTestContexts;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestSSLSocketFactory {
    private HttpServer server;

    @After
    public void shutDown() throws Exception {
        if (this.server != null) {
            this.server.shutdown(10L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicSSL() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        TestX509HostnameVerifier hostVerifier = new TestX509HostnameVerifier();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext(), (HostnameVerifier)hostVerifier);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        try {
            SSLSession sslsession = sslSocket.getSession();
            Assert.assertNotNull((Object)sslsession);
            Assert.assertTrue((boolean)hostVerifier.isFired());
        }
        finally {
            sslSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicDefaultHostnameVerifier() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext(), SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        try {
            SSLSession sslsession = sslSocket.getSession();
            Assert.assertNotNull((Object)sslsession);
        }
        finally {
            sslSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientAuthSSL() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        TestX509HostnameVerifier hostVerifier = new TestX509HostnameVerifier();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext(), (HostnameVerifier)hostVerifier);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        try {
            SSLSession sslsession = sslSocket.getSession();
            Assert.assertNotNull((Object)sslsession);
            Assert.assertTrue((boolean)hostVerifier.isFired());
        }
        finally {
            sslSocket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testClientAuthSSLFailure() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).setSslSetupHandler(new SSLServerSetupHandler(){

            public void initialize(SSLServerSocket socket) throws SSLException {
                socket.setNeedClientAuth(true);
            }
        }).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        TestX509HostnameVerifier hostVerifier = new TestX509HostnameVerifier();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext(), (HostnameVerifier)hostVerifier);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        try {
            InputStream inputStream = sslSocket.getInputStream();
            Assert.assertEquals((long)-1L, (long)inputStream.read());
            SSLSession sslsession = sslSocket.getSession();
            Assert.assertNotNull((Object)sslsession);
            Assert.assertTrue((boolean)hostVerifier.isFired());
        }
        finally {
            sslSocket.close();
        }
    }

    @Test(expected=SSLException.class)
    public void testSSLTrustVerification() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        SSLContext defaultsslcontext = SSLContexts.createDefault();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(defaultsslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        sslSocket.close();
    }

    @Test
    public void testSSLTrustVerificationOverrideWithCustsom() throws Exception {
        TrustStrategy trustStrategy = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return chain.length == 1;
            }
        };
        this.testSSLTrustVerificationOverride(trustStrategy);
    }

    @Test
    public void testSSLTrustVerificationOverrideWithTrustSelfSignedStrategy() throws Exception {
        this.testSSLTrustVerificationOverride((TrustStrategy)TrustSelfSignedStrategy.INSTANCE);
    }

    @Test
    public void testSSLTrustVerificationOverrideWithTrustAllStrategy() throws Exception {
        this.testSSLTrustVerificationOverride((TrustStrategy)TrustAllStrategy.INSTANCE);
    }

    private void testSSLTrustVerificationOverride(TrustStrategy trustStrategy) throws Exception, IOException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)trustStrategy).build();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        sslSocket.close();
    }

    @Test
    public void testTLSOnly() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).setSslSetupHandler(new SSLServerSetupHandler(){

            public void initialize(SSLServerSocket socket) throws SSLException {
                socket.setEnabledProtocols(new String[]{"TLSv1"});
            }
        }).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext());
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        SSLSocket sslSocket = (SSLSocket)socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        SSLSession sslsession = sslSocket.getSession();
        Assert.assertNotNull((Object)sslsession);
    }

    @Test(expected=IOException.class)
    public void testSSLDisabledByDefault() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).setSslSetupHandler(new SSLServerSetupHandler(){

            public void initialize(SSLServerSocket socket) throws SSLException {
                socket.setEnabledProtocols(new String[]{"SSLv3"});
            }
        }).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext());
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSLTimeout() throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext());
        Socket socket = socketFactory.createSocket((HttpContext)context);
        InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
        HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
        Socket sslSocket = socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        InputStream inputStream = sslSocket.getInputStream();
        try {
            sslSocket.setSoTimeout(1);
            inputStream.read();
            Assert.fail((String)"SocketTimeoutException expected");
        }
        catch (SocketTimeoutException ex) {
            Assert.assertThat((Object)sslSocket.isClosed(), (Matcher)CoreMatchers.equalTo((Object)false));
            Assert.assertThat((Object)socket.isClosed(), (Matcher)CoreMatchers.equalTo((Object)false));
        }
        finally {
            inputStream.close();
        }
    }

    @Test
    public void testStrongCipherSuites() {
        String[] strongCipherSuites;
        for (String cipherSuite : strongCipherSuites = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384"}) {
            Assert.assertFalse((boolean)SSLConnectionSocketFactory.isWeakCipherSuite((String)cipherSuite));
        }
    }

    @Test
    public void testWeakCiphersDisabledByDefault() {
        String[] weakCiphersSuites;
        for (String cipherSuite : weakCiphersSuites = new String[]{"SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_DH_anon_WITH_AES_256_GCM_SHA384", "TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_NULL_SHA256", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5"}) {
            Assert.assertTrue((boolean)SSLConnectionSocketFactory.isWeakCipherSuite((String)cipherSuite));
            try {
                this.testWeakCipherDisabledByDefault(cipherSuite);
                Assert.fail((String)"IOException expected");
            }
            catch (Exception e) {
                Assert.assertTrue((e instanceof IOException || e instanceof IllegalArgumentException ? 1 : 0) != 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWeakCipherDisabledByDefault(final String cipherSuite) throws Exception {
        this.server = ServerBootstrap.bootstrap().setServerInfo("TEST/1.1").setSslContext(SSLTestContexts.createServerSSLContext()).setSslSetupHandler(new SSLServerSetupHandler(){

            public void initialize(SSLServerSocket socket) {
                socket.setEnabledCipherSuites(new String[]{cipherSuite});
            }
        }).create();
        this.server.start();
        BasicHttpContext context = new BasicHttpContext();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(SSLTestContexts.createClientSSLContext());
        Socket socket = socketFactory.createSocket((HttpContext)context);
        try {
            InetSocketAddress remoteAddress = new InetSocketAddress("localhost", this.server.getLocalPort());
            HttpHost target = new HttpHost("localhost", this.server.getLocalPort(), "https");
            socketFactory.connectSocket(0, socket, target, remoteAddress, null, (HttpContext)context);
        }
        finally {
            socket.close();
        }
    }

    static class TestX509HostnameVerifier
    implements HostnameVerifier {
        private boolean fired = false;

        TestX509HostnameVerifier() {
        }

        @Override
        public boolean verify(String host, SSLSession session) {
            this.fired = true;
            return true;
        }

        public boolean isFired() {
            return this.fired;
        }
    }
}

