/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHttpClientUtils {
    @Test
    public void testCloseQuietlyResponseNull() throws Exception {
        HttpResponse response = null;
        HttpClientUtils.closeQuietly(response);
    }

    @Test
    public void testCloseQuietlyResponseEntityNull() throws Exception {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        HttpClientUtils.closeQuietly((HttpResponse)response);
        ((HttpResponse)Mockito.verify((Object)response)).getEntity();
    }

    @Test
    public void testCloseQuietlyResponseEntityNonStreaming() throws Exception {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        Mockito.when((Object)entity.isStreaming()).thenReturn((Object)Boolean.FALSE);
        HttpClientUtils.closeQuietly((HttpResponse)response);
        ((HttpEntity)Mockito.verify((Object)entity, (VerificationMode)Mockito.never())).getContent();
    }

    @Test
    public void testCloseQuietlyResponseEntity() throws Exception {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        Mockito.when((Object)entity.isStreaming()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)entity.getContent()).thenReturn((Object)inStream);
        HttpClientUtils.closeQuietly((HttpResponse)response);
        ((InputStream)Mockito.verify((Object)inStream)).close();
    }

    @Test
    public void testCloseQuietlyResponseIgnoreIOError() throws Exception {
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        Mockito.when((Object)entity.getContent()).thenReturn((Object)inStream);
        ((InputStream)Mockito.doThrow((Throwable)new IOException()).when((Object)inStream)).close();
        HttpClientUtils.closeQuietly((HttpResponse)response);
    }

    @Test
    public void testCloseQuietlyCloseableResponseNull() throws Exception {
        CloseableHttpResponse response = null;
        HttpClientUtils.closeQuietly(response);
    }

    @Test
    public void testCloseQuietlyCloseableResponseEntityNull() throws Exception {
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        ((CloseableHttpResponse)Mockito.verify((Object)response)).getEntity();
        ((CloseableHttpResponse)Mockito.verify((Object)response)).close();
    }

    @Test
    public void testCloseQuietlyCloseableResponseEntityNonStreaming() throws Exception {
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        Mockito.when((Object)entity.isStreaming()).thenReturn((Object)Boolean.FALSE);
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        ((HttpEntity)Mockito.verify((Object)entity, (VerificationMode)Mockito.never())).getContent();
        ((CloseableHttpResponse)Mockito.verify((Object)response)).close();
    }

    @Test
    public void testCloseQuietlyCloseableResponseEntity() throws Exception {
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        Mockito.when((Object)entity.isStreaming()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)entity.getContent()).thenReturn((Object)inStream);
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        ((InputStream)Mockito.verify((Object)inStream)).close();
        ((CloseableHttpResponse)Mockito.verify((Object)response)).close();
    }

    @Test
    public void testCloseQuietlyCloseableResponseIgnoreIOError() throws Exception {
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        Mockito.when((Object)entity.getContent()).thenReturn((Object)inStream);
        ((InputStream)Mockito.doThrow((Throwable)new IOException()).when((Object)inStream)).close();
        HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
    }

    @Test
    public void testCloseQuietlyHttpClientNull() throws Exception {
        HttpClient httpclient = null;
        HttpClientUtils.closeQuietly(httpclient);
    }

    @Test
    public void testCloseQuietlyHttpClient() throws Exception {
        CloseableHttpClient httpclient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        HttpClientUtils.closeQuietly((HttpClient)httpclient);
        ((CloseableHttpClient)Mockito.verify((Object)httpclient)).close();
    }

    @Test
    public void testCloseQuietlyCloseableHttpClientIgnoreIOError() throws Exception {
        CloseableHttpClient httpclient = (CloseableHttpClient)Mockito.mock(CloseableHttpClient.class);
        ((CloseableHttpClient)Mockito.doThrow((Throwable)new IOException()).when((Object)httpclient)).close();
        HttpClientUtils.closeQuietly((HttpClient)httpclient);
    }
}

