/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.ConnectionShutdownException;
import org.apache.http.impl.execchain.HttpResponseProxy;
import org.apache.http.impl.execchain.MinimalClientExec;
import org.apache.http.impl.execchain.RequestAbortedException;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestMinimalClientExec {
    @Mock
    private HttpRequestExecutor requestExecutor;
    @Mock
    private HttpClientConnectionManager connManager;
    @Mock
    private ConnectionReuseStrategy reuseStrategy;
    @Mock
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    @Mock
    private HttpExecutionAware execAware;
    @Mock
    private ConnectionRequest connRequest;
    @Mock
    private HttpClientConnection managedConn;
    private MinimalClientExec minimalClientExec;
    private HttpHost target;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.minimalClientExec = new MinimalClientExec(this.requestExecutor, this.connManager, this.reuseStrategy, this.keepAliveStrategy);
        this.target = new HttpHost("foo", 80);
        Mockito.when((Object)this.connManager.requestConnection((HttpRoute)Mockito.any(), Mockito.any())).thenReturn((Object)this.connRequest);
        Mockito.when((Object)this.connRequest.get(Mockito.anyLong(), (TimeUnit)((Object)Mockito.any()))).thenReturn((Object)this.managedConn);
    }

    @Test
    public void testExecRequestNonPersistentConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(123).setSocketTimeout(234).setConnectionRequestTimeout(345).build();
        context.setRequestConfig(config);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        CloseableHttpResponse finalResponse = this.minimalClientExec.execute(route, request, context, this.execAware);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).requestConnection(route, null);
        ((ConnectionRequest)Mockito.verify((Object)this.connRequest)).get(345L, TimeUnit.MILLISECONDS);
        ((HttpExecutionAware)Mockito.verify((Object)this.execAware, (VerificationMode)Mockito.times((int)1))).setCancellable((Cancellable)this.connRequest);
        ((HttpExecutionAware)Mockito.verify((Object)this.execAware, (VerificationMode)Mockito.times((int)2))).setCancellable((Cancellable)Mockito.any());
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).connect(this.managedConn, route, 123, (HttpContext)context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).routeComplete(this.managedConn, route, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn)).setSocketTimeout(234);
        ((HttpRequestExecutor)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)1))).execute((HttpRequest)request, this.managedConn, (HttpContext)context);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn, (VerificationMode)Mockito.times((int)1))).close();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).releaseConnection(this.managedConn, null, 0L, TimeUnit.MILLISECONDS);
        Assert.assertSame((Object)this.managedConn, (Object)context.getConnection());
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertTrue((boolean)(finalResponse instanceof HttpResponseProxy));
    }

    @Test
    public void testExecRequestPersistentConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.managedConn.isStale()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.keepAliveStrategy.getKeepAliveDuration((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)678L);
        CloseableHttpResponse finalResponse = this.minimalClientExec.execute(route, request, context, this.execAware);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).requestConnection(route, null);
        ((ConnectionRequest)Mockito.verify((Object)this.connRequest)).get(0L, TimeUnit.MILLISECONDS);
        ((HttpRequestExecutor)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)1))).execute((HttpRequest)request, this.managedConn, (HttpContext)context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).releaseConnection(this.managedConn, null, 678L, TimeUnit.MILLISECONDS);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn, (VerificationMode)Mockito.never())).close();
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertTrue((boolean)(finalResponse instanceof HttpResponseProxy));
    }

    @Test
    public void testExecRequestConnectionRelease() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        response.setEntity(EntityBuilder.create().setStream((InputStream)new ByteArrayInputStream(new byte[0])).build());
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.managedConn.isStale()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.reuseStrategy.keepAlive((HttpResponse)Mockito.same((Object)response), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.FALSE);
        CloseableHttpResponse finalResponse = this.minimalClientExec.execute(route, request, context, this.execAware);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).requestConnection(route, null);
        ((ConnectionRequest)Mockito.verify((Object)this.connRequest)).get(0L, TimeUnit.MILLISECONDS);
        ((HttpRequestExecutor)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)1))).execute((HttpRequest)request, this.managedConn, (HttpContext)context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager, (VerificationMode)Mockito.never())).releaseConnection((HttpClientConnection)Mockito.same((Object)this.managedConn), Mockito.any(), (long)Mockito.anyInt(), (TimeUnit)((Object)Mockito.any()));
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn, (VerificationMode)Mockito.never())).close();
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertTrue((boolean)(finalResponse instanceof HttpResponseProxy));
        finalResponse.close();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager, (VerificationMode)Mockito.times((int)1))).releaseConnection(this.managedConn, null, 0L, TimeUnit.MILLISECONDS);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testSocketTimeoutExistingConnection() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        RequestConfig config = RequestConfig.custom().setSocketTimeout(3000).build();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        context.setRequestConfig(config);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        this.minimalClientExec.execute(route, request, context, this.execAware);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn)).setSocketTimeout(3000);
    }

    @Test
    public void testSocketTimeoutReset() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.same((Object)request), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        this.minimalClientExec.execute(route, request, context, this.execAware);
        ((HttpClientConnection)Mockito.verify((Object)this.managedConn, (VerificationMode)Mockito.never())).setSocketTimeout(Mockito.anyInt());
    }

    @Test(expected=RequestAbortedException.class)
    public void testExecAbortedPriorToConnectionLease() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.managedConn.isOpen()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.execAware.isAborted()).thenReturn((Object)Boolean.TRUE);
        try {
            this.minimalClientExec.execute(route, request, context, this.execAware);
        }
        catch (IOException ex) {
            ((ConnectionRequest)Mockito.verify((Object)this.connRequest, (VerificationMode)Mockito.times((int)1))).cancel();
            throw ex;
        }
    }

    @Test(expected=RequestAbortedException.class)
    public void testExecConnectionRequestFailed() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.connRequest.get((long)Mockito.anyInt(), (TimeUnit)((Object)Mockito.any()))).thenThrow(new Throwable[]{new ExecutionException("Opppsie", null)});
        this.minimalClientExec.execute(route, request, context, this.execAware);
    }

    @Test(expected=InterruptedIOException.class)
    public void testExecConnectionShutDown() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new ConnectionShutdownException()});
        this.minimalClientExec.execute(route, request, context, this.execAware);
    }

    @Test(expected=RuntimeException.class)
    public void testExecRuntimeException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new RuntimeException("Ka-boom")});
        try {
            this.minimalClientExec.execute(route, request, context, this.execAware);
        }
        catch (Exception ex) {
            ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).releaseConnection(this.managedConn, null, 0L, TimeUnit.MILLISECONDS);
            throw ex;
        }
    }

    @Test(expected=HttpException.class)
    public void testExecHttpException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new HttpException("Ka-boom")});
        try {
            this.minimalClientExec.execute(route, request, context, this.execAware);
        }
        catch (Exception ex) {
            ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).releaseConnection(this.managedConn, null, 0L, TimeUnit.MILLISECONDS);
            throw ex;
        }
    }

    @Test(expected=IOException.class)
    public void testExecIOException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenThrow(new Throwable[]{new IOException("Ka-boom")});
        try {
            this.minimalClientExec.execute(route, request, context, this.execAware);
        }
        catch (Exception ex) {
            ((HttpClientConnectionManager)Mockito.verify((Object)this.connManager)).releaseConnection(this.managedConn, null, 0L, TimeUnit.MILLISECONDS);
            throw ex;
        }
    }

    @Test
    public void absoluteUriIsRewrittenToRelativeBeforeBeingPassedInRequestLine() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("http://bar/test"));
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)this.requestExecutor.execute((HttpRequest)Mockito.any(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)response);
        this.minimalClientExec.execute(route, request, context, this.execAware);
        ArgumentCaptor reqCaptor = ArgumentCaptor.forClass(HttpRequest.class);
        ((HttpRequestExecutor)Mockito.verify((Object)this.requestExecutor)).execute((HttpRequest)reqCaptor.capture(), (HttpClientConnection)Mockito.any(), (HttpContext)Mockito.any());
        Assert.assertEquals((Object)"/test", (Object)((HttpRequest)reqCaptor.getValue()).getRequestLine().getUri());
    }
}

