/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestMinimalClientRequestExecution
extends LocalServerTestBase {
    @Test
    public void testNonCompliantURI() throws Exception {
        this.serverBootstrap.registerHandler("*", (HttpRequestHandler)new SimpleService());
        this.httpclient = HttpClients.createMinimal();
        HttpHost target = this.start();
        HttpClientContext context = HttpClientContext.create();
        for (int i = 0; i < 10; ++i) {
            HttpGet request = new HttpGet("/");
            CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)request, (HttpContext)context);
            EntityUtils.consume((HttpEntity)response.getEntity());
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            HttpRequest reqWrapper = context.getRequest();
            Assert.assertNotNull((Object)reqWrapper);
            Header[] headers = reqWrapper.getAllHeaders();
            HashSet<String> headerSet = new HashSet<String>();
            for (Header header : headers) {
                headerSet.add(header.getName().toLowerCase(Locale.ROOT));
            }
            Assert.assertEquals((long)3L, (long)headerSet.size());
            Assert.assertTrue((boolean)headerSet.contains("connection"));
            Assert.assertTrue((boolean)headerSet.contains("host"));
            Assert.assertTrue((boolean)headerSet.contains("user-agent"));
        }
    }

    private static class SimpleService
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusCode(200);
            StringEntity entity = new StringEntity("Whatever");
            response.setEntity((HttpEntity)entity);
        }
    }
}

