/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.net.ConnectException;
import java.net.SocketTimeoutException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.impl.client.DefaultBackoffStrategy;
import org.apache.http.message.BasicHttpResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultBackoffStrategy {
    private DefaultBackoffStrategy impl;

    @Before
    public void setUp() {
        this.impl = new DefaultBackoffStrategy();
    }

    @Test
    public void isABackoffStrategy() {
        Assert.assertTrue((boolean)(this.impl instanceof ConnectionBackoffStrategy));
    }

    @Test
    public void backsOffForSocketTimeouts() {
        Assert.assertTrue((boolean)this.impl.shouldBackoff((Throwable)new SocketTimeoutException()));
    }

    @Test
    public void backsOffForConnectionTimeouts() {
        Assert.assertTrue((boolean)this.impl.shouldBackoff((Throwable)new ConnectException()));
    }

    @Test
    public void doesNotBackOffForConnectionManagerTimeout() {
        Assert.assertFalse((boolean)this.impl.shouldBackoff((Throwable)new ConnectionPoolTimeoutException()));
    }

    @Test
    public void backsOffForServiceUnavailable() {
        BasicHttpResponse resp = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 503, "Service Unavailable");
        Assert.assertTrue((boolean)this.impl.shouldBackoff((HttpResponse)resp));
    }

    @Test
    public void backsOffForTooManyRequests() {
        BasicHttpResponse resp = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 429, "Too Many Requests");
        Assert.assertTrue((boolean)this.impl.shouldBackoff((HttpResponse)resp));
    }

    @Test
    public void doesNotBackOffForNon429And503StatusCodes() {
        for (int i = 100; i <= 599; ++i) {
            if (i == 429 || i == 503) continue;
            BasicHttpResponse resp = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, i, "Foo");
            Assert.assertFalse((boolean)this.impl.shouldBackoff((HttpResponse)resp));
        }
    }
}

