/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.RequestExpectContinue;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestExpectContinue {
    @Test
    public void testRequestExpectContinueGenerated() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(true).build();
        context.setAttribute("http.request-config", (Object)config);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", "US-ASCII");
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Expect");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"100-continue", (Object)header.getValue());
    }

    @Test
    public void testRequestExpectContinueNotGenerated() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(false).build();
        context.setAttribute("http.request-config", (Object)config);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", "US-ASCII");
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Expect");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testRequestExpectContinueHTTP10() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(true).build();
        context.setAttribute("http.request-config", (Object)config);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/", (ProtocolVersion)HttpVersion.HTTP_1_0);
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", "US-ASCII");
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Expect");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testRequestExpectContinueZeroContent() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(true).build();
        context.setAttribute("http.request-config", (Object)config);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/");
        String s = "";
        StringEntity entity = new StringEntity("", "US-ASCII");
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header = request.getFirstHeader("Expect");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testRequestExpectContinueInvalidInput() throws Exception {
        RequestExpectContinue interceptor = new RequestExpectContinue();
        try {
            interceptor.process(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRequestExpectContinueIgnoreNonenclosingRequests() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpRequest request = new BasicHttpRequest("POST", "/");
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((long)0L, (long)request.getAllHeaders().length);
    }
}

