/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.localserver;

import java.net.InetSocketAddress;
import org.apache.http.HttpHost;
import org.apache.http.localserver.LocalTestServer;
import org.junit.After;

public abstract class LocalServerTestBase {
    protected LocalTestServer localServer;

    @After
    public void shutDownServer() throws Exception {
        if (this.localServer != null) {
            this.localServer.stop();
        }
        this.localServer = null;
    }

    protected void startServer() throws Exception {
        if (this.localServer == null) {
            this.localServer = new LocalTestServer(null, null);
            this.localServer.registerDefaultHandlers();
        }
        this.localServer.setTimeout(5000);
        this.localServer.start();
    }

    protected HttpHost getServerHttp() {
        InetSocketAddress address = this.localServer.getServiceAddress();
        return new HttpHost(address.getHostName(), address.getPort(), "http");
    }
}

