/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Iterator;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.AbstractCookieSpec;
import org.junit.Assert;
import org.junit.Test;

public class TestAbstractCookieSpec {
    @Test
    public void testSimpleRegisterAndGet() {
        DummyCookieAttribHandler h1 = new DummyCookieAttribHandler();
        DummyCookieAttribHandler h2 = new DummyCookieAttribHandler();
        DummyCookieSpec cookiespec = new DummyCookieSpec();
        cookiespec.registerAttribHandler("this", h1);
        cookiespec.registerAttribHandler("that", h2);
        cookiespec.registerAttribHandler("thistoo", h1);
        cookiespec.registerAttribHandler("thattoo", h2);
        Assert.assertTrue((h1 == cookiespec.getAttribHandler("this") ? 1 : 0) != 0);
        Assert.assertTrue((h2 == cookiespec.getAttribHandler("that") ? 1 : 0) != 0);
        Assert.assertTrue((h1 == cookiespec.getAttribHandler("thistoo") ? 1 : 0) != 0);
        Assert.assertTrue((h2 == cookiespec.getAttribHandler("thattoo") ? 1 : 0) != 0);
        Iterator it = cookiespec.getAttribHandlers().iterator();
        Assert.assertNotNull(it.next());
        Assert.assertNotNull(it.next());
        Assert.assertNotNull(it.next());
        Assert.assertNotNull(it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test(expected=IllegalStateException.class)
    public void testInvalidHandler() {
        DummyCookieAttribHandler h1 = new DummyCookieAttribHandler();
        DummyCookieAttribHandler h2 = new DummyCookieAttribHandler();
        DummyCookieSpec cookiespec = new DummyCookieSpec();
        cookiespec.registerAttribHandler("this", h1);
        cookiespec.registerAttribHandler("that", h2);
        Assert.assertNull((Object)cookiespec.findAttribHandler("whatever"));
        cookiespec.getAttribHandler("whatever");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBasicPathInvalidInput1() throws Exception {
        DummyCookieSpec cookiespec = new DummyCookieSpec();
        cookiespec.registerAttribHandler(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBasicPathInvalidInput2() throws Exception {
        DummyCookieSpec cookiespec = new DummyCookieSpec();
        cookiespec.registerAttribHandler("whatever", null);
    }

    private static class DummyCookieAttribHandler
    implements CookieAttributeHandler {
        private DummyCookieAttribHandler() {
        }

        public boolean match(Cookie cookie, CookieOrigin origin) {
            return true;
        }

        public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        }

        public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DummyCookieSpec
    extends AbstractCookieSpec {
        private DummyCookieSpec() {
        }

        public List<Header> formatCookies(List<Cookie> cookies) {
            return null;
        }

        public boolean match(Cookie cookie, CookieOrigin origin) {
            return true;
        }

        public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
            return null;
        }

        public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        }

        public int getVersion() {
            return 0;
        }

        public Header getVersionHeader() {
            return null;
        }
    }
}

