/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicCredentialsProvider {
    public static final Credentials CREDS1 = new UsernamePasswordCredentials("user1", "pass1");
    public static final Credentials CREDS2 = new UsernamePasswordCredentials("user2", "pass2");
    public static final AuthScope SCOPE1 = new AuthScope(AuthScope.ANY_HOST, -1, "realm1");
    public static final AuthScope SCOPE2 = new AuthScope(AuthScope.ANY_HOST, -1, "realm2");
    public static final AuthScope BOGUS = new AuthScope(AuthScope.ANY_HOST, -1, "bogus");
    public static final AuthScope DEFSCOPE = new AuthScope("host", -1, "realm");

    @Test
    public void testBasicCredentialsProviderCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        state.setCredentials(SCOPE1, CREDS1);
        state.setCredentials(SCOPE2, CREDS2);
        Assert.assertEquals((Object)CREDS1, (Object)state.getCredentials(SCOPE1));
        Assert.assertEquals((Object)CREDS2, (Object)state.getCredentials(SCOPE2));
    }

    @Test
    public void testBasicCredentialsProviderNoCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        Assert.assertEquals(null, (Object)state.getCredentials(BOGUS));
    }

    @Test
    public void testBasicCredentialsProviderDefaultCredentials() {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        state.setCredentials(AuthScope.ANY, CREDS1);
        state.setCredentials(SCOPE2, CREDS2);
        Assert.assertEquals((Object)CREDS1, (Object)state.getCredentials(BOGUS));
    }

    @Test
    public void testDefaultCredentials() throws Exception {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass");
        state.setCredentials(AuthScope.ANY, (Credentials)expected);
        Credentials got = state.getCredentials(DEFSCOPE);
        Assert.assertEquals((Object)got, (Object)expected);
    }

    @Test
    public void testRealmCredentials() throws Exception {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass");
        state.setCredentials(DEFSCOPE, (Credentials)expected);
        Credentials got = state.getCredentials(DEFSCOPE);
        Assert.assertEquals((Object)expected, (Object)got);
    }

    @Test
    public void testHostCredentials() throws Exception {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass");
        state.setCredentials(new AuthScope("host", -1, AuthScope.ANY_REALM), (Credentials)expected);
        Credentials got = state.getCredentials(DEFSCOPE);
        Assert.assertEquals((Object)expected, (Object)got);
    }

    @Test
    public void testWrongHostCredentials() throws Exception {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials expected = new UsernamePasswordCredentials("name", "pass");
        state.setCredentials(new AuthScope("host1", -1, "realm"), (Credentials)expected);
        Credentials got = state.getCredentials(new AuthScope("host2", -1, "realm"));
        Assert.assertNotSame((Object)expected, (Object)got);
    }

    @Test
    public void testWrongRealmCredentials() throws Exception {
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("name", "pass");
        state.setCredentials(new AuthScope("host", -1, "realm1"), (Credentials)cred);
        Credentials got = state.getCredentials(new AuthScope("host", -1, "realm2"));
        Assert.assertNotSame((Object)cred, (Object)got);
    }

    @Test
    public void testScopeMatching() {
        AuthScope authscope1 = new AuthScope("somehost", 80, "somerealm", "somescheme");
        AuthScope authscope2 = new AuthScope("someotherhost", 80, "somerealm", "somescheme");
        Assert.assertTrue((authscope1.match(authscope2) < 0 ? 1 : 0) != 0);
        int m1 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "somescheme"));
        int m2 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, -1, "somerealm", AuthScope.ANY_SCHEME));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "somescheme"));
        m2 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, -1, "somerealm", AuthScope.ANY_SCHEME));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, -1, "somerealm", "somescheme"));
        m2 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, 80, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, 80, "somerealm", "somescheme"));
        m2 = authscope1.match(new AuthScope("somehost", -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
        m1 = authscope1.match(AuthScope.ANY);
        m2 = authscope1.match(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "somescheme"));
        Assert.assertTrue((m2 > m1 ? 1 : 0) != 0);
    }

    @Test
    public void testCredentialsMatching() {
        UsernamePasswordCredentials creds1 = new UsernamePasswordCredentials("name1", "pass1");
        UsernamePasswordCredentials creds2 = new UsernamePasswordCredentials("name2", "pass2");
        UsernamePasswordCredentials creds3 = new UsernamePasswordCredentials("name3", "pass3");
        AuthScope scope1 = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM);
        AuthScope scope2 = new AuthScope(AuthScope.ANY_HOST, -1, "somerealm");
        AuthScope scope3 = new AuthScope("somehost", -1, AuthScope.ANY_REALM);
        BasicCredentialsProvider state = new BasicCredentialsProvider();
        state.setCredentials(scope1, (Credentials)creds1);
        state.setCredentials(scope2, (Credentials)creds2);
        state.setCredentials(scope3, (Credentials)creds3);
        Credentials got = state.getCredentials(new AuthScope("someotherhost", 80, "someotherrealm", "basic"));
        UsernamePasswordCredentials expected = creds1;
        Assert.assertEquals((Object)expected, (Object)got);
        got = state.getCredentials(new AuthScope("someotherhost", 80, "somerealm", "basic"));
        expected = creds2;
        Assert.assertEquals((Object)expected, (Object)got);
        got = state.getCredentials(new AuthScope("somehost", 80, "someotherrealm", "basic"));
        expected = creds3;
        Assert.assertEquals((Object)expected, (Object)got);
    }
}

