/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EncodingUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicScheme {
    @Test(expected=MalformedChallengeException.class)
    public void testBasicAuthenticationWithNoRealm() throws Exception {
        String challenge = "Basic";
        BasicHeader header = new BasicHeader("WWW-Authenticate", "Basic");
        BasicScheme authscheme = new BasicScheme();
        authscheme.processChallenge((Header)header);
    }

    @Test
    public void testBasicAuthenticationWith88591Chars() throws Exception {
        int[] germanChars = new int[]{228, 45, 246, 45, 252};
        StringBuilder buffer = new StringBuilder();
        for (int germanChar : germanChars) {
            buffer.append((char)germanChar);
        }
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("dh", buffer.toString());
        BasicScheme authscheme = new BasicScheme(Consts.ISO_8859_1);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpContext context = new BasicHttpContext();
        Header header = authscheme.authenticate((Credentials)creds, (HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((Object)"Basic ZGg65C32Lfw=", (Object)header.getValue());
    }

    @Test
    public void testBasicAuthentication() throws Exception {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("testuser", "testpass");
        BasicHeader challenge = new BasicHeader("WWW-Authenticate", "Basic realm=\"test\"");
        BasicScheme authscheme = new BasicScheme();
        authscheme.processChallenge((Header)challenge);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpContext context = new BasicHttpContext();
        Header authResponse = authscheme.authenticate((Credentials)creds, (HttpRequest)request, (HttpContext)context);
        String expected = "Basic " + EncodingUtils.getAsciiString((byte[])Base64.encodeBase64((byte[])EncodingUtils.getAsciiBytes((String)"testuser:testpass")));
        Assert.assertEquals((Object)"Authorization", (Object)authResponse.getName());
        Assert.assertEquals((Object)expected, (Object)authResponse.getValue());
        Assert.assertEquals((Object)"test", (Object)authscheme.getRealm());
        Assert.assertTrue((boolean)authscheme.isComplete());
        Assert.assertFalse((boolean)authscheme.isConnectionBased());
    }

    @Test
    public void testBasicProxyAuthentication() throws Exception {
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("testuser", "testpass");
        BasicHeader challenge = new BasicHeader("Proxy-Authenticate", "Basic realm=\"test\"");
        BasicScheme authscheme = new BasicScheme();
        authscheme.processChallenge((Header)challenge);
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpContext context = new BasicHttpContext();
        Header authResponse = authscheme.authenticate((Credentials)creds, (HttpRequest)request, (HttpContext)context);
        String expected = "Basic " + EncodingUtils.getAsciiString((byte[])Base64.encodeBase64((byte[])EncodingUtils.getAsciiBytes((String)"testuser:testpass")));
        Assert.assertEquals((Object)"Proxy-Authorization", (Object)authResponse.getName());
        Assert.assertEquals((Object)expected, (Object)authResponse.getValue());
        Assert.assertEquals((Object)"test", (Object)authscheme.getRealm());
        Assert.assertTrue((boolean)authscheme.isComplete());
        Assert.assertFalse((boolean)authscheme.isConnectionBased());
    }
}

