/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.SpnegoTokenGenerator;
import org.apache.http.message.BasicHeader;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class NegotiateScheme
implements AuthScheme {
    private static final int UNINITIATED = 0;
    private static final int INITIATED = 1;
    private static final int NEGOTIATING = 3;
    private static final int ESTABLISHED = 4;
    private static final int FAILED = Integer.MAX_VALUE;
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private final Log log;
    private boolean stripPort = false;
    private SpnegoTokenGenerator spengoGenerator = null;
    private GSSContext context = null;
    private int state = 0;
    byte[] token = new byte[0];
    private Oid negotiationOid = null;

    public NegotiateScheme() {
        this.log = LogFactory.getLog(this.getClass());
    }

    protected void init(String server) throws GSSException {
        GSSName serverName;
        GSSManager manager;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("init " + server));
        }
        this.negotiationOid = new Oid(SPNEGO_OID);
        boolean tryKerberos = false;
        try {
            manager = GSSManager.getInstance();
            serverName = manager.createName("HTTP/" + server, null);
            this.context = manager.createContext(serverName.canonicalize(this.negotiationOid), this.negotiationOid, null, 0);
            this.context.requestMutualAuth(true);
            this.context.requestCredDeleg(true);
        }
        catch (GSSException ex) {
            if (ex.getMajor() == 2) {
                this.log.debug((Object)"GSSException BAD_MECH, retry with Kerberos MECH");
                tryKerberos = true;
            }
            throw ex;
        }
        if (tryKerberos) {
            this.log.debug((Object)"Using Kerberos MECH 1.2.840.113554.1.2.2");
            this.negotiationOid = new Oid(KERBEROS_OID);
            manager = GSSManager.getInstance();
            serverName = manager.createName("HTTP/" + server, null);
            this.context = manager.createContext(serverName.canonicalize(this.negotiationOid), this.negotiationOid, null, 0);
            this.context.requestMutualAuth(true);
            this.context.requestCredDeleg(true);
        }
        this.state = 1;
    }

    public boolean isComplete() {
        return this.state == 4 || this.state == Integer.MAX_VALUE;
    }

    public String getSchemeName() {
        return "Negotiate";
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        if (this.state == 0) {
            throw new IllegalStateException("Negotiation authentication process has not been initiated");
        }
        try {
            if (this.context == null) {
                if (this.isStripPort()) {
                    this.init(request.getLastHeader("Host").getValue().replaceAll(":[0-9]+$", ""));
                } else {
                    this.init(request.getLastHeader("Host").getValue());
                }
            }
            this.token = this.context.initSecContext(this.token, 0, this.token.length);
            if (this.spengoGenerator != null && this.negotiationOid.toString().equals(KERBEROS_OID)) {
                this.token = this.spengoGenerator.generateSpnegoDERObject(this.token);
            }
            if (this.log.isDebugEnabled()) {
                this.log.info((Object)("got token, sending " + this.token.length + " bytes to server"));
            }
        }
        catch (GSSException gsse) {
            this.state = Integer.MAX_VALUE;
            if (gsse.getMajor() == 9 || gsse.getMajor() == 8) {
                throw new InvalidCredentialsException(gsse.getMessage(), gsse);
            }
            if (gsse.getMajor() == 13) {
                throw new InvalidCredentialsException(gsse.getMessage(), gsse);
            }
            if (gsse.getMajor() == 10 || gsse.getMajor() == 19 || gsse.getMajor() == 20) {
                throw new AuthenticationException(gsse.getMessage(), gsse);
            }
            throw new AuthenticationException(gsse.getMessage());
        }
        catch (IOException ex) {
            this.state = Integer.MAX_VALUE;
            throw new AuthenticationException(ex.getMessage());
        }
        return new BasicHeader("Authorization", "Negotiate " + new String(new Base64().encode(this.token)));
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        String challenge;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Challenge header: " + header));
        }
        if ((challenge = header.getValue()).startsWith("Negotiate")) {
            if (!this.isComplete()) {
                this.state = 3;
            }
            if (challenge.startsWith("Negotiate ")) {
                this.token = new Base64().decode(challenge.substring(10).getBytes());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("challenge = " + challenge.substring(10)));
                }
            } else {
                this.token = new byte[0];
            }
        }
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public void setStripPort(boolean stripport) {
        if (stripport) {
            this.log.debug((Object)"Will strip ports off Service Names e.g. HTTP/server:8080 -> HTTP/server");
        } else {
            this.log.debug((Object)"Will NOT strip ports off Service Names e.g. HTTP/server:8080 -> HTTP/server");
        }
        this.stripPort = stripport;
    }

    public void setSpengoGenerator(SpnegoTokenGenerator SpengoGenerator) {
        this.spengoGenerator = SpengoGenerator;
    }
}

