/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.SchemeRegistry;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.AbstractPoolEntry;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.impl.conn.tsccm.AbstractConnPool;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.BasicPooledConnAdapter;
import org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.http.params.HttpParams;

public class ThreadSafeClientConnManager
implements ClientConnectionManager {
    private final Log LOG = LogFactory.getLog(ThreadSafeClientConnManager.class);
    protected SchemeRegistry schemeRegistry;
    protected HttpParams params;
    protected final AbstractConnPool connectionPool;
    protected ClientConnectionOperator connOperator;

    public ThreadSafeClientConnManager(HttpParams params, SchemeRegistry schreg) {
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.params = params;
        this.schemeRegistry = schreg;
        this.connectionPool = this.createConnectionPool();
        this.connOperator = this.createConnectionOperator(schreg);
    }

    protected AbstractConnPool createConnectionPool() {
        ConnPoolByRoute acp = new ConnPoolByRoute(this);
        boolean conngc = true;
        if (conngc) {
            acp.enableConnectionGC();
        }
        return acp;
    }

    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schreg) {
        return new DefaultClientConnectionOperator(schreg);
    }

    public SchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    public ManagedClientConnection getConnection(HttpRoute route) throws InterruptedException {
        while (true) {
            try {
                return this.getConnection(route, 0L, null);
            }
            catch (ConnectionPoolTimeoutException e) {
                this.LOG.debug((Object)"Unexpected exception while waiting for connection.", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public ManagedClientConnection getConnection(HttpRoute route, long timeout, TimeUnit tunit) throws ConnectionPoolTimeoutException, InterruptedException {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null.");
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("ThreadSafeClientConnManager.getConnection: " + route + ", timeout = " + timeout));
        }
        BasicPoolEntry entry = this.connectionPool.getEntry(route, timeout, tunit, this.connOperator);
        return new BasicPooledConnAdapter(this, (AbstractPoolEntry)entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(ManagedClientConnection conn) {
        if (!(conn instanceof BasicPooledConnAdapter)) {
            throw new IllegalArgumentException("Connection class mismatch, connection not obtained from this manager.");
        }
        BasicPooledConnAdapter hca = (BasicPooledConnAdapter)conn;
        if (hca.getPoolEntry() != null && hca.getManager() != this) {
            throw new IllegalArgumentException("Connection not obtained from this manager.");
        }
        try {
            if (hca.isOpen() && !hca.isMarkedReusable()) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)"Released connection open but not marked reusable.");
                }
                hca.shutdown();
            }
        }
        catch (IOException iox) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)"Exception shutting down released connection.", (Throwable)iox);
            }
        }
        finally {
            BasicPoolEntry entry = (BasicPoolEntry)hca.getPoolEntry();
            hca.detach();
            if (entry != null) {
                this.connectionPool.freeEntry(entry);
            }
        }
    }

    public void shutdown() {
        this.connectionPool.shutdown();
    }

    public int getConnectionsInPool(HttpRoute route) {
        return ((ConnPoolByRoute)this.connectionPool).getConnectionsInPool(route);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsInPool() {
        AbstractConnPool abstractConnPool = this.connectionPool;
        synchronized (abstractConnPool) {
            return this.connectionPool.numConnections;
        }
    }

    public void closeIdleConnections(long idleTimeout, TimeUnit tunit) {
        this.connectionPool.closeIdleConnections(idleTimeout, tunit);
        this.connectionPool.deleteClosedConnections();
    }

    public HttpParams getParams() {
        return this.params;
    }
}

