/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.IdleConnectionHandler;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.BasicPoolEntryRef;
import org.apache.http.impl.conn.tsccm.RefQueueHandler;
import org.apache.http.impl.conn.tsccm.RefQueueWorker;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnPool
implements RefQueueHandler {
    private final Log LOG = LogFactory.getLog(AbstractConnPool.class);
    protected final Lock poolLock;
    protected Set<BasicPoolEntryRef> issuedConnections;
    protected IdleConnectionHandler idleConnHandler;
    protected int numConnections;
    protected HttpParams params;
    protected ConnMgrRef connManager;
    protected ReferenceQueue<Object> refQueue;
    private RefQueueWorker refWorker;
    protected volatile boolean isShutDown;

    protected AbstractConnPool(ClientConnectionManager mgr) {
        this.params = mgr.getParams();
        this.issuedConnections = new HashSet<BasicPoolEntryRef>();
        this.idleConnHandler = new IdleConnectionHandler();
        boolean fair = false;
        this.poolLock = new ReentrantLock(fair);
        this.connManager = new ConnMgrRef(mgr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableConnectionGC() throws IllegalStateException {
        if (this.refQueue != null) {
            throw new IllegalStateException("Connection GC already enabled.");
        }
        try {
            this.poolLock.lock();
            if (this.numConnections > 0) {
                throw new IllegalStateException("Pool already in use.");
            }
        }
        finally {
            this.poolLock.unlock();
        }
        this.refQueue = new ReferenceQueue();
        this.refWorker = new RefQueueWorker(this.refQueue, this);
        Thread t = new Thread(this.refWorker);
        t.setDaemon(true);
        t.setName("RefQueueWorker@" + this);
        t.start();
        this.connManager = new ConnMgrRef((ClientConnectionManager)this.connManager.get(), this.refQueue);
    }

    public abstract BasicPoolEntry getEntry(HttpRoute var1, long var2, TimeUnit var4, ClientConnectionOperator var5) throws ConnectionPoolTimeoutException, InterruptedException;

    public abstract void freeEntry(BasicPoolEntry var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReference(Reference<?> ref) {
        try {
            this.poolLock.lock();
            if (ref instanceof BasicPoolEntryRef) {
                boolean lost = this.issuedConnections.remove(ref);
                if (lost) {
                    HttpRoute route = ((BasicPoolEntryRef)ref).getRoute();
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)("Connection garbage collected. " + route));
                    }
                    this.handleLostEntry(route);
                }
            } else if (ref instanceof ConnMgrRef) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)"Connection manager garbage collected.");
                }
                this.shutdown();
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    protected abstract void handleLostEntry(HttpRoute var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIdleConnections(long idletime, TimeUnit tunit) {
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit must not be null.");
        }
        try {
            this.poolLock.lock();
            this.idleConnHandler.closeIdleConnections(tunit.toMillis(idletime));
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public abstract void deleteClosedConnections();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.poolLock.lock();
            if (this.isShutDown) {
                return;
            }
            if (this.refWorker != null) {
                this.refWorker.shutdown();
            }
            Iterator<BasicPoolEntryRef> iter = this.issuedConnections.iterator();
            while (iter.hasNext()) {
                BasicPoolEntryRef per = iter.next();
                iter.remove();
                BasicPoolEntry entry = (BasicPoolEntry)per.get();
                if (entry == null) continue;
                this.closeConnection(entry.getConnection());
            }
            this.idleConnHandler.removeAll();
            this.isShutDown = true;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    protected void closeConnection(OperatedClientConnection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (IOException ex) {
                this.LOG.debug((Object)"I/O error closing connection", (Throwable)ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnMgrRef
    extends WeakReference<ClientConnectionManager> {
        public ConnMgrRef(ClientConnectionManager ccmgr, ReferenceQueue<Object> queue) {
            super(ccmgr, queue);
        }
    }
}

