/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieIdentityComparator;

public class BasicCookieStore
implements CookieStore {
    private final ArrayList cookies = new ArrayList();
    private final Comparator cookieComparator = new CookieIdentityComparator();

    public synchronized void addCookie(Cookie cookie) {
        if (cookie != null) {
            Iterator it = this.cookies.iterator();
            while (it.hasNext()) {
                Cookie tmp = (Cookie)it.next();
                if (this.cookieComparator.compare(cookie, tmp) != 0) continue;
                it.remove();
                break;
            }
            if (!cookie.isExpired(new Date())) {
                this.cookies.add(cookie);
            }
        }
    }

    public synchronized void addCookies(Cookie[] cookies) {
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                this.addCookie(cookies[i]);
            }
        }
    }

    public synchronized Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public synchronized boolean clearExpired(Date date) {
        if (date == null) {
            return false;
        }
        boolean removed = false;
        Iterator it = this.cookies.iterator();
        while (it.hasNext()) {
            if (!((Cookie)it.next()).isExpired(date)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    public String toString() {
        return this.cookies.toString();
    }

    public synchronized void clear() {
        this.cookies.clear();
    }
}

