/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Iterator;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.AbstractCookieSpec;

public abstract class CookieSpecBase
extends AbstractCookieSpec {
    protected static String getDefaultPath(CookieOrigin origin) {
        String defaultPath = origin.getPath();
        int lastSlashIndex = defaultPath.lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            if (lastSlashIndex == 0) {
                lastSlashIndex = 1;
            }
            defaultPath = defaultPath.substring(0, lastSlashIndex);
        }
        return defaultPath;
    }

    protected static String getDefaultDomain(CookieOrigin origin) {
        return origin.getHost();
    }

    protected Cookie[] parse(HeaderElement[] elems, CookieOrigin origin) throws MalformedCookieException {
        Cookie[] cookies = new Cookie[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            HeaderElement headerelement = elems[i];
            String name = headerelement.getName();
            String value = headerelement.getValue();
            if (name == null || name.equals("")) {
                throw new MalformedCookieException("Cookie name may not be empty");
            }
            Cookie cookie = new Cookie(name, value);
            cookie.setPath(CookieSpecBase.getDefaultPath(origin));
            cookie.setDomain(CookieSpecBase.getDefaultDomain(origin));
            NameValuePair[] attribs = headerelement.getParameters();
            for (int j = attribs.length - 1; j >= 0; --j) {
                NameValuePair attrib = attribs[j];
                String s = attrib.getName().toLowerCase();
                CookieAttributeHandler handler = this.findAttribHandler(s);
                if (handler == null) continue;
                handler.parse(cookie, attrib.getValue());
            }
            cookies[i] = cookie;
        }
        return cookies;
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        Iterator i = this.getAttribHandlerIterator();
        while (i.hasNext()) {
            CookieAttributeHandler handler = (CookieAttributeHandler)i.next();
            handler.validate(cookie, origin);
        }
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        if (cookie == null) {
            throw new IllegalArgumentException("Cookie may not be null");
        }
        if (origin == null) {
            throw new IllegalArgumentException("Cookie origin may not be null");
        }
        Iterator i = this.getAttribHandlerIterator();
        while (i.hasNext()) {
            CookieAttributeHandler handler = (CookieAttributeHandler)i.next();
            if (handler.match(cookie, origin)) continue;
            return false;
        }
        return true;
    }
}

