/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.HttpRoute;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.SchemeRegistry;
import org.apache.http.impl.conn.AbstractPoolEntry;
import org.apache.http.impl.conn.AbstractPooledConnAdapter;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class SingleClientConnManager
implements ClientConnectionManager {
    private static final Log LOG = LogFactory.getLog((Class)SingleClientConnManager.class);
    public static final String MISUSE_MESSAGE = "Invalid use of SingleClientConnManager: connection still allocated.\nMake sure to release the connection before allocating another one.";
    protected SchemeRegistry schemeRegistry;
    protected HttpParams params = new BasicHttpParams();
    protected ClientConnectionOperator connOperator;
    protected PoolEntry uniquePoolEntry;
    protected ConnAdapter managedConn;
    protected long lastReleaseTime;
    protected boolean alwaysShutDown;
    protected volatile boolean isShutDown;

    public SingleClientConnManager(HttpParams params, SchemeRegistry schreg) {
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (schreg == null) {
            throw new IllegalArgumentException("Scheme registry must not be null.");
        }
        this.params = params;
        this.schemeRegistry = schreg;
        this.connOperator = this.createConnectionOperator(schreg);
        this.uniquePoolEntry = new PoolEntry(this.connOperator.createConnection());
        this.managedConn = null;
        this.lastReleaseTime = -1L;
        this.alwaysShutDown = false;
        this.isShutDown = false;
    }

    public SchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schreg) {
        return new DefaultClientConnectionOperator(schreg);
    }

    protected final void assertStillUp() throws IllegalStateException {
        if (this.isShutDown) {
            throw new IllegalStateException("Manager is shut down.");
        }
    }

    public final ManagedClientConnection getConnection(HttpRoute route, long timeout) {
        return this.getConnection(route);
    }

    public ManagedClientConnection getConnection(HttpRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null.");
        }
        this.assertStillUp();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("SingleClientConnManager.getConnection: " + route));
        }
        if (this.managedConn != null) {
            this.revokeConnection();
        }
        if (this.uniquePoolEntry.connection.isOpen()) {
            boolean shutdown;
            boolean bl = shutdown = this.uniquePoolEntry.tracker == null || !this.uniquePoolEntry.tracker.toRoute().equals(route);
            if (shutdown) {
                try {
                    this.uniquePoolEntry.shutdown();
                }
                catch (IOException iox) {
                    LOG.debug((Object)"Problem shutting down connection.", (Throwable)iox);
                    this.uniquePoolEntry = new PoolEntry(this.connOperator.createConnection());
                }
            }
        }
        this.managedConn = new ConnAdapter(this.uniquePoolEntry, route);
        return this.managedConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(ManagedClientConnection conn) {
        this.assertStillUp();
        if (!(conn instanceof ConnAdapter)) {
            throw new IllegalArgumentException("Connection class mismatch, connection not obtained from this manager.");
        }
        ConnAdapter sca = (ConnAdapter)conn;
        if (sca.connManager != this) {
            throw new IllegalArgumentException("Connection not obtained from this manager.");
        }
        if (sca.poolEntry == null) {
            return;
        }
        try {
            if (sca.isOpen() && (this.alwaysShutDown || !sca.isMarkedReusable())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Released connection open but not reusable.");
                }
                sca.shutdown();
            }
        }
        catch (IOException iox) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Exception shutting down released connection.", (Throwable)iox);
            }
        }
        finally {
            sca.detach();
            this.managedConn = null;
            this.lastReleaseTime = System.currentTimeMillis();
        }
    }

    public void closeIdleConnections(long idletime) {
        long cutoff;
        this.assertStillUp();
        if (this.managedConn == null && this.uniquePoolEntry.connection.isOpen() && this.lastReleaseTime <= (cutoff = System.currentTimeMillis() - idletime)) {
            try {
                this.uniquePoolEntry.close();
            }
            catch (IOException iox) {
                LOG.debug((Object)"Problem closing idle connection.", (Throwable)iox);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.isShutDown = true;
        if (this.managedConn != null) {
            this.managedConn.detach();
        }
        try {
            if (this.uniquePoolEntry != null) {
                this.uniquePoolEntry.shutdown();
            }
        }
        catch (IOException iox) {
            LOG.debug((Object)"Problem while shutting down manager.", (Throwable)iox);
        }
        finally {
            this.uniquePoolEntry = null;
        }
    }

    protected void revokeConnection() {
        if (this.managedConn == null) {
            return;
        }
        IllegalStateException isx = new IllegalStateException("Revoking connection to " + this.managedConn.getRoute());
        LOG.warn((Object)MISUSE_MESSAGE, (Throwable)isx);
        if (this.managedConn != null) {
            this.managedConn.detach();
        }
        try {
            this.uniquePoolEntry.shutdown();
        }
        catch (IOException iox) {
            LOG.debug((Object)"Problem while shutting down connection.", (Throwable)iox);
        }
    }

    protected class ConnAdapter
    extends AbstractPooledConnAdapter {
        protected ConnAdapter(PoolEntry entry, HttpRoute plan) {
            super((ClientConnectionManager)SingleClientConnManager.this, entry);
            this.markedReusable = true;
            entry.plannedRoute = plan;
        }
    }

    protected class PoolEntry
    extends AbstractPoolEntry {
        protected HttpRoute plannedRoute;

        protected PoolEntry(OperatedClientConnection occ) {
            super(occ);
        }

        protected ClientConnectionOperator getOperator() {
            return SingleClientConnManager.this.connOperator;
        }

        protected void close() throws IOException {
            this.closing();
            if (this.connection.isOpen()) {
                this.connection.close();
            }
        }

        protected void shutdown() throws IOException {
            this.closing();
            if (this.connection.isOpen()) {
                this.connection.shutdown();
            }
        }
    }
}

