/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.message.BufferedHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;

public class DefaultAuthenticationHandler
implements AuthenticationHandler {
    private static final Log LOG = LogFactory.getLog((Class)DefaultAuthenticationHandler.class);
    private static List DEFAULT_SCHEME_PRIORITY = Arrays.asList("digest", "basic");

    public boolean isTargetAuthenticationRequested(HttpResponse response, HttpContext context) {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        int status = response.getStatusLine().getStatusCode();
        return status == 401;
    }

    public boolean isProxyAuthenticationRequested(HttpResponse response, HttpContext context) {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        int status = response.getStatusLine().getStatusCode();
        return status == 407;
    }

    protected Map parseChallenges(Header[] headers) throws MalformedChallengeException {
        HashMap<String, Header> map = new HashMap<String, Header>(headers.length);
        for (int i = 0; i < headers.length; ++i) {
            int pos;
            CharArrayBuffer buffer;
            Header header = headers[i];
            if (header instanceof BufferedHeader) {
                buffer = ((BufferedHeader)header).getBuffer();
                pos = ((BufferedHeader)header).getValuePos();
            } else {
                String s = header.getValue();
                if (s == null) {
                    throw new MalformedChallengeException("Header value is null");
                }
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                pos = 0;
            }
            while (pos < buffer.length() && HTTP.isWhitespace((char)buffer.charAt(pos))) {
                ++pos;
            }
            int beginIndex = pos;
            while (pos < buffer.length() && !HTTP.isWhitespace((char)buffer.charAt(pos))) {
                ++pos;
            }
            int endIndex = pos;
            String s = buffer.substring(beginIndex, endIndex);
            map.put(s.toLowerCase(), header);
        }
        return map;
    }

    public Map getTargetChallenges(HttpResponse response, HttpContext context) throws MalformedChallengeException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        Header[] headers = response.getHeaders("WWW-Authenticate");
        return this.parseChallenges(headers);
    }

    public Map getProxyChallenges(HttpResponse response, HttpContext context) throws MalformedChallengeException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        Header[] headers = response.getHeaders("Proxy-Authenticate");
        return this.parseChallenges(headers);
    }

    public AuthScheme selectScheme(Map challenges, HttpResponse response, HttpContext context) throws AuthenticationException {
        AuthSchemeRegistry registry = (AuthSchemeRegistry)context.getAttribute("http.authscheme-registry");
        if (registry == null) {
            throw new IllegalStateException("AuthScheme registry not set in HTTP context");
        }
        HttpParams params = response.getParams();
        Collection authPrefs = (Collection)params.getParameter("http.protocol-auth-scheme-priority");
        if (authPrefs == null || authPrefs.isEmpty()) {
            authPrefs = DEFAULT_SCHEME_PRIORITY;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Supported authentication schemes in the order of preference: " + authPrefs));
        }
        AuthScheme authScheme = null;
        Iterator it = authPrefs.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            Header challenge = (Header)challenges.get(id.toLowerCase());
            if (challenge != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(id + " authentication scheme selected"));
                }
                try {
                    authScheme = registry.getAuthScheme(id, params);
                    break;
                }
                catch (IllegalStateException e) {
                    throw new AuthenticationException(e.getMessage());
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Challenge for " + id + " authentication scheme not available"));
        }
        if (authScheme == null) {
            throw new AuthenticationException("Unable to respond to any of these challenges: " + challenges);
        }
        return authScheme;
    }
}

