/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.HttpState;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.RoutedRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.impl.client.DefaultClientRequestDirector;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestInterceptorList;
import org.apache.http.protocol.HttpResponseInterceptorList;

public abstract class AbstractHttpClient
implements HttpClient,
HttpRequestInterceptorList,
HttpResponseInterceptorList {
    private HttpContext defaultContext;
    private HttpParams defaultParams;
    private ClientConnectionManager connManager;
    private ConnectionReuseStrategy reuseStrategy;
    private CookieSpecRegistry supportedCookieSpecs;
    private AuthSchemeRegistry supportedAuthSchemes;
    private BasicHttpProcessor httpProcessor;
    private HttpRequestRetryHandler retryHandler;
    private RedirectHandler redirectHandler;
    private AuthenticationHandler authHandler;
    private HttpState defaultState;

    protected AbstractHttpClient(ClientConnectionManager conman, HttpParams params) {
        this.defaultParams = params;
        this.connManager = conman;
    }

    protected abstract HttpParams createHttpParams();

    protected abstract HttpContext createHttpContext();

    protected abstract ClientConnectionManager createClientConnectionManager();

    protected abstract AuthSchemeRegistry createAuthSchemeRegistry();

    protected abstract CookieSpecRegistry createCookieSpecRegistry();

    protected abstract ConnectionReuseStrategy createConnectionReuseStrategy();

    protected abstract BasicHttpProcessor createHttpProcessor();

    protected abstract HttpRequestRetryHandler createHttpRequestRetryHandler();

    protected abstract RedirectHandler createRedirectHandler();

    protected abstract AuthenticationHandler createAuthenticationHandler();

    protected abstract HttpState createHttpState();

    protected abstract void populateContext(HttpContext var1);

    public final synchronized HttpParams getParams() {
        if (this.defaultParams == null) {
            this.defaultParams = this.createHttpParams();
        }
        return this.defaultParams;
    }

    public synchronized void setParams(HttpParams params) {
        this.defaultParams = params;
    }

    public final synchronized ClientConnectionManager getConnectionManager() {
        if (this.connManager == null) {
            this.connManager = this.createClientConnectionManager();
        }
        return this.connManager;
    }

    public final synchronized AuthSchemeRegistry getAuthSchemes() {
        if (this.supportedAuthSchemes == null) {
            this.supportedAuthSchemes = this.createAuthSchemeRegistry();
        }
        return this.supportedAuthSchemes;
    }

    public synchronized void setAuthSchemes(AuthSchemeRegistry authSchemeRegistry) {
        this.supportedAuthSchemes = authSchemeRegistry;
    }

    public final synchronized CookieSpecRegistry getCookieSpecs() {
        if (this.supportedCookieSpecs == null) {
            this.supportedCookieSpecs = this.createCookieSpecRegistry();
        }
        return this.supportedCookieSpecs;
    }

    public synchronized void setCookieSpecs(CookieSpecRegistry cookieSpecRegistry) {
        this.supportedCookieSpecs = cookieSpecRegistry;
    }

    public final synchronized ConnectionReuseStrategy getConnectionReuseStrategy() {
        if (this.reuseStrategy == null) {
            this.reuseStrategy = this.createConnectionReuseStrategy();
        }
        return this.reuseStrategy;
    }

    public synchronized void setReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
        this.reuseStrategy = reuseStrategy;
    }

    public final synchronized HttpRequestRetryHandler getHttpRequestRetryHandler() {
        if (this.retryHandler == null) {
            this.retryHandler = this.createHttpRequestRetryHandler();
        }
        return this.retryHandler;
    }

    public synchronized void setHttpRequestRetryHandler(HttpRequestRetryHandler retryHandler) {
        this.retryHandler = retryHandler;
    }

    public final synchronized RedirectHandler getRedirectHandler() {
        if (this.redirectHandler == null) {
            this.redirectHandler = this.createRedirectHandler();
        }
        return this.redirectHandler;
    }

    public synchronized void setRedirectHandler(RedirectHandler redirectHandler) {
        this.redirectHandler = redirectHandler;
    }

    public final synchronized AuthenticationHandler getAuthenticationHandler() {
        if (this.authHandler == null) {
            this.authHandler = this.createAuthenticationHandler();
        }
        return this.authHandler;
    }

    public synchronized void setAuthenticationHandler(AuthenticationHandler authHandler) {
        this.authHandler = authHandler;
    }

    public final synchronized HttpState getState() {
        if (this.defaultState == null) {
            this.defaultState = this.createHttpState();
        }
        return this.defaultState;
    }

    public synchronized void setState(HttpState state) {
        this.defaultState = state;
    }

    protected final synchronized BasicHttpProcessor getHttpProcessor() {
        if (this.httpProcessor == null) {
            this.httpProcessor = this.createHttpProcessor();
        }
        return this.httpProcessor;
    }

    public final synchronized HttpContext getDefaultContext() {
        if (this.defaultContext == null) {
            this.defaultContext = this.createHttpContext();
        }
        this.populateContext(this.defaultContext);
        return this.defaultContext;
    }

    public synchronized void addResponseInterceptor(HttpResponseInterceptor itcp) {
        this.getHttpProcessor().addInterceptor(itcp);
    }

    public synchronized void clearResponseInterceptors() {
        this.getHttpProcessor().clearResponseInterceptors();
    }

    public synchronized HttpResponseInterceptor getResponseInterceptor(int index) {
        return this.getHttpProcessor().getResponseInterceptor(index);
    }

    public synchronized int getResponseInterceptorCount() {
        return this.getHttpProcessor().getResponseInterceptorCount();
    }

    public synchronized void addRequestInterceptor(HttpRequestInterceptor itcp) {
        this.getHttpProcessor().addInterceptor(itcp);
    }

    public synchronized void clearRequestInterceptors() {
        this.getHttpProcessor().clearRequestInterceptors();
    }

    public synchronized HttpRequestInterceptor getRequestInterceptor(int index) {
        return this.getHttpProcessor().getRequestInterceptor(index);
    }

    public synchronized int getRequestInterceptorCount() {
        return this.getHttpProcessor().getRequestInterceptorCount();
    }

    public synchronized void setInterceptors(List itcps) {
        this.getHttpProcessor().setInterceptors(itcps);
    }

    public final HttpResponse execute(HttpUriRequest request) throws HttpException, IOException {
        return this.execute(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpResponse execute(HttpUriRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("Request must not be null.");
        }
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute()) {
            target = new HttpHost(requestURI.getHost(), requestURI.getPort(), requestURI.getScheme());
        }
        AbstractHttpClient abstractHttpClient = this;
        synchronized (abstractHttpClient) {
            if (context == null) {
                context = new HttpClientContext(this.getDefaultContext());
            }
        }
        RoutedRequest roureq = this.determineRoute(target, request, (HttpContext)context);
        return this.execute(roureq, (HttpContext)context);
    }

    public HttpResponse execute(RoutedRequest roureq) throws HttpException, IOException {
        return this.execute(roureq, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final HttpResponse execute(RoutedRequest roureq, HttpContext context) throws HttpException, IOException {
        if (roureq == null) {
            throw new IllegalArgumentException("Routed request must not be null.");
        }
        if (roureq.getRequest() == null) {
            throw new IllegalArgumentException("Request must not be null.");
        }
        if (roureq.getRoute() == null) {
            throw new IllegalArgumentException("Route must not be null.");
        }
        DefaultClientRequestDirector director = null;
        AbstractHttpClient abstractHttpClient = this;
        synchronized (abstractHttpClient) {
            if (context == null) {
                context = new HttpClientContext(this.getDefaultContext());
            }
            director = new DefaultClientRequestDirector(this.getConnectionManager(), this.getConnectionReuseStrategy(), (HttpProcessor)this.getHttpProcessor().copy(), this.getHttpRequestRetryHandler(), this.getRedirectHandler(), this.getAuthenticationHandler(), this.getParams());
        }
        HttpResponse response = director.execute(roureq, (HttpContext)context);
        return response;
    }

    protected abstract RoutedRequest determineRoute(HttpHost var1, HttpRequest var2, HttpContext var3) throws HttpException;
}

