/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import org.apache.http.conn.HttpRoute;

public class RouteDirector {
    public static final int UNREACHABLE = -1;
    public static final int COMPLETE = 0;
    public static final int CONNECT_TARGET = 1;
    public static final int CONNECT_PROXY = 2;
    public static final int TUNNEL_TARGET = 3;
    public static final int TUNNEL_PROXY = 4;
    public static final int LAYER_PROTOCOL = 5;

    public int nextStep(HttpRoute plan, HttpRoute fact) {
        if (plan == null) {
            throw new IllegalArgumentException("Planned route may not be null.");
        }
        int step = -1;
        step = fact == null ? this.firstStep(plan) : (plan.getHopCount() > 1 ? this.proxiedStep(plan, fact) : this.directStep(plan, fact));
        return step;
    }

    protected int firstStep(HttpRoute plan) {
        return plan.getHopCount() > 1 ? 2 : 1;
    }

    protected int directStep(HttpRoute plan, HttpRoute fact) {
        if (fact.getHopCount() > 1) {
            return -1;
        }
        if (!plan.getTargetHost().equals((Object)fact.getTargetHost())) {
            return -1;
        }
        if (plan.isSecure() != fact.isSecure()) {
            return -1;
        }
        if (plan.getLocalAddress() != null && !plan.getLocalAddress().equals(fact.getLocalAddress())) {
            return -1;
        }
        return 0;
    }

    protected int proxiedStep(HttpRoute plan, HttpRoute fact) {
        int fhc;
        if (fact.getHopCount() <= 1) {
            return -1;
        }
        if (!plan.getTargetHost().equals((Object)fact.getTargetHost())) {
            return -1;
        }
        int phc = plan.getHopCount();
        if (phc < (fhc = fact.getHopCount())) {
            return -1;
        }
        for (int i = 0; i < fhc - 1; ++i) {
            if (plan.getHopTarget(i).equals((Object)fact.getHopTarget(i))) continue;
            return -1;
        }
        if (phc > fhc) {
            return 4;
        }
        if (fact.isTunnelled() && !plan.isTunnelled() || fact.isLayered() && !plan.isLayered()) {
            return -1;
        }
        if (plan.isTunnelled() && !fact.isTunnelled()) {
            return 3;
        }
        if (plan.isLayered() && !fact.isLayered()) {
            return 5;
        }
        if (plan.isSecure() != fact.isSecure()) {
            return -1;
        }
        return 0;
    }
}

