/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.ssl;

import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.apache.hc.client5.http.ssl.AbstractClientTlsStrategy;
import org.apache.hc.client5.http.ssl.HostnameVerificationPolicy;
import org.apache.hc.client5.http.ssl.HttpsSupport;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.ssl.SSLContexts;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class AbstractClientTlsStrategyTest {
    AbstractClientTlsStrategyTest() {
    }

    @Test
    void testToEscapedString_withControlCharacters() {
        X500Principal principal = new X500Principal("CN=Test\b\bName\n,O=TestOrg");
        AbstractClientTlsStrategy tlsStrategy = new AbstractClientTlsStrategy(SSLContexts.createDefault(), null, null, SSLBufferMode.STATIC, HostnameVerificationPolicy.BUILTIN, HttpsSupport.getDefaultHostnameVerifier()){

            void applyParameters(SSLEngine sslEngine, SSLParameters sslParameters, String[] appProtocols) {
            }

            TlsDetails createTlsDetails(SSLEngine sslEngine) {
                return null;
            }
        };
        String escaped = tlsStrategy.toEscapedString(principal);
        Assertions.assertEquals((Object)"CN=Test\\x08\\x08Name\\x0a,O=TestOrg", (Object)escaped);
    }

    @Test
    void testVerifySession_escapedPeerAndIssuer() throws Exception {
        SSLSession mockSession = (SSLSession)Mockito.mock(SSLSession.class);
        X509Certificate mockCert = (X509Certificate)Mockito.mock(X509Certificate.class);
        X500Principal peerPrincipal = new X500Principal("CN=Peer\bName,O=PeerOrg");
        X500Principal issuerPrincipal = new X500Principal("CN=Issuer\bName,O=IssuerOrg");
        Mockito.when((Object)mockSession.getPeerCertificates()).thenReturn((Object)new X509Certificate[]{mockCert});
        Mockito.when((Object)mockCert.getSubjectX500Principal()).thenReturn((Object)peerPrincipal);
        Mockito.when((Object)mockCert.getIssuerX500Principal()).thenReturn((Object)issuerPrincipal);
        AbstractClientTlsStrategy tlsStrategy = new AbstractClientTlsStrategy(SSLContexts.createDefault(), null, null, SSLBufferMode.STATIC, HostnameVerificationPolicy.BUILTIN, HttpsSupport.getDefaultHostnameVerifier()){

            void applyParameters(SSLEngine sslEngine, SSLParameters sslParameters, String[] appProtocols) {
            }

            TlsDetails createTlsDetails(SSLEngine sslEngine) {
                return null;
            }
        };
        tlsStrategy.verifySession("localhost", mockSession, null);
    }
}

