/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.psl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.apache.hc.client5.http.psl.DomainType;
import org.apache.hc.client5.http.psl.PublicSuffixListParser;
import org.apache.hc.client5.http.psl.PublicSuffixMatcher;
import org.apache.hc.client5.http.psl.PublicSuffixMatcherLoader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestPublicSuffixMatcher {
    private static final String SOURCE_FILE = "suffixlistmatcher.txt";
    private PublicSuffixMatcher matcher;
    private PublicSuffixMatcher pslMatcher;

    TestPublicSuffixMatcher() {
    }

    @BeforeEach
    void setUp() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream in = classLoader.getResourceAsStream(SOURCE_FILE);){
            Assertions.assertNotNull((Object)in, (String)SOURCE_FILE);
            List lists = PublicSuffixListParser.INSTANCE.parseByType((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
            this.matcher = new PublicSuffixMatcher((Collection)lists);
        }
        this.pslMatcher = PublicSuffixMatcherLoader.getDefault();
    }

    @Test
    void testGetDomainRootAnyType() {
        Assertions.assertEquals(null, (Object)this.matcher.getDomainRoot("com"));
        Assertions.assertEquals((Object)"blah.com", (Object)this.matcher.getDomainRoot("blah.com"));
        Assertions.assertEquals((Object)"foo.com", (Object)this.matcher.getDomainRoot("foo.com"));
        Assertions.assertEquals(null, (Object)this.matcher.getDomainRoot("blah.foo.com"));
        Assertions.assertEquals(null, (Object)this.matcher.getDomainRoot("booh.foo.com"));
        Assertions.assertEquals((Object)"blah.blah.foo.com", (Object)this.matcher.getDomainRoot("blah.blah.foo.com"));
        Assertions.assertEquals(null, (Object)this.matcher.getDomainRoot("kioto.jp"));
        Assertions.assertEquals(null, (Object)this.matcher.getDomainRoot("tokyo.jp"));
        Assertions.assertEquals(null, (Object)this.matcher.getDomainRoot("blah.tokyo.jp"));
        Assertions.assertEquals(null, (Object)this.matcher.getDomainRoot("booh.tokyo.jp"));
        Assertions.assertEquals((Object)"blah.blah.tokyo.jp", (Object)this.matcher.getDomainRoot("blah.blah.tokyo.jp"));
        Assertions.assertEquals((Object)"metro.tokyo.jp", (Object)this.matcher.getDomainRoot("metro.tokyo.jp"));
        Assertions.assertEquals((Object)"blah.ac.jp", (Object)this.matcher.getDomainRoot("blah.ac.jp"));
        Assertions.assertEquals((Object)"blah.ac.jp", (Object)this.matcher.getDomainRoot("blah.blah.ac.jp"));
        Assertions.assertEquals((Object)"metro.tokyo.jp", (Object)this.matcher.getDomainRoot("metro.tokyo.jp"));
        Assertions.assertEquals((Object)"example.xx", (Object)this.matcher.getDomainRoot("example.XX"));
        Assertions.assertEquals((Object)"example.xx", (Object)this.matcher.getDomainRoot("www.example.XX"));
        Assertions.assertEquals((Object)"example.xx", (Object)this.matcher.getDomainRoot("www.blah.blah.example.XX"));
        Assertions.assertEquals(null, (Object)this.matcher.getDomainRoot("appspot.com"));
        Assertions.assertEquals((Object)"example.appspot.com", (Object)this.matcher.getDomainRoot("example.appspot.com"));
        Assertions.assertEquals(null, (Object)this.matcher.getDomainRoot("s3.amazonaws.com"));
        Assertions.assertEquals(null, (Object)this.matcher.getDomainRoot("blah.s3.amazonaws.com"));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("jp"));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("ac.jp"));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("any.tokyo.jp"));
        Assertions.assertEquals(null, (Object)this.matcher.getDomainRoot("garbage"));
        Assertions.assertEquals((Object)"garbage.garbage", (Object)this.matcher.getDomainRoot("garbage.garbage"));
        Assertions.assertEquals((Object)"garbage.garbage", (Object)this.matcher.getDomainRoot("*.garbage.garbage"));
        Assertions.assertEquals((Object)"garbage.garbage", (Object)this.matcher.getDomainRoot("*.garbage.garbage.garbage"));
        Assertions.assertEquals(null, (Object)this.matcher.getDomainRoot("*.compute-1.amazonaws.com"));
        Assertions.assertEquals(null, (Object)this.matcher.getDomainRoot("blah.compute-1.amazonaws.com"));
        Assertions.assertEquals((Object)"blah.blah.compute-1.amazonaws.com", (Object)this.matcher.getDomainRoot("blah.blah.compute-1.amazonaws.com"));
    }

    @Test
    void testGetDomainRootOnlyPRIVATE() {
        Assertions.assertEquals((Object)"example.xx", (Object)this.matcher.getDomainRoot("example.XX", DomainType.PRIVATE));
        Assertions.assertEquals((Object)"example.xx", (Object)this.matcher.getDomainRoot("www.example.XX", DomainType.PRIVATE));
        Assertions.assertEquals((Object)"example.xx", (Object)this.matcher.getDomainRoot("www.blah.blah.example.XX", DomainType.PRIVATE));
        Assertions.assertEquals((Object)"example.appspot.com", (Object)this.matcher.getDomainRoot("example.appspot.com"));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("jp", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("ac.jp", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("any.tokyo.jp", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("metro.tokyo.jp", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("blah.blah.tokyo.jp", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("blah.blah.ac.jp", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("garbage", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("garbage.garbage", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("*.garbage.garbage", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("*.garbage.garbage.garbage", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("s3.amazonaws.com"));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("blah.s3.amazonaws.com"));
    }

    @Test
    void testGetDomainRootOnlyICANN() {
        Assertions.assertNull((Object)this.matcher.getDomainRoot("example.XX", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("www.example.XX", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("www.blah.blah.example.XX", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("xx", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("jp", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("ac.jp", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("any.tokyo.jp", DomainType.ICANN));
        Assertions.assertEquals((Object)"metro.tokyo.jp", (Object)this.matcher.getDomainRoot("metro.tokyo.jp", DomainType.ICANN));
        Assertions.assertEquals((Object)"blah.blah.tokyo.jp", (Object)this.matcher.getDomainRoot("blah.blah.tokyo.jp", DomainType.ICANN));
        Assertions.assertEquals((Object)"blah.ac.jp", (Object)this.matcher.getDomainRoot("blah.blah.ac.jp", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("garbage", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("garbage.garbage", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("*.garbage.garbage", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("*.garbage.garbage.garbage", DomainType.ICANN));
    }

    @Test
    void testMaySetCookies() {
        Assertions.assertTrue((boolean)this.matcher.verify("foo.com"));
        Assertions.assertFalse((boolean)this.matcher.verify("bar.foo.com"));
        Assertions.assertTrue((boolean)this.matcher.verify("example.bar.foo.com"));
        Assertions.assertTrue((boolean)this.matcher.verify("foo.bar.jp"));
        Assertions.assertFalse((boolean)this.matcher.verify("bar.jp"));
        Assertions.assertTrue((boolean)this.matcher.verify("foo.bar.hokkaido.jp"));
        Assertions.assertFalse((boolean)this.matcher.verify("bar.hokkaido.jp"));
        Assertions.assertTrue((boolean)this.matcher.verify("foo.bar.tokyo.jp"));
        Assertions.assertFalse((boolean)this.matcher.verify("bar.tokyo.jp"));
        Assertions.assertTrue((boolean)this.matcher.verify("pref.hokkaido.jp"));
        Assertions.assertTrue((boolean)this.matcher.verify("metro.tokyo.jp"));
    }

    @Test
    void testVerifyPrivate() {
        Assertions.assertTrue((boolean)this.matcher.verify("s3.amazonaws.com"));
        Assertions.assertTrue((boolean)this.matcher.verify("blah.s3.amazonaws.com"));
        Assertions.assertTrue((boolean)this.matcher.verify("blah.xxx.uk"));
    }

    @Test
    void testMatch() {
        Assertions.assertTrue((boolean)this.matcher.matches(".jp"));
        Assertions.assertTrue((boolean)this.matcher.matches(".ac.jp"));
        Assertions.assertTrue((boolean)this.matcher.matches(".any.tokyo.jp"));
        Assertions.assertTrue((boolean)this.matcher.matches(".xx"));
        Assertions.assertTrue((boolean)this.matcher.matches(".appspot.com"));
        Assertions.assertFalse((boolean)this.matcher.matches(".metro.tokyo.jp"));
    }

    @Test
    void testMatchUnicode() {
        Assertions.assertTrue((boolean)this.matcher.matches(".h\u00e5.no"));
        Assertions.assertTrue((boolean)this.matcher.matches(".xn--h-2fa.no"));
        Assertions.assertTrue((boolean)this.matcher.matches(".h\u00e5.no"));
        Assertions.assertTrue((boolean)this.matcher.matches(".xn--h-2fa.no"));
    }

    private void checkPublicSuffix(String input, String expected) {
        Assertions.assertEquals((Object)expected, (Object)this.pslMatcher.getDomainRoot(input));
    }

    @Test
    void testGetDomainRootPublicSuffixList() {
        this.checkPublicSuffix(null, null);
        this.checkPublicSuffix("COM", null);
        this.checkPublicSuffix("example.COM", "example.com");
        this.checkPublicSuffix("WwW.example.COM", "example.com");
        this.checkPublicSuffix(".com", null);
        this.checkPublicSuffix(".example", null);
        this.checkPublicSuffix(".example.com", null);
        this.checkPublicSuffix(".example.example", null);
        this.checkPublicSuffix("example", null);
        this.checkPublicSuffix("example.example", "example.example");
        this.checkPublicSuffix("b.example.example", "example.example");
        this.checkPublicSuffix("a.b.example.example", "example.example");
        this.checkPublicSuffix("biz", null);
        this.checkPublicSuffix("domain.biz", "domain.biz");
        this.checkPublicSuffix("b.domain.biz", "domain.biz");
        this.checkPublicSuffix("a.b.domain.biz", "domain.biz");
        this.checkPublicSuffix("com", null);
        this.checkPublicSuffix("example.com", "example.com");
        this.checkPublicSuffix("b.example.com", "example.com");
        this.checkPublicSuffix("a.b.example.com", "example.com");
        this.checkPublicSuffix("uk.com", null);
        this.checkPublicSuffix("example.uk.com", "example.uk.com");
        this.checkPublicSuffix("b.example.uk.com", "example.uk.com");
        this.checkPublicSuffix("a.b.example.uk.com", "example.uk.com");
        this.checkPublicSuffix("test.ac", "test.ac");
        this.checkPublicSuffix("mm", null);
        this.checkPublicSuffix("c.mm", null);
        this.checkPublicSuffix("b.c.mm", "b.c.mm");
        this.checkPublicSuffix("a.b.c.mm", "b.c.mm");
        this.checkPublicSuffix("jp", null);
        this.checkPublicSuffix("test.jp", "test.jp");
        this.checkPublicSuffix("www.test.jp", "test.jp");
        this.checkPublicSuffix("ac.jp", null);
        this.checkPublicSuffix("test.ac.jp", "test.ac.jp");
        this.checkPublicSuffix("www.test.ac.jp", "test.ac.jp");
        this.checkPublicSuffix("kyoto.jp", null);
        this.checkPublicSuffix("test.kyoto.jp", "test.kyoto.jp");
        this.checkPublicSuffix("ide.kyoto.jp", null);
        this.checkPublicSuffix("b.ide.kyoto.jp", "b.ide.kyoto.jp");
        this.checkPublicSuffix("a.b.ide.kyoto.jp", "b.ide.kyoto.jp");
        this.checkPublicSuffix("c.kobe.jp", null);
        this.checkPublicSuffix("b.c.kobe.jp", "b.c.kobe.jp");
        this.checkPublicSuffix("a.b.c.kobe.jp", "b.c.kobe.jp");
        this.checkPublicSuffix("city.kobe.jp", "city.kobe.jp");
        this.checkPublicSuffix("www.city.kobe.jp", "city.kobe.jp");
        this.checkPublicSuffix("ck", null);
        this.checkPublicSuffix("test.ck", null);
        this.checkPublicSuffix("b.test.ck", "b.test.ck");
        this.checkPublicSuffix("a.b.test.ck", "b.test.ck");
        this.checkPublicSuffix("www.ck", "www.ck");
        this.checkPublicSuffix("www.www.ck", "www.ck");
        this.checkPublicSuffix("us", null);
        this.checkPublicSuffix("test.us", "test.us");
        this.checkPublicSuffix("www.test.us", "test.us");
        this.checkPublicSuffix("ak.us", null);
        this.checkPublicSuffix("test.ak.us", "test.ak.us");
        this.checkPublicSuffix("www.test.ak.us", "test.ak.us");
        this.checkPublicSuffix("k12.ak.us", null);
        this.checkPublicSuffix("test.k12.ak.us", "test.k12.ak.us");
        this.checkPublicSuffix("www.test.k12.ak.us", "test.k12.ak.us");
        this.checkPublicSuffix("\u98df\u72ee.com.cn", "\u98df\u72ee.com.cn");
        this.checkPublicSuffix("\u98df\u72ee.\u516c\u53f8.cn", "\u98df\u72ee.\u516c\u53f8.cn");
        this.checkPublicSuffix("www.\u98df\u72ee.\u516c\u53f8.cn", "\u98df\u72ee.\u516c\u53f8.cn");
        this.checkPublicSuffix("shishi.\u516c\u53f8.cn", "shishi.\u516c\u53f8.cn");
        this.checkPublicSuffix("\u516c\u53f8.cn", null);
        this.checkPublicSuffix("\u98df\u72ee.\u4e2d\u56fd", "\u98df\u72ee.\u4e2d\u56fd");
        this.checkPublicSuffix("www.\u98df\u72ee.\u4e2d\u56fd", "\u98df\u72ee.\u4e2d\u56fd");
        this.checkPublicSuffix("shishi.\u4e2d\u56fd", "shishi.\u4e2d\u56fd");
        this.checkPublicSuffix("\u4e2d\u56fd", null);
        this.checkPublicSuffix("xn--85x722f.com.cn", "xn--85x722f.com.cn");
        this.checkPublicSuffix("xn--85x722f.xn--55qx5d.cn", "xn--85x722f.xn--55qx5d.cn");
        this.checkPublicSuffix("www.xn--85x722f.xn--55qx5d.cn", "xn--85x722f.xn--55qx5d.cn");
        this.checkPublicSuffix("shishi.xn--55qx5d.cn", "shishi.xn--55qx5d.cn");
        this.checkPublicSuffix("xn--55qx5d.cn", null);
        this.checkPublicSuffix("xn--85x722f.xn--fiqs8s", "xn--85x722f.xn--fiqs8s");
        this.checkPublicSuffix("www.xn--85x722f.xn--fiqs8s", "xn--85x722f.xn--fiqs8s");
        this.checkPublicSuffix("shishi.xn--fiqs8s", "shishi.xn--fiqs8s");
        this.checkPublicSuffix("xn--fiqs8s", null);
    }
}

