/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import org.apache.hc.client5.http.impl.nio.H2SharingConnPool;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.PoolEntry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class H2SharingPerRoutePoolTest {
    H2SharingConnPool.PerRoutePool<String, HttpConnection> pool;
    PoolEntry<String, HttpConnection> poolEntry1;
    PoolEntry<String, HttpConnection> poolEntry2;

    static PoolEntry<String, HttpConnection> createMockEntry() {
        PoolEntry poolEntry = new PoolEntry((Object)"some route");
        HttpConnection conn = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn.isOpen()).thenReturn((Object)true);
        poolEntry.assignConnection((ModalCloseable)conn);
        return poolEntry;
    }

    @BeforeEach
    void setup() {
        this.pool = new H2SharingConnPool.PerRoutePool();
        this.poolEntry1 = H2SharingPerRoutePoolTest.createMockEntry();
        this.poolEntry2 = H2SharingPerRoutePoolTest.createMockEntry();
    }

    @Test
    void testKeep() {
        Assertions.assertEquals((long)1L, (long)this.pool.track(this.poolEntry1));
        Assertions.assertEquals((long)2L, (long)this.pool.track(this.poolEntry1));
        Assertions.assertEquals((long)1L, (long)this.pool.track(this.poolEntry2));
        Assertions.assertEquals((long)3L, (long)this.pool.track(this.poolEntry1));
    }

    @Test
    void testLeaseLeastUsed() {
        this.pool.track(this.poolEntry1);
        this.pool.track(this.poolEntry1);
        this.pool.track(this.poolEntry2);
        Assertions.assertSame(this.poolEntry2, (Object)this.pool.lease());
        Assertions.assertEquals((long)2L, (long)this.pool.getCount(this.poolEntry2));
        PoolEntry poolEntry = this.pool.lease();
        Assertions.assertEquals((long)3L, (long)this.pool.getCount(poolEntry));
    }

    @Test
    void testLeaseEmptyPool() {
        Assertions.assertNull((Object)this.pool.lease());
    }

    @Test
    void testReleaseReusable() {
        this.pool.track(this.poolEntry1);
        this.pool.track(this.poolEntry1);
        this.pool.track(this.poolEntry1);
        Assertions.assertEquals((long)2L, (long)this.pool.release(this.poolEntry1, true));
        Assertions.assertEquals((long)1L, (long)this.pool.release(this.poolEntry1, true));
        Assertions.assertEquals((long)0L, (long)this.pool.release(this.poolEntry1, true));
        Assertions.assertEquals((long)0L, (long)this.pool.release(this.poolEntry1, true));
    }

    @Test
    void testReleaseNonReusable() {
        this.pool.track(this.poolEntry1);
        this.pool.track(this.poolEntry1);
        this.pool.track(this.poolEntry1);
        Assertions.assertEquals((long)2L, (long)this.pool.release(this.poolEntry1, false));
    }

    @Test
    void testReleaseNonPresent() {
        Assertions.assertEquals((long)0L, (long)this.pool.release(this.poolEntry1, true));
        Assertions.assertEquals((long)0L, (long)this.pool.release(this.poolEntry2, true));
    }

    @Test
    void testReleaseConnectionClosed() {
        this.pool.track(this.poolEntry1);
        this.pool.track(this.poolEntry1);
        this.pool.track(this.poolEntry1);
        Mockito.when((Object)((HttpConnection)this.poolEntry1.getConnection()).isOpen()).thenReturn((Object)false);
        Assertions.assertEquals((long)2L, (long)this.pool.release(this.poolEntry1, true));
    }

    @Test
    void testReleaseConnectionMissing() {
        this.pool.track(this.poolEntry1);
        this.pool.track(this.poolEntry1);
        this.pool.track(this.poolEntry1);
        this.poolEntry1.discardConnection(CloseMode.IMMEDIATE);
        Assertions.assertEquals((long)2L, (long)this.pool.release(this.poolEntry1, true));
    }
}

