/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLSocket;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.io.DefaultHttpClientConnectionOperator;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.DetachedSocketFactory;
import org.apache.hc.client5.http.io.HttpClientConnectionOperator;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.StrictConnPool;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

class TestPoolingHttpClientConnectionManager {
    @Mock
    private ManagedHttpClientConnection conn;
    @Mock
    private Lookup<TlsSocketStrategy> tlsSocketStrategyLookup;
    @Mock
    private DetachedSocketFactory detachedSocketFactory;
    @Mock
    private TlsSocketStrategy tlsSocketStrategy;
    @Mock
    private Socket socket;
    @Mock
    private SSLSocket upgradedSocket;
    @Mock
    private SchemePortResolver schemePortResolver;
    @Mock
    private DnsResolver dnsResolver;
    @Mock
    private Future<PoolEntry<HttpRoute, ManagedHttpClientConnection>> future;
    @Mock
    private StrictConnPool<HttpRoute, ManagedHttpClientConnection> pool;
    private PoolingHttpClientConnectionManager mgr;

    TestPoolingHttpClientConnectionManager() {
    }

    @BeforeEach
    void setup() {
        MockitoAnnotations.openMocks((Object)this);
        this.mgr = new PoolingHttpClientConnectionManager((HttpClientConnectionOperator)new DefaultHttpClientConnectionOperator(this.detachedSocketFactory, this.schemePortResolver, this.dnsResolver, this.tlsSocketStrategyLookup), this.pool, null);
    }

    @Test
    void testLeaseRelease() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        PoolEntry entry = new PoolEntry((Object)route, TimeValue.NEG_ONE_MILLISECOND);
        entry.assignConnection((ModalCloseable)this.conn);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.conn.isConsistent()).thenReturn((Object)true);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ofSeconds((long)1L));
        Assertions.assertNotNull((Object)endpoint1);
        Assertions.assertNotSame((Object)this.conn, (Object)endpoint1);
        this.mgr.release(endpoint1, null, TimeValue.NEG_ONE_MILLISECOND);
        ((StrictConnPool)Mockito.verify(this.pool)).release(entry, true);
    }

    @Test
    void testReleaseRouteIncomplete() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        PoolEntry entry = new PoolEntry((Object)route, TimeValue.NEG_ONE_MILLISECOND);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ofSeconds((long)1L));
        Assertions.assertNotNull((Object)endpoint1);
        Assertions.assertNotSame((Object)this.conn, (Object)endpoint1);
        this.mgr.release(endpoint1, null, TimeValue.NEG_ONE_MILLISECOND);
        ((StrictConnPool)Mockito.verify(this.pool)).release(entry, false);
    }

    @Test
    void testLeaseFutureTimeout() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenThrow(new Throwable[]{new TimeoutException()});
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        Assertions.assertThrows(TimeoutException.class, () -> connRequest1.get(Timeout.ofSeconds((long)1L)));
    }

    @Test
    void testReleaseReusable() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        PoolEntry entry = new PoolEntry((Object)route, TimeValue.NEG_ONE_MILLISECOND);
        entry.assignConnection((ModalCloseable)this.conn);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.conn.isConsistent()).thenReturn((Object)true);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ofSeconds((long)1L));
        Assertions.assertNotNull((Object)endpoint1);
        Assertions.assertTrue((boolean)endpoint1.isConnected());
        this.mgr.release(endpoint1, (Object)"some state", TimeValue.NEG_ONE_MILLISECOND);
        ((StrictConnPool)Mockito.verify(this.pool)).release(entry, true);
        Assertions.assertEquals((Object)"some state", (Object)entry.getState());
    }

    @Test
    void testReleaseNonReusable() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        PoolEntry entry = new PoolEntry((Object)route, TimeValue.NEG_ONE_MILLISECOND);
        entry.assignConnection((ModalCloseable)this.conn);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.FALSE);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ofSeconds((long)1L));
        Assertions.assertNotNull((Object)endpoint1);
        Assertions.assertFalse((boolean)endpoint1.isConnected());
        this.mgr.release(endpoint1, (Object)"some state", TimeValue.NEG_ONE_MILLISECOND);
        ((StrictConnPool)Mockito.verify(this.pool)).release(entry, false);
        Assertions.assertNull((Object)entry.getState());
    }

    @Test
    void testTargetConnect() throws Exception {
        HttpHost target = new HttpHost("https", "somehost", 443);
        InetAddress remote = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        HttpRoute route = new HttpRoute(target, local, true);
        PoolEntry entry = new PoolEntry((Object)route, TimeValue.NEG_ONE_MILLISECOND);
        entry.assignConnection((ModalCloseable)this.conn);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)false);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ofSeconds((long)1L));
        Assertions.assertNotNull((Object)endpoint1);
        HttpClientContext context = HttpClientContext.create();
        SocketConfig sconfig = SocketConfig.custom().build();
        this.mgr.setDefaultSocketConfig(sconfig);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(234L, TimeUnit.MILLISECONDS).build();
        this.mgr.setDefaultConnectionConfig(connectionConfig);
        TlsConfig tlsConfig = TlsConfig.custom().setHandshakeTimeout(345L, TimeUnit.MILLISECONDS).build();
        this.mgr.setDefaultTlsConfig(tlsConfig);
        Mockito.when((Object)this.dnsResolver.resolve("somehost", 8443)).thenReturn(Collections.singletonList(new InetSocketAddress(remote, 8443)));
        Mockito.when((Object)this.schemePortResolver.resolve(target.getSchemeName(), (NamedEndpoint)target)).thenReturn((Object)8443);
        Mockito.when((Object)this.detachedSocketFactory.create((String)Mockito.any(), (Proxy)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.tlsSocketStrategyLookup.lookup("https")).thenReturn((Object)this.tlsSocketStrategy);
        Mockito.when((Object)this.tlsSocketStrategy.upgrade((Socket)Mockito.same((Object)this.socket), (String)Mockito.eq((Object)"somehost"), Mockito.anyInt(), Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.upgradedSocket);
        this.mgr.connect(endpoint1, null, (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)1))).resolve("somehost", 8443);
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(target.getSchemeName(), (NamedEndpoint)target);
        ((DetachedSocketFactory)Mockito.verify((Object)this.detachedSocketFactory, (VerificationMode)Mockito.times((int)1))).create("https", null);
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).connect(new InetSocketAddress(remote, 8443), 234);
        ((TlsSocketStrategy)Mockito.verify((Object)this.tlsSocketStrategy)).upgrade(this.socket, "somehost", 443, (Object)tlsConfig, (HttpContext)context);
        this.mgr.connect(endpoint1, TimeValue.ofMilliseconds((long)123L), (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)2))).resolve("somehost", 8443);
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)2))).resolve(target.getSchemeName(), (NamedEndpoint)target);
        ((DetachedSocketFactory)Mockito.verify((Object)this.detachedSocketFactory, (VerificationMode)Mockito.times((int)2))).create("https", null);
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).connect(new InetSocketAddress(remote, 8443), 123);
        ((TlsSocketStrategy)Mockito.verify((Object)this.tlsSocketStrategy, (VerificationMode)Mockito.times((int)2))).upgrade(this.socket, "somehost", 443, (Object)tlsConfig, (HttpContext)context);
    }

    @Test
    void testProxyConnectAndUpgrade() throws Exception {
        HttpHost target = new HttpHost("https", "somehost", 443);
        HttpHost proxy = new HttpHost("someproxy", 8080);
        InetAddress remote = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        HttpRoute route = new HttpRoute(target, local, proxy, true);
        PoolEntry entry = new PoolEntry((Object)route, TimeValue.NEG_ONE_MILLISECOND);
        entry.assignConnection((ModalCloseable)this.conn);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)false);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ofSeconds((long)1L));
        Assertions.assertNotNull((Object)endpoint1);
        HttpClientContext context = HttpClientContext.create();
        SocketConfig sconfig = SocketConfig.custom().build();
        this.mgr.setDefaultSocketConfig(sconfig);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(234L, TimeUnit.MILLISECONDS).build();
        this.mgr.setDefaultConnectionConfig(connectionConfig);
        TlsConfig tlsConfig = TlsConfig.custom().setHandshakeTimeout(345L, TimeUnit.MILLISECONDS).build();
        this.mgr.setDefaultTlsConfig(tlsConfig);
        Mockito.when((Object)this.dnsResolver.resolve("someproxy", 8080)).thenReturn(Collections.singletonList(new InetSocketAddress(remote, 8080)));
        Mockito.when((Object)this.schemePortResolver.resolve(proxy.getSchemeName(), (NamedEndpoint)proxy)).thenReturn((Object)8080);
        Mockito.when((Object)this.schemePortResolver.resolve(target.getSchemeName(), (NamedEndpoint)target)).thenReturn((Object)8443);
        Mockito.when((Object)this.tlsSocketStrategyLookup.lookup("https")).thenReturn((Object)this.tlsSocketStrategy);
        Mockito.when((Object)this.detachedSocketFactory.create((String)Mockito.any(), (Proxy)Mockito.any())).thenReturn((Object)this.socket);
        this.mgr.connect(endpoint1, null, (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)1))).resolve("someproxy", 8080);
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(proxy.getSchemeName(), (NamedEndpoint)proxy);
        ((DetachedSocketFactory)Mockito.verify((Object)this.detachedSocketFactory, (VerificationMode)Mockito.times((int)1))).create("http", null);
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).connect(new InetSocketAddress(remote, 8080), 234);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.conn.getSocket()).thenReturn((Object)this.socket);
        this.mgr.upgrade(endpoint1, (HttpContext)context);
        ((TlsSocketStrategy)Mockito.verify((Object)this.tlsSocketStrategy, (VerificationMode)Mockito.times((int)1))).upgrade(this.socket, "somehost", 443, (Object)tlsConfig, (HttpContext)context);
    }

    @Test
    void testIsShutdownInitially() {
        Assertions.assertFalse((boolean)this.mgr.isClosed(), (String)"Connection manager should not be shutdown initially.");
    }

    @Test
    void testShutdownIdempotency() {
        this.mgr.close();
        Assertions.assertTrue((boolean)this.mgr.isClosed(), (String)"Connection manager should remain shutdown after the first call to shutdown.");
        this.mgr.close();
        Assertions.assertTrue((boolean)this.mgr.isClosed(), (String)"Connection manager should still be shutdown after subsequent calls to shutdown.");
    }

    @Test
    void testLeaseAfterShutdown() {
        this.mgr.close();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgr.lease("some-id", new HttpRoute(new HttpHost("localhost")), null), (String)"Attempting to lease a connection after shutdown should throw an exception.");
    }

    @Test
    void testIsShutdown() {
        Mockito.when((Object)this.pool.isShutdown()).thenReturn((Object)false, (Object[])new Boolean[]{true});
        Assertions.assertFalse((boolean)this.mgr.isClosed(), (String)"Connection manager should not be shutdown initially.");
        this.mgr.close();
        Assertions.assertTrue((boolean)this.mgr.isClosed(), (String)"Connection manager should be shutdown after close() is called.");
    }

    @Test
    void testConcurrentShutdown() throws InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.submit(() -> this.mgr.close());
        executor.submit(() -> this.mgr.close());
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.mgr.isClosed(), (String)"Connection manager should be shutdown after concurrent calls to shutdown.");
    }
}

