/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hc.client5.http.impl.routing.DistributedProxySelector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class DistributedProxySelectorTest {
    DistributedProxySelectorTest() {
    }

    @Test
    void testConstructorThrowsExceptionWhenNullSelectors() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DistributedProxySelector(null));
    }

    @Test
    void testConstructorThrowsExceptionWhenEmptySelectors() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DistributedProxySelector(Collections.emptyList()));
    }

    @Test
    void testSelectReturnsProxyFromFirstSelector() {
        ProxySelector selector1 = new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Arrays.asList(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("proxy1.example.com", 8080)), new Proxy(Proxy.Type.HTTP, new InetSocketAddress("proxy2.example.com", 8080)));
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        };
        ProxySelector selector2 = new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Collections.singletonList(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("proxy3.example.com", 8080)));
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        };
        DistributedProxySelector failoverSelector = new DistributedProxySelector(Arrays.asList(selector1, selector2));
        URI uri = URI.create("http://example.com");
        List proxies = failoverSelector.select(uri);
        Assertions.assertEquals((int)2, (int)proxies.size());
        Assertions.assertEquals((Object)"proxy1.example.com", (Object)((InetSocketAddress)((Proxy)proxies.get(0)).address()).getHostName());
        Assertions.assertEquals((Object)"proxy2.example.com", (Object)((InetSocketAddress)((Proxy)proxies.get(1)).address()).getHostName());
    }

    @Test
    void testSelectReturnsProxyFromSecondSelector() {
        ProxySelector selector1 = new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Collections.emptyList();
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        };
        ProxySelector selector2 = new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Collections.singletonList(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("proxy3.example.com", 8080)));
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        };
        DistributedProxySelector failoverSelector = new DistributedProxySelector(Arrays.asList(selector1, selector2));
        URI uri = URI.create("http://example.com");
        List proxies = failoverSelector.select(uri);
        Assertions.assertEquals((int)1, (int)proxies.size());
        Assertions.assertEquals((Object)"proxy3.example.com", (Object)((InetSocketAddress)((Proxy)proxies.get(0)).address()).getHostName());
    }

    @Test
    void testSelectReturnsProxyFromThirdSelector() {
        ProxySelector selector1 = new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Collections.emptyList();
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        };
        ProxySelector selector2 = (ProxySelector)Mockito.mock(ProxySelector.class);
        Mockito.when(selector2.select((URI)ArgumentMatchers.any(URI.class))).thenReturn(Collections.singletonList(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("proxy3.example.com", 8080))));
        DistributedProxySelector proxySelector = new DistributedProxySelector(Arrays.asList(selector1, selector2));
        URI uri = URI.create("http://example.com");
        List proxies = proxySelector.select(uri);
        Assertions.assertEquals((int)1, (int)proxies.size(), (String)"Expecting one proxy to be returned");
        Assertions.assertEquals((Object)"proxy3.example.com", (Object)((InetSocketAddress)((Proxy)proxies.get(0)).address()).getHostName(), (String)"Expecting proxy3.example.com to be returned");
        InetSocketAddress sa = new InetSocketAddress("proxy3.example.com", 8080);
        IOException ioe = new IOException("Connection refused");
        proxySelector.connectFailed(uri, (SocketAddress)sa, ioe);
        ((ProxySelector)Mockito.verify((Object)selector2, (VerificationMode)Mockito.never())).connectFailed(uri, sa, ioe);
    }

    @Test
    void testSelectReturnsProxyFromSecondSelectorWhenFirstSelectorReturnsEmptyList() {
        ProxySelector selector1 = new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Collections.emptyList();
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        };
        ProxySelector selector2 = new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Collections.singletonList(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("proxy3.example.com", 8080)));
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        };
        DistributedProxySelector failoverSelector = new DistributedProxySelector(Arrays.asList(selector1, selector2));
        URI uri = URI.create("http://example.com");
        List proxies = failoverSelector.select(uri);
        Assertions.assertEquals((int)1, (int)proxies.size());
        Assertions.assertEquals((Object)"proxy3.example.com", (Object)((InetSocketAddress)((Proxy)proxies.get(0)).address()).getHostName());
    }

    @Test
    void testSelectHandlesException() {
        ProxySelector exceptionThrowingSelector = new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                throw new RuntimeException("Exception for testing");
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        };
        ProxySelector workingSelector = new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Collections.singletonList(new Proxy(Proxy.Type.HTTP, new InetSocketAddress("proxy.example.com", 8080)));
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        };
        DistributedProxySelector distributedSelector = new DistributedProxySelector(Arrays.asList(exceptionThrowingSelector, workingSelector));
        URI uri = URI.create("http://example.com");
        List proxies = distributedSelector.select(uri);
        Assertions.assertEquals((int)1, (int)proxies.size());
        Assertions.assertEquals((Object)"proxy.example.com", (Object)((InetSocketAddress)((Proxy)proxies.get(0)).address()).getHostName());
    }
}

