/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.BearerToken;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BearerScheme;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBearerScheme {
    TestBearerScheme() {
    }

    @Test
    void testBearerAuthenticationEmptyChallenge() throws Exception {
        AuthChallenge authChallenge = new AuthChallenge(ChallengeType.TARGET, "BEARER", new NameValuePair[0]);
        BearerScheme authscheme = new BearerScheme();
        authscheme.processChallenge(authChallenge, null);
        Assertions.assertNull((Object)authscheme.getRealm());
    }

    @Test
    void testBearerAuthentication() throws Exception {
        AuthChallenge authChallenge = new AuthChallenge(ChallengeType.TARGET, "Bearer", new NameValuePair[]{new BasicNameValuePair("realm", "test")});
        BearerScheme authscheme = new BearerScheme();
        authscheme.processChallenge(authChallenge, null);
        HttpHost host = new HttpHost("somehost", 80);
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(host, "test", null), (Credentials)new BearerToken("some token")).build();
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        Assertions.assertTrue((boolean)authscheme.isResponseReady(host, credentialsProvider, null));
        authscheme.generateAuthResponse(host, (HttpRequest)request, null);
        Assertions.assertEquals((Object)"test", (Object)authscheme.getRealm());
        Assertions.assertTrue((boolean)authscheme.isChallengeComplete());
        Assertions.assertFalse((boolean)authscheme.isConnectionBased());
    }

    @Test
    void testStateStorage() throws Exception {
        AuthChallenge authChallenge = new AuthChallenge(ChallengeType.TARGET, "Bearer", new NameValuePair[]{new BasicNameValuePair("realm", "test"), new BasicNameValuePair("code", "read")});
        BearerScheme authscheme = new BearerScheme();
        authscheme.processChallenge(authChallenge, null);
        BearerScheme.State state = authscheme.store();
        BearerScheme cached = new BearerScheme();
        cached.restore(state);
        Assertions.assertEquals((Object)cached.getName(), (Object)cached.getName());
        Assertions.assertEquals((Object)cached.getRealm(), (Object)cached.getRealm());
        Assertions.assertEquals((Object)cached.isChallengeComplete(), (Object)cached.isChallengeComplete());
    }
}

