/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import org.apache.hc.client5.http.impl.ProtocolSwitchStrategy;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.ssl.TLS;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestProtocolSwitchStrategy {
    ProtocolSwitchStrategy switchStrategy;

    TestProtocolSwitchStrategy() {
    }

    @BeforeEach
    void setUp() {
        this.switchStrategy = new ProtocolSwitchStrategy();
    }

    @Test
    void testSwitchToTLS() throws Exception {
        BasicHttpResponse response1 = new BasicHttpResponse(101);
        response1.addHeader("Upgrade", (Object)"TLS");
        Assertions.assertEquals((Object)TLS.V_1_2.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response1));
        BasicHttpResponse response2 = new BasicHttpResponse(101);
        response2.addHeader("Upgrade", (Object)"TLS/1.3");
        Assertions.assertEquals((Object)TLS.V_1_3.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response2));
    }

    @Test
    void testSwitchToHTTP11AndTLS() throws Exception {
        BasicHttpResponse response1 = new BasicHttpResponse(101);
        response1.addHeader("Upgrade", (Object)"TLS, HTTP/1.1");
        Assertions.assertEquals((Object)TLS.V_1_2.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response1));
        BasicHttpResponse response2 = new BasicHttpResponse(101);
        response2.addHeader("Upgrade", (Object)",, HTTP/1.1, TLS, ");
        Assertions.assertEquals((Object)TLS.V_1_2.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response2));
        BasicHttpResponse response3 = new BasicHttpResponse(101);
        response3.addHeader("Upgrade", (Object)"HTTP/1.1");
        response3.addHeader("Upgrade", (Object)"TLS/1.2");
        Assertions.assertEquals((Object)TLS.V_1_2.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response3));
        BasicHttpResponse response4 = new BasicHttpResponse(101);
        response4.addHeader("Upgrade", (Object)"HTTP/1.1");
        response4.addHeader("Upgrade", (Object)"TLS/1.2, TLS/1.3");
        Assertions.assertEquals((Object)TLS.V_1_3.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response4));
    }

    @Test
    void testSwitchInvalid() {
        BasicHttpResponse response1 = new BasicHttpResponse(101);
        response1.addHeader("Upgrade", (Object)"Crap");
        Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testSwitchInvalid$0((HttpResponse)response1));
        BasicHttpResponse response2 = new BasicHttpResponse(101);
        response2.addHeader("Upgrade", (Object)"TLS, huh?");
        Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testSwitchInvalid$1((HttpResponse)response2));
        BasicHttpResponse response3 = new BasicHttpResponse(101);
        response3.addHeader("Upgrade", (Object)",,,");
        Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testSwitchInvalid$2((HttpResponse)response3));
    }

    @Test
    void testNullToken() throws ProtocolException {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"TLS,");
        response.addHeader("Upgrade", null);
        Assertions.assertEquals((Object)TLS.V_1_2.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response));
    }

    @Test
    void testWhitespaceOnlyToken() throws ProtocolException {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"   , TLS");
        Assertions.assertEquals((Object)TLS.V_1_2.getVersion(), (Object)this.switchStrategy.switchProtocol((HttpMessage)response));
    }

    @Test
    void testUnsupportedTlsVersion() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"TLS/1.4");
        Assertions.assertEquals((Object)new ProtocolVersion("TLS", 1, 4), (Object)this.switchStrategy.switchProtocol((HttpMessage)response));
    }

    @Test
    void testUnsupportedTlsMajorVersion() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"TLS/2.0");
        Assertions.assertEquals((Object)new ProtocolVersion("TLS", 2, 0), (Object)this.switchStrategy.switchProtocol((HttpMessage)response));
    }

    @Test
    void testUnsupportedHttpVersion() {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"HTTP/2.0");
        ProtocolException ex = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testUnsupportedHttpVersion$3((HttpResponse)response));
        Assertions.assertEquals((Object)"Unsupported protocol or HTTP version: HTTP/2.0", (Object)ex.getMessage());
    }

    @Test
    void testInvalidTlsFormat() {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"TLS/abc");
        ProtocolException ex = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testInvalidTlsFormat$4((HttpResponse)response));
        Assertions.assertEquals((Object)"Invalid TLS major version number; error at offset 7: <TLS/abc>", (Object)ex.getMessage());
    }

    @Test
    void testHttp11Only() {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"HTTP/1.1");
        ProtocolException ex = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testHttp11Only$5((HttpResponse)response));
        Assertions.assertEquals((Object)"Invalid protocol switch response: no TLS version found", (Object)ex.getMessage());
    }

    @Test
    void testSwitchToTlsValid_TLS_1_2() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"TLS/1.2");
        ProtocolVersion result = this.switchStrategy.switchProtocol((HttpMessage)response);
        Assertions.assertEquals((Object)TLS.V_1_2.getVersion(), (Object)result);
    }

    @Test
    void testSwitchToTlsValid_TLS_1_0() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"TLS/1.0");
        ProtocolVersion result = this.switchStrategy.switchProtocol((HttpMessage)response);
        Assertions.assertEquals((Object)TLS.V_1_0.getVersion(), (Object)result);
    }

    @Test
    void testSwitchToTlsValid_TLS_1_1() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"TLS/1.1");
        ProtocolVersion result = this.switchStrategy.switchProtocol((HttpMessage)response);
        Assertions.assertEquals((Object)TLS.V_1_1.getVersion(), (Object)result);
    }

    @Test
    void testInvalidTlsFormat_NoSlash() {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"TLSv1");
        ProtocolException ex = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testInvalidTlsFormat_NoSlash$6((HttpResponse)response));
        Assertions.assertEquals((Object)"Unsupported or invalid protocol: TLSv1", (Object)ex.getMessage());
    }

    @Test
    void testSwitchToTlsValid_TLS_1() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"TLS/1");
        ProtocolVersion result = this.switchStrategy.switchProtocol((HttpMessage)response);
        Assertions.assertEquals((Object)TLS.V_1_0.getVersion(), (Object)result);
    }

    @Test
    void testInvalidTlsFormat_MissingMajor() {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"TLS/.1");
        ProtocolException ex = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testInvalidTlsFormat_MissingMajor$7((HttpResponse)response));
        Assertions.assertEquals((Object)"Invalid TLS major version number; error at offset 4: <TLS/.1>", (Object)ex.getMessage());
    }

    @Test
    void testMultipleHttp11Tokens() {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"HTTP/1.1, HTTP/1.1");
        ProtocolException ex = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testMultipleHttp11Tokens$8((HttpResponse)response));
        Assertions.assertEquals((Object)"Invalid protocol switch response: no TLS version found", (Object)ex.getMessage());
    }

    @Test
    void testMixedInvalidAndValidTokens() {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)"Crap, TLS/1.2, Invalid");
        ProtocolException ex = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testMixedInvalidAndValidTokens$9((HttpResponse)response));
        Assertions.assertEquals((Object)"Unsupported or invalid protocol: Crap", (Object)ex.getMessage());
    }

    @Test
    void testInvalidTlsFormat_NoProtocolName() {
        BasicHttpResponse response = new BasicHttpResponse(101);
        response.addHeader("Upgrade", (Object)",,/1.1");
        ProtocolException ex = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testInvalidTlsFormat_NoProtocolName$10((HttpResponse)response));
        Assertions.assertEquals((Object)"Invalid protocol; error at offset 2: <,,/1.1>", (Object)ex.getMessage());
    }

    private /* synthetic */ void lambda$testInvalidTlsFormat_NoProtocolName$10(HttpResponse response) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response);
    }

    private /* synthetic */ void lambda$testMixedInvalidAndValidTokens$9(HttpResponse response) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response);
    }

    private /* synthetic */ void lambda$testMultipleHttp11Tokens$8(HttpResponse response) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response);
    }

    private /* synthetic */ void lambda$testInvalidTlsFormat_MissingMajor$7(HttpResponse response) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response);
    }

    private /* synthetic */ void lambda$testInvalidTlsFormat_NoSlash$6(HttpResponse response) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response);
    }

    private /* synthetic */ void lambda$testHttp11Only$5(HttpResponse response) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response);
    }

    private /* synthetic */ void lambda$testInvalidTlsFormat$4(HttpResponse response) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response);
    }

    private /* synthetic */ void lambda$testUnsupportedHttpVersion$3(HttpResponse response) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response);
    }

    private /* synthetic */ void lambda$testSwitchInvalid$2(HttpResponse response3) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response3);
    }

    private /* synthetic */ void lambda$testSwitchInvalid$1(HttpResponse response2) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response2);
    }

    private /* synthetic */ void lambda$testSwitchInvalid$0(HttpResponse response1) throws Throwable {
        this.switchStrategy.switchProtocol((HttpMessage)response1);
    }
}

