/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.LaxRedirectStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestLaxRedirectStrategy {
    TestLaxRedirectStrategy() {
    }

    @Test
    void testIsRedirectedWithHttpGet() {
        this.testIsRedirected((HttpRequest)new HttpGet("/get"), true);
    }

    @Test
    void testIsRedirectedWithHttpPost() {
        this.testIsRedirected((HttpRequest)new HttpPost("/post"), true);
    }

    @Test
    void testIsRedirectedWithHttpHead() {
        this.testIsRedirected((HttpRequest)new HttpHead("/head"), true);
    }

    @Test
    void testIsRedirectedWithHttpDelete() {
        this.testIsRedirected((HttpRequest)new HttpDelete("/delete"), true);
    }

    @Test
    void testIsRedirectedWithNonRedirectMethod() {
        this.testIsRedirected((HttpRequest)new HttpPut("/put"), false);
    }

    private void testIsRedirected(HttpRequest request, boolean expected) {
        LaxRedirectStrategy strategy = new LaxRedirectStrategy();
        HttpResponse response = (HttpResponse)Mockito.mock(HttpResponse.class);
        HttpContext context = (HttpContext)Mockito.mock(HttpContext.class);
        Mockito.when((Object)response.getCode()).thenReturn((Object)302);
        Mockito.when((Object)response.containsHeader("Location")).thenReturn((Object)true);
        Mockito.when((Object)response.getFirstHeader("location")).thenReturn(Mockito.mock(Header.class));
        Mockito.when((Object)response.getFirstHeader("location").getValue()).thenReturn((Object)"http://localhost/redirect");
        Assertions.assertEquals((Object)expected, (Object)strategy.isRedirected(request, response, context));
    }
}

