/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.util.concurrent.Future;
import javax.net.ssl.SSLSession;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.io.CloseMode;

public class AsyncClientHttpVersionPolicy {
    public static void main(String[] args) throws Exception {
        PoolingAsyncClientConnectionManager cm = PoolingAsyncClientConnectionManagerBuilder.create().setTlsConfigResolver(httphost -> TlsConfig.custom().setVersionPolicy(HttpVersionPolicy.NEGOTIATE).build()).build();
        try (CloseableHttpAsyncClient client = HttpAsyncClients.custom().setConnectionManager((AsyncClientConnectionManager)cm).build();){
            client.start();
            HttpHost target = new HttpHost("https", "httpbin.org");
            final HttpClientContext clientContext = HttpClientContext.create();
            final SimpleHttpRequest request = SimpleRequestBuilder.get().setHttpHost(target).setPath("/").build();
            System.out.println("Executing request " + request);
            Future future = client.execute((AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)request), (AsyncResponseConsumer)SimpleResponseConsumer.create(), (HttpContext)clientContext, (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                public void completed(SimpleHttpResponse response) {
                    System.out.println(request + "->" + new StatusLine((HttpResponse)response));
                    System.out.println("HTTP protocol " + clientContext.getProtocolVersion());
                    SSLSession sslSession = clientContext.getSSLSession();
                    if (sslSession != null) {
                        System.out.println("SSL protocol " + sslSession.getProtocol());
                        System.out.println("SSL cipher suite " + sslSession.getCipherSuite());
                    }
                    System.out.println(response.getBody());
                }

                public void failed(Exception ex) {
                    System.out.println(request + "->" + ex);
                }

                public void cancelled() {
                    System.out.println(request + " cancelled");
                }
            });
            future.get();
            System.out.println("Shutting down");
            client.close(CloseMode.GRACEFUL);
        }
    }
}

