/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.HttpRFC6532Multipart;
import org.apache.hc.client5.http.entity.mime.HttpStrictMultipart;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.LegacyMultipart;
import org.apache.hc.client5.http.entity.mime.MultipartPart;
import org.apache.hc.client5.http.entity.mime.MultipartPartBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ContentType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestMultipartMixed {
    private File tmpfile;
    private static final int[] SWISS_GERMAN_HELLO = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    private static final int[] RUSSIAN_HELLO = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    TestMultipartMixed() {
    }

    @AfterEach
    void cleanup() {
        if (this.tmpfile != null) {
            this.tmpfile.delete();
        }
    }

    @Test
    void testMultipartPartStringParts() throws Exception {
        MultipartPart p1 = MultipartPartBuilder.create((ContentBody)new StringBody("this stuff", ContentType.DEFAULT_TEXT)).build();
        MultipartPart p2 = MultipartPartBuilder.create((ContentBody)new StringBody("that stuff", ContentType.create((String)ContentType.TEXT_PLAIN.getMimeType(), (Charset)StandardCharsets.ISO_8859_1))).build();
        MultipartPart p3 = MultipartPartBuilder.create((ContentBody)new StringBody("all kind of stuff", ContentType.DEFAULT_TEXT)).build();
        HttpStrictMultipart multipart = new HttpStrictMultipart(null, "foo", Arrays.asList(p1, p2, p3));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        multipart.writeTo((OutputStream)out);
        out.close();
        String expected = "--foo\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\nthis stuff\r\n--foo\r\nContent-Type: text/plain; charset=ISO-8859-1\r\n\r\nthat stuff\r\n--foo\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\nall kind of stuff\r\n--foo--\r\n";
        String s = out.toString("US-ASCII");
        Assertions.assertEquals((Object)"--foo\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\nthis stuff\r\n--foo\r\nContent-Type: text/plain; charset=ISO-8859-1\r\n\r\nthat stuff\r\n--foo\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\nall kind of stuff\r\n--foo--\r\n", (Object)s);
        Assertions.assertEquals((long)s.length(), (long)multipart.getTotalLength());
    }

    @Test
    void testMultipartPartCustomContentType() throws Exception {
        MultipartPart p1 = MultipartPartBuilder.create((ContentBody)new StringBody("this stuff", ContentType.DEFAULT_TEXT)).build();
        MultipartPart p2 = MultipartPartBuilder.create((ContentBody)new StringBody("that stuff", ContentType.parse((CharSequence)"stuff/plain; param=value"))).build();
        HttpStrictMultipart multipart = new HttpStrictMultipart(null, "foo", Arrays.asList(p1, p2));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        multipart.writeTo((OutputStream)out);
        out.close();
        String expected = "--foo\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\nthis stuff\r\n--foo\r\nContent-Type: stuff/plain; param=value\r\n\r\nthat stuff\r\n--foo--\r\n";
        String s = out.toString("US-ASCII");
        Assertions.assertEquals((Object)"--foo\r\nContent-Type: text/plain; charset=UTF-8\r\n\r\nthis stuff\r\n--foo\r\nContent-Type: stuff/plain; param=value\r\n\r\nthat stuff\r\n--foo--\r\n", (Object)s);
        Assertions.assertEquals((long)s.length(), (long)multipart.getTotalLength());
    }

    @Test
    void testMultipartPartBinaryParts() throws Exception {
        this.tmpfile = File.createTempFile("tmp", ".bin");
        try (FileWriter writer = new FileWriter(this.tmpfile);){
            ((Writer)writer).append("some random whatever");
        }
        MultipartPart p1 = MultipartPartBuilder.create((ContentBody)new FileBody(this.tmpfile)).build();
        MultipartPart p2 = MultipartPartBuilder.create((ContentBody)new InputStreamBody((InputStream)new FileInputStream(this.tmpfile), "file.tmp")).build();
        HttpStrictMultipart multipart = new HttpStrictMultipart(null, "foo", Arrays.asList(p1, p2));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        multipart.writeTo((OutputStream)out);
        out.close();
        String expected = "--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo--\r\n";
        String s = out.toString("US-ASCII");
        Assertions.assertEquals((Object)"--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo--\r\n", (Object)s);
        Assertions.assertEquals((long)-1L, (long)multipart.getTotalLength());
    }

    @Test
    void testMultipartPartStrict() throws Exception {
        this.tmpfile = File.createTempFile("tmp", ".bin");
        try (FileWriter writer = new FileWriter(this.tmpfile);){
            ((Writer)writer).append("some random whatever");
        }
        MultipartPart p1 = MultipartPartBuilder.create((ContentBody)new FileBody(this.tmpfile)).build();
        MultipartPart p2 = MultipartPartBuilder.create((ContentBody)new FileBody(this.tmpfile, ContentType.create((String)"text/plain", (String)"ANSI_X3.4-1968"), "test-file")).build();
        MultipartPart p3 = MultipartPartBuilder.create((ContentBody)new InputStreamBody((InputStream)new FileInputStream(this.tmpfile), "file.tmp")).build();
        HttpStrictMultipart multipart = new HttpStrictMultipart(null, "foo", Arrays.asList(p1, p2, p3));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        multipart.writeTo((OutputStream)out);
        out.close();
        String expected = "--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nsome random whatever\r\n--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo--\r\n";
        String s = out.toString("US-ASCII");
        Assertions.assertEquals((Object)"--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nsome random whatever\r\n--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo--\r\n", (Object)s);
        Assertions.assertEquals((long)-1L, (long)multipart.getTotalLength());
    }

    @Test
    void testMultipartPartRFC6532() throws Exception {
        this.tmpfile = File.createTempFile("tmp", ".bin");
        try (FileWriter writer = new FileWriter(this.tmpfile);){
            ((Writer)writer).append("some random whatever");
        }
        MultipartPart p1 = MultipartPartBuilder.create((ContentBody)new FileBody(this.tmpfile)).build();
        MultipartPart p2 = MultipartPartBuilder.create((ContentBody)new FileBody(this.tmpfile, ContentType.create((String)"text/plain", (String)"ANSI_X3.4-1968"), "test-file")).build();
        MultipartPart p3 = MultipartPartBuilder.create((ContentBody)new InputStreamBody((InputStream)new FileInputStream(this.tmpfile), "file.tmp")).build();
        HttpRFC6532Multipart multipart = new HttpRFC6532Multipart(null, "foo", Arrays.asList(p1, p2, p3));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        multipart.writeTo((OutputStream)out);
        out.close();
        String expected = "--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nsome random whatever\r\n--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo--\r\n";
        String s = out.toString("UTF-8");
        Assertions.assertEquals((Object)"--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nsome random whatever\r\n--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo--\r\n", (Object)s);
        Assertions.assertEquals((long)-1L, (long)multipart.getTotalLength());
    }

    private static String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    void testMultipartPartBrowserCompatibleNonASCIIHeaders() throws Exception {
        String s1 = TestMultipartMixed.constructString(SWISS_GERMAN_HELLO);
        String s2 = TestMultipartMixed.constructString(RUSSIAN_HELLO);
        this.tmpfile = File.createTempFile("tmp", ".bin");
        try (FileWriter writer = new FileWriter(this.tmpfile);){
            ((Writer)writer).append("some random whatever");
        }
        MultipartPart p1 = MultipartPartBuilder.create((ContentBody)new InputStreamBody((InputStream)new FileInputStream(this.tmpfile), s1 + ".tmp")).build();
        MultipartPart p2 = MultipartPartBuilder.create((ContentBody)new InputStreamBody((InputStream)new FileInputStream(this.tmpfile), s2 + ".tmp")).build();
        LegacyMultipart multipart = new LegacyMultipart(StandardCharsets.UTF_8, "foo", Arrays.asList(p1, p2));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        multipart.writeTo((OutputStream)out);
        out.close();
        String expected = "--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo--\r\n";
        String s = out.toString("UTF-8");
        Assertions.assertEquals((Object)"--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo\r\nContent-Type: application/octet-stream\r\n\r\nsome random whatever\r\n--foo--\r\n", (Object)s);
        Assertions.assertEquals((long)-1L, (long)multipart.getTotalLength());
    }

    @Test
    void testMultipartPartStringPartsMultiCharsets() throws Exception {
        String s1 = TestMultipartMixed.constructString(SWISS_GERMAN_HELLO);
        String s2 = TestMultipartMixed.constructString(RUSSIAN_HELLO);
        MultipartPart p1 = MultipartPartBuilder.create((ContentBody)new StringBody(s1, ContentType.create((String)"text/plain", (Charset)StandardCharsets.ISO_8859_1))).build();
        MultipartPart p2 = MultipartPartBuilder.create((ContentBody)new StringBody(s2, ContentType.create((String)"text/plain", (Charset)Charset.forName("KOI8-R")))).build();
        HttpStrictMultipart multipart = new HttpStrictMultipart(null, "foo", Arrays.asList(p1, p2));
        ByteArrayOutputStream out1 = new ByteArrayOutputStream();
        multipart.writeTo((OutputStream)out1);
        out1.close();
        ByteArrayOutputStream out2 = new ByteArrayOutputStream();
        out2.write("--foo\r\nContent-Type: text/plain; charset=ISO-8859-1\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        out2.write(s1.getBytes(StandardCharsets.ISO_8859_1));
        out2.write("\r\n--foo\r\nContent-Type: text/plain; charset=KOI8-R\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        out2.write(s2.getBytes(Charset.forName("KOI8-R")));
        out2.write("\r\n--foo--\r\n".getBytes(StandardCharsets.US_ASCII));
        out2.close();
        byte[] actual = out1.toByteArray();
        byte[] expected = out2.toByteArray();
        Assertions.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < actual.length; ++i) {
            Assertions.assertEquals((byte)expected[i], (byte)actual[i]);
        }
        Assertions.assertEquals((long)expected.length, (long)multipart.getTotalLength());
    }
}

