/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.validator;

import org.apache.hc.client5.http.validator.ETag;
import org.apache.hc.client5.http.validator.ValidatorType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestETag {
    TestETag() {
    }

    @Test
    void testHashCodeEquals() {
        ETag tag1 = new ETag("this");
        ETag tag2 = new ETag("this");
        ETag tag3 = new ETag("this", ValidatorType.WEAK);
        ETag tag4 = new ETag("that", ValidatorType.WEAK);
        Assertions.assertEquals((int)tag1.hashCode(), (int)tag2.hashCode());
        Assertions.assertNotEquals((int)tag2.hashCode(), (int)tag3.hashCode());
        Assertions.assertNotEquals((int)tag3.hashCode(), (int)tag4.hashCode());
        Assertions.assertEquals((Object)tag1, (Object)tag2);
        Assertions.assertNotEquals((Object)tag2, (Object)tag3);
        Assertions.assertNotEquals((Object)tag3, (Object)tag4);
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)"\"blah\"", (Object)new ETag("blah").toString());
        Assertions.assertEquals((Object)"W/\"blah\"", (Object)new ETag("blah", ValidatorType.WEAK).toString());
        Assertions.assertEquals((Object)"\"\"", (Object)new ETag("").toString());
    }

    @Test
    void testParse() {
        Assertions.assertEquals((Object)new ETag("blah", ValidatorType.WEAK), (Object)ETag.parse((String)"  W/\"blah\"  "));
        Assertions.assertEquals((Object)new ETag(" huh?"), (Object)ETag.parse((String)"  \" huh?\"   "));
        Assertions.assertEquals((Object)new ETag(" ", ValidatorType.WEAK), (Object)ETag.parse((String)"W/\" \""));
        Assertions.assertEquals((Object)new ETag(""), (Object)ETag.parse((String)"\"\""));
        Assertions.assertNull((Object)ETag.parse((String)"wrong"));
        Assertions.assertNull((Object)ETag.parse((String)"w/\"wrong\""));
        Assertions.assertNull((Object)ETag.parse((String)"W /\"wrong\""));
        Assertions.assertNull((Object)ETag.parse((String)"W/ \"wrong\""));
        Assertions.assertNull((Object)ETag.parse((String)"W/wrong"));
        Assertions.assertNull((Object)ETag.parse((String)"\"cut"));
        Assertions.assertNull((Object)ETag.parse((String)"    \""));
        Assertions.assertNull((Object)ETag.parse((String)"W/\""));
    }

    @Test
    void testComparison() {
        Assertions.assertFalse((boolean)ETag.strongCompare((ETag)new ETag("1", ValidatorType.WEAK), (ETag)new ETag("1", ValidatorType.WEAK)));
        Assertions.assertTrue((boolean)ETag.weakCompare((ETag)new ETag("1", ValidatorType.WEAK), (ETag)new ETag("1", ValidatorType.WEAK)));
        Assertions.assertFalse((boolean)ETag.strongCompare((ETag)new ETag("1", ValidatorType.WEAK), (ETag)new ETag("2", ValidatorType.WEAK)));
        Assertions.assertFalse((boolean)ETag.weakCompare((ETag)new ETag("1", ValidatorType.WEAK), (ETag)new ETag("2", ValidatorType.WEAK)));
        Assertions.assertFalse((boolean)ETag.strongCompare((ETag)new ETag("1", ValidatorType.WEAK), (ETag)new ETag("1")));
        Assertions.assertTrue((boolean)ETag.weakCompare((ETag)new ETag("1", ValidatorType.WEAK), (ETag)new ETag("1")));
        Assertions.assertTrue((boolean)ETag.strongCompare((ETag)new ETag("1"), (ETag)new ETag("1")));
        Assertions.assertTrue((boolean)ETag.weakCompare((ETag)new ETag("1"), (ETag)new ETag("1")));
        Assertions.assertFalse((boolean)ETag.weakCompare((ETag)new ETag("1", ValidatorType.WEAK), null));
        Assertions.assertFalse((boolean)ETag.weakCompare(null, (ETag)new ETag("1", ValidatorType.WEAK)));
        Assertions.assertFalse((boolean)ETag.weakCompare(null, null));
        Assertions.assertFalse((boolean)ETag.strongCompare((ETag)new ETag("1"), null));
        Assertions.assertFalse((boolean)ETag.strongCompare(null, (ETag)new ETag("1")));
        Assertions.assertFalse((boolean)ETag.strongCompare(null, null));
    }
}

