/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.psl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hc.client5.http.psl.DomainType;
import org.apache.hc.client5.http.psl.PublicSuffixList;
import org.apache.hc.client5.http.psl.PublicSuffixListParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestPublicSuffixListParser {
    private static final String SUFFIXLIST_TXT = "suffixlist.txt";
    private static final String SUFFIXLIST2_TXT = "suffixlist2.txt";

    TestPublicSuffixListParser() {
    }

    @Test
    void testParse() throws Exception {
        PublicSuffixList suffixList;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream in = classLoader.getResourceAsStream(SUFFIXLIST_TXT);){
            Assertions.assertNotNull((Object)in, (String)SUFFIXLIST_TXT);
            PublicSuffixListParser parser = PublicSuffixListParser.INSTANCE;
            suffixList = parser.parse((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        }
        Assertions.assertNotNull((Object)suffixList);
        Assertions.assertEquals(Arrays.asList("xx", "jp", "ac.jp", "*.tokyo.jp", "no", "h\u00e5.no"), (Object)suffixList.getRules());
        Assertions.assertEquals(Collections.singletonList("metro.tokyo.jp"), (Object)suffixList.getExceptions());
    }

    @Test
    void testParseByType() throws Exception {
        List suffixLists;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream in = classLoader.getResourceAsStream(SUFFIXLIST2_TXT);){
            Assertions.assertNotNull((Object)in, (String)SUFFIXLIST2_TXT);
            PublicSuffixListParser parser = PublicSuffixListParser.INSTANCE;
            suffixLists = parser.parseByType((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        }
        Assertions.assertNotNull((Object)suffixLists);
        Assertions.assertEquals((int)2, (int)suffixLists.size());
        PublicSuffixList publicSuffixList1 = (PublicSuffixList)suffixLists.get(0);
        Assertions.assertNotNull((Object)publicSuffixList1);
        Assertions.assertEquals((Object)DomainType.ICANN, (Object)publicSuffixList1.getType());
        Assertions.assertEquals(Arrays.asList("jp", "ac.jp", "*.tokyo.jp"), (Object)publicSuffixList1.getRules());
        Assertions.assertEquals(Collections.singletonList("metro.tokyo.jp"), (Object)publicSuffixList1.getExceptions());
        PublicSuffixList publicSuffixList2 = (PublicSuffixList)suffixLists.get(1);
        Assertions.assertNotNull((Object)publicSuffixList2);
        Assertions.assertEquals((Object)DomainType.PRIVATE, (Object)publicSuffixList2.getType());
        Assertions.assertEquals(Arrays.asList("googleapis.com", "googlecode.com"), (Object)publicSuffixList2.getRules());
        Assertions.assertEquals(Collections.emptyList(), (Object)publicSuffixList2.getExceptions());
    }
}

