/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.io.IOException;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RequestValidateTrace;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.BasicEntityDetails;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestRequestValidateTrace {
    private RequestValidateTrace interceptor;
    private HttpRequest request;
    private HttpContext context;

    TestRequestValidateTrace() {
    }

    @BeforeEach
    void setUp() {
        this.interceptor = new RequestValidateTrace();
        this.context = HttpClientContext.create();
    }

    @Test
    void testTraceRequestWithoutSensitiveHeaders() throws HttpException, IOException {
        this.request = new BasicHttpRequest("TRACE", "/");
        this.interceptor.process(this.request, null, this.context);
        Assertions.assertNull((Object)this.request.getHeader("Authorization"));
    }

    @Test
    void testTraceRequestWithSensitiveHeaders() {
        this.request = new BasicHttpRequest("TRACE", "/");
        this.request.setHeader("Authorization", (Object)"Bearer token");
        Assertions.assertThrows(ProtocolException.class, () -> this.interceptor.process(this.request, null, this.context));
    }

    @Test
    void testTraceRequestWithBody() {
        this.request = new BasicHttpRequest("TRACE", "/");
        BasicEntityDetails entity = new BasicEntityDetails(10L, null);
        Assertions.assertThrows(ProtocolException.class, () -> this.lambda$testTraceRequestWithBody$1((EntityDetails)entity));
    }

    @Test
    void testNonTraceRequest() throws HttpException, IOException {
        this.request = new BasicHttpRequest("GET", "/");
        this.request.setHeader("Authorization", (Object)"Bearer token");
        this.interceptor.process(this.request, null, this.context);
        Assertions.assertNotNull((Object)this.request.getHeader("Authorization"));
    }

    @Test
    void testTraceRequestWithCookieHeader() {
        this.request = new BasicHttpRequest("TRACE", "/");
        this.request.setHeader("Cookie", (Object)"someCookie=someValue");
        Assertions.assertThrows(ProtocolException.class, () -> this.interceptor.process(this.request, null, this.context));
    }

    private /* synthetic */ void lambda$testTraceRequestWithBody$1(EntityDetails entity) throws Throwable {
        this.interceptor.process(this.request, entity, this.context);
    }
}

