/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.ResponseEntityProxy;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.impl.io.ChunkedInputStream;
import org.apache.hc.core5.http.impl.io.SessionInputBufferImpl;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.apache.hc.core5.http.io.entity.BasicHttpEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class TestResponseEntityProxy {
    @Mock
    private ClassicHttpResponse response;
    @Mock
    private ExecRuntime execRuntime;
    @Mock
    private HttpEntity entity;

    TestResponseEntityProxy() {
    }

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.response.getEntity()).thenReturn((Object)this.entity);
    }

    @Test
    void testGetTrailersWithNoChunkedInputStream() throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("Test payload".getBytes());
        Mockito.when((Object)this.entity.getContent()).thenReturn((Object)inputStream);
        ArgumentCaptor httpEntityArgumentCaptor = ArgumentCaptor.forClass(HttpEntity.class);
        ResponseEntityProxy.enhance((ClassicHttpResponse)this.response, (ExecRuntime)this.execRuntime);
        ((ClassicHttpResponse)Mockito.verify((Object)this.response)).setEntity((HttpEntity)httpEntityArgumentCaptor.capture());
        HttpEntity wrappedEntity = (HttpEntity)httpEntityArgumentCaptor.getValue();
        InputStream is = wrappedEntity.getContent();
        while (is.read() != -1) {
        }
        Supplier trailers = wrappedEntity.getTrailers();
        Assertions.assertTrue((boolean)((List)trailers.get()).isEmpty());
    }

    @Test
    void testGetTrailersWithChunkedInputStream() throws Exception {
        SessionInputBufferImpl sessionInputBuffer = new SessionInputBufferImpl(100);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("0\r\nX-Test-Trailer-Header: test\r\n".getBytes());
        ChunkedInputStream chunkedInputStream = new ChunkedInputStream((SessionInputBuffer)sessionInputBuffer, (InputStream)inputStream);
        Mockito.when((Object)this.entity.getContent()).thenReturn((Object)chunkedInputStream);
        ArgumentCaptor httpEntityArgumentCaptor = ArgumentCaptor.forClass(HttpEntity.class);
        ResponseEntityProxy.enhance((ClassicHttpResponse)this.response, (ExecRuntime)this.execRuntime);
        ((ClassicHttpResponse)Mockito.verify((Object)this.response)).setEntity((HttpEntity)httpEntityArgumentCaptor.capture());
        HttpEntity wrappedEntity = (HttpEntity)httpEntityArgumentCaptor.getValue();
        InputStream is = wrappedEntity.getContent();
        while (is.read() != -1) {
        }
        Supplier trailers = wrappedEntity.getTrailers();
        List headers = (List)trailers.get();
        Assertions.assertEquals((int)1, (int)headers.size());
        Header header = (Header)headers.get(0);
        Assertions.assertEquals((Object)"X-Test-Trailer-Header", (Object)header.getName());
        Assertions.assertEquals((Object)"test", (Object)header.getValue());
    }

    @Test
    void testWriteToNullDrainsAndReleasesStream() throws Exception {
        SessionInputBufferImpl sessionInputBuffer = new SessionInputBufferImpl(100);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("0\r\nX-Test-Trailer-Header: test\r\n".getBytes());
        ChunkedInputStream chunkedInputStream = new ChunkedInputStream((SessionInputBuffer)sessionInputBuffer, (InputStream)inputStream);
        CloseableHttpResponse resp = new CloseableHttpResponse((ClassicHttpResponse)new BasicClassicHttpResponse(200), this.execRuntime);
        BasicHttpEntity entity = new BasicHttpEntity((InputStream)chunkedInputStream, null, true);
        Assertions.assertTrue((boolean)entity.isStreaming());
        resp.setEntity((HttpEntity)entity);
        ResponseEntityProxy.enhance((ClassicHttpResponse)resp, (ExecRuntime)this.execRuntime);
        HttpEntity wrappedEntity = resp.getEntity();
        wrappedEntity.writeTo(null);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).releaseEndpoint();
        Supplier trailers = wrappedEntity.getTrailers();
        List headers = (List)trailers.get();
        Assertions.assertEquals((int)1, (int)headers.size());
        Header header = (Header)headers.get(0);
        Assertions.assertEquals((Object)"X-Test-Trailer-Header", (Object)header.getName());
        Assertions.assertEquals((Object)"test", (Object)header.getValue());
    }
}

